<?php
declare(strict_types=1);


namespace DailyTarot\Calendar;
if (!defined('ABSPATH')) { exit; }
// phpcs:disable WordPress.Security.NonceVerification.Missing, WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.MissingUnslash



final class DayEntryStorageAdmin {

    public static function handleMigrateToTable(): void {
        if (!current_user_can('manage_options')) {
            wp_die(esc_html__('Forbidden','daily-tarot'));
        }

        check_admin_referer('dtarot_calendar_storage');

        $replace = isset($_POST['replace']) && sanitize_text_field((string)wp_unslash($_POST['replace'])) === '1';

        $res = DayEntryRepository::migrateOptionToTable($replace);

        $url = admin_url('admin.php?page=daily-tarot-settings&tab=diagnostics');
        $args = [
            'dtarot_calendar_migrate' => (!empty($res['ok']) ? 'ok' : 'error'),
            'count' => isset($res['count']) ? (string)absint($res['count']) : '0',
            'msg' => isset($res['msg']) ? sanitize_text_field((string)$res['msg']) : '',
        ];
        wp_safe_redirect(add_query_arg($args, $url));
        exit;
    }
}
