<?php
declare(strict_types=1);


namespace DailyTarot\CPT;
if (!defined('ABSPATH')) { exit; }

use DailyTarot\Support\PostTypes;


final class ReadingType {

    public static function register(): void {
        add_action('init', static function (): void {
            register_post_type(PostTypes::READING_TYPE, [
                'labels' => [
                    'name' => __('Reading Types','daily-tarot'),
                    'singular_name' => __('Reading Type','daily-tarot'),
                    'add_new_item' => __('Add Reading Type','daily-tarot'),
                    'edit_item' => __('Edit Reading Type','daily-tarot'),
                ],
                'public' => false,
                'show_ui' => true,
                'show_in_menu' => false,
                'supports' => ['title','editor'],
                'rewrite' => false,
            ]);

            // Back-compat.
            if (!post_type_exists(PostTypes::LEGACY_READING_TYPE)) {
                register_post_type(PostTypes::LEGACY_READING_TYPE, [
                    'labels' => [
                        'name' => __('Reading Types','daily-tarot'),
                        'singular_name' => __('Reading Type','daily-tarot'),
                    ],
                    'public' => false,
                    'show_ui' => true,
                    'show_in_menu' => false,
                    'supports' => ['title','editor'],
                    'rewrite' => false,
                ]);
            }
        });
    }
}
