<?php
declare(strict_types=1);


namespace DailyTarot\CPT;
if (!defined('ABSPATH')) { exit; }


use DailyTarot\Registry\Cards;
use DailyTarot\Support\PostTypes;

final class Deck {

    public static function register(): void {
        add_action('init', static function (): void {
            register_post_type(PostTypes::DECK, [
                'labels' => [
                    'name'          => __('Decks','daily-tarot'),
                    'singular_name' => __('Deck','daily-tarot'),
                    'add_new_item'  => __('Add Deck','daily-tarot'),
                    'edit_item'     => __('Edit Deck','daily-tarot'),
                ],
                'public'       => false,
                'show_ui'      => true,
                'show_in_menu' => false, // managed under Daily Tarot -> Content tabs
                'supports'     => ['title'],
                'rewrite'      => false,
            ]);

            // Back-compat: keep legacy post type registered so old URLs/admin screens work.
            if (!post_type_exists(PostTypes::LEGACY_DECK)) {
                register_post_type(PostTypes::LEGACY_DECK, [
                    'labels' => [
                        'name'          => __('Decks','daily-tarot'),
                        'singular_name' => __('Deck','daily-tarot'),
                    ],
                    'public'       => false,
                    'show_ui'      => true,
                    'show_in_menu' => false,
                    'supports'     => ['title'],
                    'rewrite'      => false,
                ]);
            }
        });

        // Admin list table column preview (edit.php?post_type=dtarot_deck).
        add_filter('manage_' . PostTypes::DECK . '_posts_columns', static function (array $cols): array {
            // Insert after checkbox.
            $out = [];
            foreach ($cols as $k => $v) {
                $out[$k] = $v;
                if ($k === 'cb') {
                    $out['dtarot_preview'] = __('Preview','daily-tarot');
                }
            }
            if (!isset($out['dtarot_preview'])) {
                $out = ['dtarot_preview' => __('Preview','daily-tarot')] + $cols;
            }
            return $out;
        });

        add_action('manage_' . PostTypes::DECK . '_posts_custom_column', static function (string $column, int $postId): void {
            if ($column !== 'dtarot_preview') return;

            $back = (string)get_post_meta($postId, '_dtarot_back', true);
            $preview = $back;
            if ($preview === '') {
                $imgs = get_post_meta($postId, '_dtarot_cards', true);
                if (is_array($imgs)) {
                    foreach ($imgs as $u) {
                        if (is_string($u) && trim($u) !== '') {
                            $preview = $u;
                            break;
                        }
                        if (is_numeric($u) && trim((string)$u) !== '') {
                            $preview = (string)$u;
                            break;
                        }
                    }
                }
            }

            echo '<div class="dtarot-card-preview">';
            if ($preview !== '') {
                echo '<img class="dtarot-card-preview-img" src="' . esc_url($preview) . '" alt="" />';
            } else {
                echo '<div class="dtarot-card-preview-empty">—</div>';
            }
            echo '</div>';
        }, 10, 2);

        // Legacy list table hooks.
        add_filter('manage_' . PostTypes::LEGACY_DECK . '_posts_columns', static function (array $cols): array {
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core list-table hook name.
            return (array)apply_filters('manage_' . PostTypes::DECK . '_posts_columns', $cols);
        });
        add_action('manage_' . PostTypes::LEGACY_DECK . '_posts_custom_column', static function (string $column, int $postId): void {
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core list-table hook name.
            do_action('manage_' . PostTypes::DECK . '_posts_custom_column', $column, $postId);
        }, 10, 2);
    }
}
