<?php
declare(strict_types=1);

namespace DailyTarot;

if (!defined('ABSPATH')) { exit; }

final class Autoloader {
    public static function init(): void {
        spl_autoload_register([__CLASS__, 'load']);
    }

    public static function load(string $class): void {
        if (strpos($class, __NAMESPACE__ . '\\') !== 0) return;

        $rel = substr($class, strlen(__NAMESPACE__) + 1);
        $rel = str_replace('\\', '/', $rel);
        $file = DTAROT_PATH . 'includes/' . $rel . '.php';
        if (is_readable($file)) require_once $file;
    }
}
