<?php
declare(strict_types=1);

namespace DailyTarot\Admin;

if (!defined('ABSPATH')) { exit; }

final class StarterDecksPrompt {

    private const OPT_DISMISSED = 'dtarot_starter_decks_dismissed';
    private const OPT_SEEN = 'dtarot_starter_decks_seen';

    public static function init(): void {
        add_action('admin_post_dtarot_starter_decks_dismiss', [__CLASS__, 'dismiss']);
    }

    public static function isDismissed(): bool {
        return (string)get_option(self::OPT_DISMISSED, '') === '1';
    }

    public static function markSeen(): void {
        if ((string)get_option(self::OPT_SEEN, '') === '1') return;
        update_option(self::OPT_SEEN, '1', false);
    }

    public static function dismiss(): void {
        if (!current_user_can('manage_options')) {
            wp_die(esc_html__('Forbidden','daily-tarot'));
        }
        check_admin_referer('dtarot_starter_decks_dismiss');

        update_option(self::OPT_DISMISSED, '1', false);

        $to = wp_get_referer();
        if (!$to) {
            $to = admin_url('admin.php?page=daily-tarot-content&tab=status');
        }
        wp_safe_redirect($to);
        exit;
    }
}
