<?php
declare(strict_types=1);


namespace DailyTarot\Admin\Pages;
if (!defined('ABSPATH')) { exit; }


use DailyTarot\Admin\UiSettings;

final class Ui {

    public static function renderQuickActions(string $active = ''): void {
        if (!function_exists('admin_url')) return;

        // Allow admins to hide the bar globally.
        if (class_exists(UiSettings::class) && !UiSettings::showQuickActions()) return;

        $dashboardUrl = admin_url('admin.php?page=daily-tarot');
        $calendarUrl = admin_url('admin.php?page=daily-tarot-calendar');
        $statusUrl = admin_url('admin.php?page=daily-tarot-content&tab=status');
        $contentUrl = admin_url('admin.php?page=daily-tarot-content');
        $settingsUrl = admin_url('admin.php?page=daily-tarot-settings');

        $today = function_exists('wp_date') ? (string)wp_date('Y-m-d') : (string)current_time('Y-m-d');
        $editTodayUrl = add_query_arg(['dtarot_edit_date' => $today], $calendarUrl);

        $buttons = [
            'dashboard' => ['url' => $dashboardUrl, 'label' => __('Dashboard','daily-tarot')],
            'calendar' => ['url' => $calendarUrl, 'label' => __('Calendar','daily-tarot')],
            'status' => ['url' => $statusUrl, 'label' => __('Status','daily-tarot')],
            'content' => ['url' => $contentUrl, 'label' => __('Content','daily-tarot')],
            'settings' => ['url' => $settingsUrl, 'label' => __('Settings','daily-tarot')],
        ];

        echo '<div class="dtarot-card dtarot-quick-actions">';
        echo '<h2 style="margin-top:0;">' . esc_html__('Quick actions','daily-tarot') . '</h2>';
        echo '<div class="dtarot-actions">';

        foreach ($buttons as $key => $b) {
            $cls = 'button' . (($active === $key) ? ' button-primary' : '');
            echo '<a class="' . esc_attr($cls) . '" href="' . esc_url((string)$b['url']) . '">' . esc_html((string)$b['label']) . '</a>';
        }

        echo '<a class="button" href="' . esc_url($editTodayUrl) . '">' . esc_html__('Edit today','daily-tarot') . '</a>';

        echo '</div>';
        echo '</div>';
    }
}
