<?php
declare(strict_types=1);


namespace DailyTarot\Admin\Pages;
if (!defined('ABSPATH')) { exit; }


use DailyTarot\Calendar\DayEntryService;
use DailyTarot\Registry\Cards;

final class Status {

    public static function render(): void {
        if (!current_user_can('manage_options')) wp_die(esc_html__('Forbidden','daily-tarot'));

        // Status has been consolidated into Content → Status.
        wp_safe_redirect(admin_url('admin.php?page=daily-tarot-content&tab=status'));
        exit;
    }
}
