<?php
/**
 * Plugin Name: Daily Tarot
 * Description: Tarot calendar publishing with decks, meaning packs, spreads, bookings, and shortcodes.
 * Version: 1.1.13
 * Requires at least: 6.0
 * Requires PHP: 8.1
 * Author: Daily Tarot
 * Text Domain: daily-tarot
 * Domain Path: /languages
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @fs_premium_only /includes/Ai/, /includes/Analytics/, /includes/Automation/, /includes/Admin/Pages/Ai.php, /includes/Admin/Pages/Analytics.php, /includes/Admin/PostLinkSuggestions.php, /includes/Admin/CalendarPublishTimes.php, /includes/Rest/AiProviderController.php, /includes/Support/AiProviderSettings.php, /includes/Support/AiCredits.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! function_exists( 'dtarot_fs' ) ) {
    // Create a helper function for easy SDK access.
    function dtarot_fs() {
        global $dtarot_fs;

        if ( ! isset( $dtarot_fs ) ) {
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';

            $config = require dirname( __FILE__ ) . '/fs-config.php';
            if ( ! is_array( $config ) ) {
                $config = array();
            }

            $dtarot_fs = fs_dynamic_init( $config );
        }

        return $dtarot_fs;
    }

    // Init Freemius.
    dtarot_fs();
    // Signal that SDK was initiated.
    do_action( 'dtarot_fs_loaded' );
}

define('DTAROT_VERSION', '1.1.13');
define('DTAROT_PATH', plugin_dir_path(__FILE__));
define('DTAROT_URL', plugin_dir_url(__FILE__));

require_once DTAROT_PATH . 'includes/Autoloader.php';

\DailyTarot\Autoloader::init();

dtarot_fs();

add_action('plugins_loaded', function () {
    \DailyTarot\Plugin::init();
});

register_activation_hook(__FILE__, function () {
    delete_option('dtarot_dev_mode_v1');

    // Review prompt timing.
    if (get_option('dtarot_review_install_ts_v1', 0) <= 0) {
        update_option('dtarot_review_install_ts_v1', time(), false);
    }
    if (get_option('dtarot_review_next_ts_v1', 0) <= 0) {
        update_option('dtarot_review_next_ts_v1', time() + 7 * DAY_IN_SECONDS, false);
    }

    if (class_exists(\DailyTarot\Calendar\DayEntryTable::class)) {
        \DailyTarot\Calendar\DayEntryTable::ensureSchema();
    }

    // Ensure rewrites exist before flushing.
    $file = DTAROT_PATH . 'includes/Frontend/ReadableRoutes.php';
    if (is_readable($file)) {
        require_once $file;
    }
    $file = DTAROT_PATH . 'includes/Seo/Sitemap.php';
    if (is_readable($file)) {
        require_once $file;
    }
    $file = DTAROT_PATH . 'includes/Meaning/DefaultMeaningPack.php';
    if (is_readable($file)) {
        require_once $file;
    }
    if (class_exists(\DailyTarot\Plugin::class)) {
        \DailyTarot\Plugin::registerAllRewrites();
    } elseif (class_exists(\DailyTarot\Frontend\ReadableRoutes::class)) {
        \DailyTarot\Frontend\ReadableRoutes::register_rewrites();
    }
    if (class_exists(\DailyTarot\Meaning\DefaultMeaningPack::class)) {
        \DailyTarot\Meaning\DefaultMeaningPack::ensureExists();
    }

    // Install bundled default Tarot deck (if no decks exist yet).
    $existingDecks = get_posts([
        'post_type' => class_exists(\DailyTarot\Support\PostTypes::class)
            ? \DailyTarot\Support\PostTypes::deckTypes()
            : 'dtarot_deck',
        'post_status' => ['publish', 'draft', 'pending', 'private'],
        'numberposts' => 1,
        'fields' => 'ids',
        'no_found_rows' => true,
        'update_post_meta_cache' => false,
        'update_post_term_cache' => false,
    ]);
    if (empty($existingDecks) && class_exists(\DailyTarot\Admin\Backup::class)) {
        $zip = DTAROT_PATH . 'dtarot-deck-tarot-basic.zip';
        $slug = '';

        if (class_exists('ZipArchive')) {
            $z = new \ZipArchive();
            if ($z->open($zip) === true) {
                $raw = $z->getFromName('manifest.json');
                $z->close();
                if (is_string($raw) && $raw !== '') {
                    $manifest = json_decode($raw, true);
                    if (is_array($manifest) && isset($manifest['deck']) && is_array($manifest['deck'])) {
                        $slug = isset($manifest['deck']['slug']) && is_string($manifest['deck']['slug'])
                            ? sanitize_title($manifest['deck']['slug'])
                            : '';
                    }
                }
            }
        }

        \DailyTarot\Admin\Backup::importBundledDeckZip($zip);

        if ($slug !== '' && class_exists(\DailyTarot\Support\DefaultDecks::class)) {
            $p = null;
            if (class_exists(\DailyTarot\Support\PostTypes::class)) {
                $p = get_page_by_path($slug, OBJECT, \DailyTarot\Support\PostTypes::DECK);
                if (!$p) {
                    $p = get_page_by_path($slug, OBJECT, \DailyTarot\Support\PostTypes::LEGACY_DECK);
                }
            } else {
                $p = get_page_by_path($slug, OBJECT, 'dtarot_deck');
            }
            if ($p && isset($p->ID)) {
                \DailyTarot\Support\DefaultDecks::set(\DailyTarot\Registry\Cards::SYSTEM_TAROT, (int)$p->ID);
            }
        }
    }

    flush_rewrite_rules();
});

register_deactivation_hook(__FILE__, function () {
    flush_rewrite_rules();
});
