(function (wp) {
    if (!wp || !wp.blocks || !wp.element || !wp.components || !wp.blockEditor) return;

    var el = wp.element.createElement;
    var registerBlockType = wp.blocks.registerBlockType;
    var InspectorControls = wp.blockEditor.InspectorControls;
    var useBlockProps = wp.blockEditor.useBlockProps || wp.blockEditor.__experimentalUseBlockProps;
    var PanelBody = wp.components.PanelBody;
    var TextControl = wp.components.TextControl;
    var SelectControl = wp.components.SelectControl;
    var ToggleControl = wp.components.ToggleControl;
    var RangeControl = wp.components.RangeControl;
    var FormTokenField = wp.components.FormTokenField;

    function pluginIcon() {
        var url = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.icon) ? window.DTAROT_BLOCKS.icon : '';
        if (!url) return 'star-filled';
        return el('img', { src: url, style: { width: '20px', height: '20px' } });
    }

    function deckOptions() {
        var decks = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.decks) ? window.DTAROT_BLOCKS.decks : [];
        var out = [{ label: '—', value: 0 }];
        for (var i = 0; i < decks.length; i++) {
            out.push({ label: decks[i].title, value: decks[i].id });
        }
        return out;
    }

    function deckOptionsForSystem(system) {
        var decks = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.decks) ? window.DTAROT_BLOCKS.decks : [];
        var out = [{ label: '—', value: 0 }];
        for (var i = 0; i < decks.length; i++) {
            if (!system || decks[i].system === system) {
                out.push({ label: decks[i].title, value: decks[i].id });
            }
        }
        return out;
    }

    function packOptionsForSystem(system) {
        var packs = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.packs) ? window.DTAROT_BLOCKS.packs : [];
        var out = [{ label: '—', value: 0 }];
        for (var i = 0; i < packs.length; i++) {
            if (!system || packs[i].system === system) {
                out.push({ label: packs[i].title, value: packs[i].id });
            }
        }
        return out;
    }

    function spreadPresetOptions() {
        var presets = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.spreadPresets) ? window.DTAROT_BLOCKS.spreadPresets : [];
        var out = [{ label: 'Default (settings)', value: '' }];
        for (var i = 0; i < presets.length; i++) {
            out.push({ label: presets[i].title, value: presets[i].id });
        }
        return out;
    }

    function spreadPackOptions() {
        var packs = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.spreadPacks) ? window.DTAROT_BLOCKS.spreadPacks : [];
        var out = [{ label: 'Default (settings)', value: '' }];
        for (var i = 0; i < packs.length; i++) {
            out.push({ label: packs[i].title, value: packs[i].id });
        }
        return out;
    }
    function getDeckSystem(deckId) {
        var decks = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.decks) ? window.DTAROT_BLOCKS.decks : [];
        for (var i = 0; i < decks.length; i++) {
            if (decks[i].id === deckId) {
                return decks[i].system || 'tarot';
            }
        }
        return 'tarot';
    }

    function cardsForSystem(system) {
        var cards = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.cards) ? window.DTAROT_BLOCKS.cards : [];
        var prefix = (system === 'lenormand') ? 'lenormand_' : (system === 'kipper' ? 'kipper_' : (system === 'gypsy' ? 'gypsy_' : 'tarot_'));
        var out = [];
        for (var i = 0; i < cards.length; i++) {
            if (typeof cards[i].id === 'string' && cards[i].id.indexOf(prefix) === 0) {
                out.push(cards[i]);
            }
        }
        return out;
    }

    function cardOptions() {
        var cards = (window.DTAROT_BLOCKS && window.DTAROT_BLOCKS.cards) ? window.DTAROT_BLOCKS.cards : [];
        var out = [{ label: '—', value: '' }];
        for (var i = 0; i < cards.length; i++) {
            out.push({ label: cards[i].title + ' (' + cards[i].id + ')', value: cards[i].id });
        }
        return out;
    }

    function cardOptionsForSystem(system) {
        var cards = cardsForSystem(system || 'tarot');
        var out = [{ label: '—', value: '' }];
        for (var i = 0; i < cards.length; i++) {
            out.push({ label: cards[i].title + ' (' + cards[i].id + ')', value: cards[i].id });
        }
        return out;
    }

    registerBlockType('dtarot/daily-tarot', {
        icon: pluginIcon(),
        edit: function (props) {
            var a = props.attributes;
            var setAttributes = props.setAttributes;

            var blockProps = useBlockProps ? useBlockProps() : {};

            return el(
                wp.element.Fragment,
                null,
                el(
                    InspectorControls,
                    null,
                    el(
                        PanelBody,
                        { title: 'Daily Tarot', initialOpen: true },
                        el(SelectControl, {
                            label: 'Mode',
                            value: a.mode,
                            options: [
                                { label: 'Latest', value: 'latest' },
                                { label: 'Archive', value: 'archive' },
                                { label: 'Readable', value: 'readable' },
                            ],
                            onChange: function (v) { setAttributes({ mode: v }); }
                        }),
                        el(TextControl, {
                            label: 'Date (YYYY-MM-DD)',
                            value: a.date,
                            help: 'Optional. Defaults to today.',
                            onChange: function (v) { setAttributes({ date: v }); }
                        }),
                        el(RangeControl, {
                            label: 'Days (archive)',
                            value: a.days,
                            min: 1,
                            max: 90,
                            onChange: function (v) { setAttributes({ days: v }); }
                        }),
                        el(SelectControl, {
                            label: 'Layout',
                            value: a.layout,
                            options: [
                                { label: 'Minimal', value: 'minimal' },
                                { label: 'Hero', value: 'hero' },
                            ],
                            onChange: function (v) { setAttributes({ layout: v }); }
                        }),
                        el(ToggleControl, {
                            label: 'Show date',
                            checked: !!a.showDate,
                            onChange: function (v) { setAttributes({ showDate: !!v }); }
                        }),
                        el(ToggleControl, {
                            label: 'Show share links (hero)',
                            checked: !!a.showShare,
                            onChange: function (v) { setAttributes({ showShare: !!v }); }
                        }),
                        el(TextControl, {
                            label: 'Readable base URL (optional)',
                            value: a.readableUrl,
                            onChange: function (v) { setAttributes({ readableUrl: v }); }
                        })
                    )
                ),
                el('div', blockProps,
                    el(wp.serverSideRender, { block: 'dtarot/daily-tarot', attributes: a })
                )
            );
        },
        save: function () { return null; }
    });

    registerBlockType('dtarot/deck-gallery', {
        icon: pluginIcon(),
        edit: function (props) {
            var a = props.attributes;
            var setAttributes = props.setAttributes;

            var blockProps = useBlockProps ? useBlockProps() : {};

            return el(
                wp.element.Fragment,
                null,
                el(
                    InspectorControls,
                    null,
                    el(
                        PanelBody,
                        { title: 'Deck / Cards Gallery', initialOpen: true },
                        el(SelectControl, {
                            label: 'Deck',
                            value: a.deckId,
                            options: deckOptions().map(function (o) {
                                if (o.value === 0) return { label: 'All decks', value: 0 };
                                return o;
                            }),
                            onChange: function (v) { setAttributes({ deckId: parseInt(v, 10) || 0 }); }
                        }),
                        el(RangeControl, {
                            label: 'Columns (single deck)',
                            value: a.columns,
                            min: 2,
                            max: 10,
                            onChange: function (v) { setAttributes({ columns: v }); }
                        })
                    )
                ),
                el('div', blockProps,
                    el(wp.serverSideRender, { block: 'dtarot/deck-gallery', attributes: a })
                )
            );
        },
        save: function () { return null; }
    });

    registerBlockType('dtarot/card-details', {
        icon: pluginIcon(),
        edit: function (props) {
            var a = props.attributes;
            var setAttributes = props.setAttributes;

            var blockProps = useBlockProps ? useBlockProps() : {};

            return el(
                wp.element.Fragment,
                null,
                el(
                    InspectorControls,
                    null,
                    el(
                        PanelBody,
                        { title: 'Single Card Details', initialOpen: true },
                        el(SelectControl, {
                            label: 'Deck',
                            value: a.deckId,
                            options: deckOptions(),
                            onChange: function (v) { setAttributes({ deckId: parseInt(v, 10) || 0 }); }
                        }),
                        el(SelectControl, {
                            label: 'Card',
                            value: a.cardId,
                            options: cardOptions(),
                            onChange: function (v) { setAttributes({ cardId: v }); }
                        }),
                        el(ToggleControl, {
                            label: 'Show title',
                            checked: !!a.showTitle,
                            onChange: function (v) { setAttributes({ showTitle: !!v }); }
                        })
                    )
                ),
                el('div', blockProps,
                    el(wp.serverSideRender, { block: 'dtarot/card-details', attributes: a })
                )
            );
        },
        save: function () { return null; }
    });

    registerBlockType('dtarot/card-page', {
        icon: pluginIcon(),
        edit: function (props) {
            var a = props.attributes;
            var setAttributes = props.setAttributes;

            var system = a.system || 'tarot';

            var blockProps = useBlockProps ? useBlockProps() : {};

            return el(
                wp.element.Fragment,
                null,
                el(
                    InspectorControls,
                    null,
                    el(
                        PanelBody,
                        { title: 'Card Page', initialOpen: true },
                        el(SelectControl, {
                            label: 'System',
                            value: system,
                            options: [
                                { label: 'Tarot', value: 'tarot' },
                                { label: 'Lenormand', value: 'lenormand' },
                                { label: 'Kipper', value: 'kipper' },
                                { label: 'Gypsy', value: 'gypsy' },
                            ],
                            onChange: function (v) {
                                setAttributes({ system: v, cardId: '', deckId: 0, packId: 0 });
                            }
                        }),
                        el(SelectControl, {
                            label: 'Card',
                            value: a.cardId,
                            options: cardOptionsForSystem(system),
                            onChange: function (v) { setAttributes({ cardId: v }); }
                        }),
                        el(SelectControl, {
                            label: 'Deck override (optional)',
                            value: a.deckId,
                            options: deckOptionsForSystem(system),
                            onChange: function (v) { setAttributes({ deckId: parseInt(v, 10) || 0 }); }
                        }),
                        el(SelectControl, {
                            label: 'Meaning Pack override (optional)',
                            value: a.packId,
                            options: packOptionsForSystem(system),
                            onChange: function (v) { setAttributes({ packId: parseInt(v, 10) || 0 }); }
                        })
                    )
                ),
                el('div', blockProps,
                    el(wp.serverSideRender, { block: 'dtarot/card-page', attributes: a })
                )
            );
        },
        save: function () { return null; }
    });

    registerBlockType('dtarot/spread', {
        icon: pluginIcon(),
        attributes: {
            deckId: { type: 'number', default: 0 },
            cards: { type: 'string', default: '' },
            columns: { type: 'number', default: 0 },
            titles: { type: 'boolean', default: false },
            preset: { type: 'string', default: '' },
            spreadPack: { type: 'string', default: '' },
            cardWidthOffset: { type: 'number', default: 0 },
            cardGapOffset: { type: 'number', default: 0 }
        },
        edit: function (props) {
            var a = props.attributes;
            var setAttributes = props.setAttributes;

            var deckId = parseInt(a.deckId, 10) || 0;
            var system = getDeckSystem(deckId);
            var cardObjs = cardsForSystem(system);
            var suggestions = cardObjs.map(function (c) { return c.id; });
            var selected = (a.cards || '')
                .split(',')
                .map(function (s) { return (s || '').trim(); })
                .filter(function (s) { return !!s; });

            var blockProps = useBlockProps ? useBlockProps() : {};

            return el(
                wp.element.Fragment,
                null,
                el(
                    InspectorControls,
                    null,
                    el(
                        PanelBody,
                        { title: 'Spread', initialOpen: true },
                        el(SelectControl, {
                            label: 'Deck',
                            value: deckId,
                            options: deckOptions(),
                            onChange: function (v) {
                                setAttributes({ deckId: parseInt(v, 10) || 0, cards: '' });
                            }
                        }),
                        el(FormTokenField, {
                            label: 'Cards',
                            value: selected,
                            suggestions: suggestions,
                            help: deckId ? 'Type card IDs and pick from suggestions.' : 'Select a deck first.',
                            onChange: function (tokens) {
                                var clean = (tokens || [])
                                    .map(function (t) { return (t || '').trim(); })
                                    .filter(function (t) { return !!t; });
                                setAttributes({ cards: clean.join(',') });
                            }
                        }),

                        el(RangeControl, {
                            label: 'Card size offset (px)',
                            value: a.cardWidthOffset || 0,
                            min: -50,
                            max: 50,
                            help: 'Adjust size relative to the new base.',
                            onChange: function (v) { setAttributes({ cardWidthOffset: v }); }
                        }),
                        el(RangeControl, {
                            label: 'Card gap offset (px)',
                            value: a.cardGapOffset || 0,
                            min: -29,
                            max: 50,
                            help: 'Adjust spacing relative to the base.',
                            onChange: function (v) { setAttributes({ cardGapOffset: v }); }
                        }),
                        el(SelectControl, {
                            label: 'Spread preset',
                            value: a.preset || '',
                            options: spreadPresetOptions(),
                            onChange: function (v) { setAttributes({ preset: v }); }
                        }),
                        el(SelectControl, {
                            label: 'Meaning pack',
                            value: a.spreadPack || '',
                            options: spreadPackOptions(),
                            onChange: function (v) { setAttributes({ spreadPack: v }); }
                        }),
                        el(ToggleControl, {
                            label: 'Show titles',
                            checked: !!a.titles,
                            onChange: function (v) { setAttributes({ titles: !!v }); }
                        })
                    )
                ),
                el('div', blockProps,
                    el(wp.serverSideRender, { block: 'dtarot/spread', attributes: a })
                )
            );
        },
        save: function () { return null; }
    });

    registerBlockType('dtarot/booking', {
        icon: pluginIcon(),
        edit: function (props) {
            var a = props.attributes;
            var setAttributes = props.setAttributes;

            var blockProps = useBlockProps ? useBlockProps() : {};
            var variant = a.variant || 'form';
            var isButton = (variant === 'button');
            var isTeaser = (variant === 'teaser');

            return el(
                wp.element.Fragment,
                null,
                el(
                    InspectorControls,
                    null,
                    el(
                        PanelBody,
                        { title: 'Booking', initialOpen: true },
                        el(SelectControl, {
                            label: 'Variant',
                            value: variant,
                            options: [
                                { label: 'Full form', value: 'form' },
                                { label: 'Popup button', value: 'button' },
                                { label: 'Teaser card', value: 'teaser' }
                            ],
                            onChange: function (v) { setAttributes({ variant: v }); }
                        }),
                        el(SelectControl, {
                            label: 'Style',
                            value: a.style || '',
                            options: [
                                { label: 'Default (settings)', value: '' },
                                { label: 'Modern', value: 'modern' },
                                { label: 'Mystic', value: 'mystic' },
                                { label: 'Minimal', value: 'minimal' }
                            ],
                            onChange: function (v) { setAttributes({ style: v }); }
                        }),
                        (isButton || isTeaser) && el(TextControl, {
                            label: 'Button label',
                            value: a.label,
                            onChange: function (v) { setAttributes({ label: v }); }
                        }),
                        isTeaser && el(TextControl, {
                            label: 'Teaser title',
                            value: a.title,
                            onChange: function (v) { setAttributes({ title: v }); }
                        }),
                        isTeaser && el(TextControl, {
                            label: 'Teaser text',
                            value: a.text,
                            onChange: function (v) { setAttributes({ text: v }); }
                        })
                    )
                ),
                el('div', blockProps,
                    el(wp.serverSideRender, { block: 'dtarot/booking', attributes: a })
                )
            );
        },
        save: function () { return null; }
    });

})(window.wp);
