<?php
/*
Plugin Name: Cybrosys Post Counter
Description: This plugin is for counting the views, words and characters in a post
Version: 1.0.0
Author: Cybrosys Technologies
Author URI: https://www.cybrosys.com
License: GPLv3 or later
License URI: https://www.gnu.org/licenses/gpl-3.0.en.html
*/

// Including file for checking the field has already exists
include dirname ( __FILE__ ) . '/post-check.php';

// Class for hooks to execute count functions and adding columns to posts section
class CPCP_Post_Counter {
    function __construct() {
        register_activation_hook( __FILE__, 'cpcp_post_view_field_create' );
        add_filter( 'the_content', 'cpcp_post_views' );
        add_action( 'wp_head', 'cpcp_add_view' );
        add_action( 'wp_enqueue_scripts', 'cpcp_style' );
        add_filter( 'manage_posts_columns', 'cpcp_add_view_column' );
        add_filter( 'manage_posts_columns', 'cpcp_add_word_column' );
        add_filter( 'manage_posts_columns', 'cpcp_add_char_column' );
        add_action( 'manage_posts_custom_column', 'cpcp_display_counts' );
    }
}

// Adding style to the plugin
function cpcp_style() {
    wp_register_style( "cpcp_style", plugins_url( 'css/cpcp-style.css', __FILE__ ) );
    wp_enqueue_style( "cpcp_style" );
}

// Validating and creating field for view count in data base
function cpcp_post_view_field_create() {
    global $wpdb;
    if ( ! cpcp_post_view_check_field( 'cpcp_view_count' ) ) {
        $query = "ALTER TABLE $wpdb->posts ADD cpcp_view_count INT NOT NULL DEFAULT '0'";
        $wpdb->query( $query ) ;
    }
}

// Function for fetching and displaying counts with label names
function cpcp_post_views( $page_content ) {
    if ( ! is_page() ) {
    // Getting counts from count functions to variables
        global $post;

        $viewcount = "";
        $wordcount = "";
        $charcount = "";
    
        // Getting label names to the variables
        if( get_option( 'cpcp_view_count_option' ) != false ) {
            // Bought all those labels here.
            $viewcount_label =  ( empty( get_option( 'cpcp_view_label' ) ) ) ? 'View Count : ' :   $viewcount_label = get_option( 'cpcp_view_label' ) . ' : ';
            $viewcount =  ( !empty( cpcp_get_viewcount( $post->ID ) ) ) ? cpcp_get_viewcount( $post->ID ) : "";
        }

        if( get_option( 'cpcp_word_count_option' ) != false ) {
            // Bought all those labels here.
            $wordcount_label =  ( empty( get_option( 'cpcp_word_label' ) ) ) ? 'Word Count : ' : $wordcount_label = get_option( 'cpcp_word_label' ) . ' : ';
            $wordcount =  ( !empty( cpcp_get_wordcount( $post->ID ) ) ) ? cpcp_get_wordcount( $post->ID ) : "";
        }

        if( get_option( 'cpcp_char_count_option' ) != false ) {
            // Bought all those labels here.
            $charcount_label =  ( empty( get_option( 'cpcp_char_label' ) ) ) ? 'Character Count : ' :   $charcount_label = get_option( 'cpcp_char_label' ) . ' : ';
            $charcount =  ( !empty( cpcp_get_charcount( $post->ID ) ) ) ? cpcp_get_charcount( $post->ID ) : "";
        }

        // Concatenate  counts and label names to variables
            $view_display = $viewcount_label . $viewcount;
            $word_display = $wordcount_label . $wordcount;
            $char_display = $charcount_label . $charcount;

            $after = get_option( 'cpcp_display_content' ) == '0';
            $before = get_option( 'cpcp_display_content' ) == '1';

        // Return the counts
            if( $after ) {
                return  $page_content  .
                '<div class = "pcp-view"> <span class = "pcp-text">' . esc_attr($view_display) . ' </span>
                <span class = "pcp-text">' . esc_attr( $word_display ) . '</span>
                <span class = "pcp-text">' . esc_attr( $char_display ) . '</span> </div>';
            } elseif( $before ) {
                return '<div class = "pcp-view"> <span class = "pcp-text">' . esc_attr( $view_display  ) . ' </span>
                <span class = "pcp-text">' . esc_attr( $word_display ) . '</span>
                <span class = "pcp-text">' . esc_attr( $char_display ) . '</span> </div>'
                . $page_content ;
            }
    } else {
        return  $page_content ;
    }
}

// Updating view count on database
function cpcp_add_view() {
    if ( ! is_single() ) return;
    global $post, $wpdb;
    $post_id = $post->ID;
    $view = $post->cpcp_view_count + 1;
    $wpdb->UPDATE(
        $wpdb->posts,
        array( 'cpcp_view_count' => $view ),
        array( 'ID' => $post_id )
    );
}

// Creating view count column in posts section
function cpcp_add_view_column( $viewcount_column ) {
    $viewcount_column['cpcp_viewcount'] = 'View Count';
    return  $viewcount_column;
}

// Creating word count column in posts section
function cpcp_add_word_column( $wordcount_column ) {
    $wordcount_column['cpcp_wordcount'] = 'Word Count';
    return $wordcount_column;
}

// Creating char count column in posts section
function cpcp_add_char_column( $charcount_column ) {
    $charcount_column['cpcp_charcount'] = 'Char Count';
    return  $charcount_column ;
}

// Link the counts
function cpcp_display_counts( $name )
{
    global $post;
    switch ( $name ) {
        case 'cpcp_wordcount':
            // Get the post ID and pass it into the get_wordcount function
            $wordcount = cpcp_get_wordcount( $post->ID );
            echo esc_attr( $wordcount );
            break;
        case 'cpcp_charcount':
            // Get the post ID and pass it into the get_charcount function
            $charcount = cpcp_get_charcount( $post->ID );
            echo esc_attr( $charcount );
            break;
        case 'cpcp_viewcount':
            // Get the post ID and pass it into the get_viewcount function
            $viewcount = cpcp_get_viewcount( $post->ID );
            echo esc_attr( $viewcount );
            break;
    }
}

// Function for display viewcount
function cpcp_get_viewcount( ) {
    global $post;
    $views = $post->cpcp_view_count;
    if ( is_single() ) ++$views;
    return $views;
}

// Function for wordcount
function cpcp_get_wordcount( $post_id ) {
    // Get the post, remove special characters and then perform the word count
    $wordcount = str_word_count( strip_tags( strip_shortcodes( get_post_field( 'post_content', $post_id ) ) ) );
    return $wordcount;
}

// Function for counting characters
function cpcp_get_charcount( $post_id ) {
    $charcount = strlen( strip_tags( strip_shortcodes( get_post_field( 'post_content', $post_id ) ) ) );
    return $charcount;
}

$post_view_counter = new CPCP_Post_Counter();

// Class for settings functions
class CPCP_Post_Counter_Settings {
        function __construct() {
            add_action( 'admin_menu', array( $this, 'cpcp_settings_menu' ) );
            add_action( 'admin_init', array( $this, 'cpcp_settings' ) );
        }
    // Function for adding sub menu to the settings menu
    function cpcp_settings_menu() {
        add_options_page( "Post Counter", "Post Counter", 'manage_options', 'post-counter', array( $this, 'cpcp_settings_page' ) );
    }
    // Displaying title and the form actions
    function cpcp_settings_page() {
        ?>
        <div class = "wrap">
            <h1>Post Counter</h1>
            <form action = 'options.php' method = 'POST'>
            <?php
                settings_fields( 'count_settings' );
                do_settings_sections( 'post-counter' );
                submit_button();
            ?>
            </form>
        </div>
    <?php
    }

    // Section for the settings functions
    function cpcp_settings() {
        // Adding section for the settings
        add_settings_section( 'count_section', null, null, 'post-counter' );

        // Adding view count option
        add_settings_field( 'cpcp_view_count_option', "Show View Count", array( $this, 'cpcp_viewcount' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_view_count_option', array( 'sanitize_callback' => 'sanitize_text_field', 'default' => '0' ) );

        add_settings_field( 'cpcp_view_label', "View Label Name", array( $this, 'cpcp_viewlabel' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_view_label', array( $this, 'sanitize_callback' => 'sanitize_text_field' ) );

        // Adding word count option
        add_settings_field( 'cpcp_word_count_option', "Show Word Count", array( $this, 'cpcp_wordcount' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_word_count_option', array( 'sanitize_callback' => 'sanitize_text_field', 'default' => '0' ) );

        add_settings_field( 'cpcp_word_label', "Word Label Name", array( $this, 'cpcp_wordlabel' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_word_label', array( $this, 'sanitize_callback' => 'sanitize_text_field' ) );

        // Adding character count option
        add_settings_field( 'cpcp_char_count_option', "Show Character Count", array( $this, 'cpcp_charcount' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_char_count_option', array( 'sanitize_callback' => 'sanitize_text_field', 'default'=>'0' ) );

        add_settings_field( 'cpcp_char_label', "Character Label Name", array( $this, 'cpcp_charlabel' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_char_label', array( $this, 'sanitize_callback' => 'sanitize_text_field' ) );

        // Adding settings where the counts to be displayed
        add_settings_field( 'cpcp_display_content', 'Display Count', array( $this, 'cpcp_page_content' ), 'post-counter', 'count_section' );
        register_setting( 'count_settings', 'cpcp_display_content', array( $this, 'sanitize_callback' => 'sanitize_text_field', 'default' => '0' ) );
    }

    // Displaying textbox for view count
    function cpcp_viewlabel() {
    ?>
        <input type = "text" name = "cpcp_view_label" value = '<?php echo esc_attr( get_option( 'cpcp_view_label' )  ); ?>' />
    <?php
    }
    // Checkbox option for showing and hiding view count
    function cpcp_viewcount() {
    ?>
        <input type = "checkbox" name = "cpcp_view_count_option" value = '1' <?php checked( get_option( 'cpcp_view_count_option' ), '1' ); ?> />
    <?php
    }
    // Displaying textbox for word count
    function cpcp_wordlabel() {
    ?>
        <input type = "text" name = "cpcp_word_label" value = "<?php echo esc_attr( get_option( 'cpcp_word_label' ) ); ?>" />
    <?php
    }

    // Checkbox option for showing and hiding word count
    function cpcp_wordcount() {
    ?>
        <input type = "checkbox" name = "cpcp_word_count_option" value = "1" <?php checked( get_option( 'cpcp_word_count_option' ), '1' ); ?> />
    <?php
    }
    // Displaying textbox for character count
    function cpcp_charlabel() {
    ?>
        <input type = "text" name = "cpcp_char_label" value = "<?php echo esc_attr( get_option( 'cpcp_char_label' ) ); ?>"  />
    <?php
    }
    // Checkbox option for showing and hiding character count
    function cpcp_charcount() {
    ?>
        <input type = "checkbox" name = "cpcp_char_count_option" value = "1" <?php checked( get_option( 'cpcp_char_count_option' ), '1' ); ?> />
    <?php
    }
    // Input function for where the count to be displayed
    function cpcp_page_content() {
    ?>
        <input type = "radio" name = 'cpcp_display_content' value = '1'<?php  checked( get_option('cpcp_display_content'), '1' ); ?> />Before&nbsp&nbsp
        <input type = "radio" name = 'cpcp_display_content' value = '0'<?php checked( get_option('cpcp_display_content'), '0' ); ?> />After
    <?php
    }
}

$settings = new CPCP_Post_Counter_Settings();

?>