<?php
/*
Plugin Name: Cybro WP Easy Dark Mode
Description: Makes your WordPress admin dashboard in Dark Mode
Version: 1.0.0
Author: Cybrosys Technologies
Author URI: https://www.cybrosys.com
License: GPLv3 or later
License URI: https://www.gnu.org/licenses/gpl-3.0.en.html
*/

class CDM_Dark_Mode
{
    function __construct()
    {
        add_action( 'init', array( $this, 'cdm_add_style' ) );
        add_action( 'init', array( $this, 'cdm_custom_javascript' ) );
        add_action( 'admin_menu', array( $this, 'cdm_dark_mode_menu' ), 10 );
        add_action( 'admin_init', array( $this, 'cdm_dark_mode_fields' ) );
        add_action( 'init', array( $this, 'cdm_dark_mode_activate' ) );
    }

    function cdm_add_style()
    {
        wp_register_style( 'stylesheet', plugin_dir_url( __FILE__ ) . 'css/scss/main.css' );
    }

    function cdm_custom_javascript() {
        wp_register_script( 'script', plugin_dir_url(__FILE__) . 'script.js' );
        wp_enqueue_script( 'script');
        }

    function cdm_dark_mode_menu()
    {
        add_menu_page(
            'Cybro-Dark-Mode',
            'Dark Mode',
            'manage_options',
            'cybro-dark-mode-settings',
            array( $this, 'cdm_dark_mode_settings' ),
            'dashicons-lightbulb',
            null
        );
    }

    function cdm_dark_mode_settings()
    {
    ?>
        <section class = "wrap" style="padding: 5px;">
            <h3>Dark Mode</h3>
                <form action = "options.php" method = "POST">
                    <?php
                        settings_fields( 'dark_mode_dash' );
                        do_settings_sections( 'cdm-dark-mode-settings' );
                        submit_button();
                    ?>    
                </form>
        </section>
    <?php
    }
    
    function cdm_dark_mode_fields() {
        add_settings_section( 'cdm_dark_mode_section', null, null, 'cdm-dark-mode-settings' );
        add_settings_section( 'cdm_dark_mode_time_section', 'Set By Timezone', null, 'cdm-dark-mode-settings' );

        
        add_settings_field( 'cdm_dark_mode_dashboard', 'Dark Mode', array( $this, 'dark_mode_check_field' ), 'cdm-dark-mode-settings', 'cdm_dark_mode_section' );
        register_setting( 'dark_mode_dash', 'cdm_dark_mode_dashboard', array( 'sanitize_callback' => 'sanitize_text_field', 'default' => '0' ) );
        
        add_settings_field( 'cdm_start_time', 'Start Time',array( $this, 'cdm_darkmode_start_time' ), 'cdm-dark-mode-settings', 'cdm_dark_mode_time_section' );
        register_setting( 'dark_mode_dash', 'cdm_start_time', array( 'sanitize_callback' => 'sanitize_text_field') );
        
        add_settings_field( 'cdm_end_time', 'End Time', array( $this, 'cdm_darkmode_end_time' ), 'cdm-dark-mode-settings', 'cdm_dark_mode_time_section' );
        register_setting( 'dark_mode_dash', 'cdm_end_time', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    }

    function dark_mode_check_field() {
        ?>
            <input type = "checkbox" name = "cdm_dark_mode_dashboard" value = "1" <?php checked( get_option( 'cdm_dark_mode_dashboard'), '1' ); ?> >
        <?php
    }

    function cdm_darkmode_start_time() {
        ?>
            <input id = "cdm_start_time" name = "cdm_start_time"  value = "<?php  echo esc_attr( get_option( 'cdm_start_time' ) ) ; ?>"
             type = "text" placeholder = "HH:MM" onkeypress = "formatTime( this )" MaxLength = "5" />
        <?php
    }
    function cdm_darkmode_end_time() {
        ?>
            <input id = "cdm_end_time" name = "cdm_end_time" value = "<?php echo esc_attr( get_option( 'cdm_end_time' ) ) ; ?>"
              type = "text" placeholder = "HH:MM" onkeypress = "formatTime( this )" MaxLength = "5" />
        <?php
    }

    function cdm_dark_mode_activate() {

         // Get current timezone string
        $current_timezone = wp_timezone_string();
        // Set timezone
        date_default_timezone_set( $current_timezone );
        $current_time = current_time( 'G:i', false );

        if( ( get_option( 'cdm_dark_mode_dashboard' ) == '1' ) AND 
         ( strtotime( get_option( 'cdm_start_time' ) ) <= strtotime( $current_time ) 
          AND strtotime( get_option( 'cdm_end_time' ) ) >= strtotime( $current_time ) ) ) 
        {
            wp_enqueue_style('stylesheet');
        }
           
        if( ( get_option( 'cdm_dark_mode_dashboard' ) == '1') AND empty( get_option( 'cdm_start_time' ) ) 
            AND  empty(get_option( 'cdm_end_time' ) ) ) 
        {
            wp_enqueue_style( 'stylesheet' );
        }
    }
}

$cdm_dark_mode=new CDM_Dark_Mode();

?>