<?php
/*
Plugin Name: CYBREED - Chat integration
Description: A plugin that helps with the integration of a CyBreed chat widget for your Wordpress based website.
Version: 1.0.3
Author: CYBREED
Author URI: https://cybreed.ai/
License: GPL v2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Requires at least: 6.5
Requires PHP: 7.2
*/

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    die;
}

// Define constants
define('CYBREED_CHAT_VERSION', '1.0.3');
define('CYBREED_CHAT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CYBREED_CHAT_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include all other components from the new directory
require_once CYBREED_CHAT_PLUGIN_DIR . 'assets/modules/auth-module.php';
require_once CYBREED_CHAT_PLUGIN_DIR . 'assets/modules/auth-dashboard-module.php';
require_once CYBREED_CHAT_PLUGIN_DIR . 'assets/modules/settings-module.php';
require_once CYBREED_CHAT_PLUGIN_DIR . 'assets/modules/api-interaction-module.php';

// Activation hook
register_activation_hook(__FILE__, 'cybreed_chat_activate');
function cybreed_chat_activate() {
    // Add default options
    add_option('cybreed_display_options', array('display_type' => 'all'));
    
    // Clear any existing rewrite rules
    flush_rewrite_rules();
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'cybreed_chat_deactivate');
function cybreed_chat_deactivate() {
    // Clean up if necessary
    flush_rewrite_rules();
}

// Register all modules and add menu pages
function cybreed_plugin_init() {
    cybreed_auth_dashboard_init();
    cybreed_settings_module_init();
    cybreed_api_module_init();
}

// Add admin menu and submenus
function cybreed_add_admin_menu() {
    $icon_url = esc_url(plugins_url('assets/images/cybreed.png', __FILE__));
    $access_token = get_option('cybreed_access_token', '');
    
    // Main CYBREED menu with Dashboard functionality
    add_menu_page(
        __('CYBREED', 'cybreed'),
        __('CYBREED', 'cybreed'),
        'manage_options',
        'cybreed',
        'cybreed_auth_dashboard_page',
        $icon_url
    );

    // Additional submenu for Settings
    add_submenu_page(
        'cybreed',
        __('Dashboard', 'cybreed'),
        __('Dashboard', 'cybreed'),
        'manage_options',
        'cybreed'
    );

    // Only show settings submenu if user is logged in
    if ($access_token) {
        add_submenu_page(
            'cybreed',
            __('Settings', 'cybreed'),
            __('Settings', 'cybreed'),
            'manage_options',
            'cybreed-settings',
            'render_cybreed_settings_page'
        );
    }
}

// Hook the admin menu creation into WordPress
add_action('admin_menu', 'cybreed_add_admin_menu', 10);

// Ensure the init function is called at the right time
add_action('init', 'cybreed_plugin_init', 0);