<?php
function cybreed_api_module_init() {
    // Functions that handle API requests
    function fetch_organisations($api_key, $user_id) {
        // Sanitize user input
        $user_id = sanitize_text_field($user_id);
        $api_key = sanitize_text_field($api_key);

        // Add API interaction logic here
        $organisations_url = 'https://api.cybreed.ai/organisations/?user_id=' . urlencode($user_id);
        $response = wp_remote_get($organisations_url, [
            'headers' => ['Authorization' => 'Bearer ' . $api_key]
        ]);
        if (is_wp_error($response)) {
            return 'Request Failed: ' . esc_html($response->get_error_message());
        }
        return json_decode(wp_remote_retrieve_body($response), true);
    }

    function fetch_chats($organisation_id, $api_key) {
        // Sanitize user input
        $organisation_id = sanitize_text_field($organisation_id);
        $api_key = sanitize_text_field($api_key);
        
        if (empty($organisation_id) || empty($api_key)) {
            return [];
        }

        // Add API interaction logic here
        $chats_url = 'https://api.cybreed.ai/chats/?organisation_id=' . urlencode($organisation_id);
        $response = wp_remote_get($chats_url, [
            'headers' => ['Authorization' => 'Bearer ' . $api_key],
            'headers' => [
                'Authorization' => 'Bearer ' . $api_key,
                'Content-Type' => 'application/json',
                'Accept' => 'application/json'
            ]
        ]);
        
        if (is_wp_error($response)) {
            return [];
        }
        
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
        
        return is_array($data) ? $data : [];
    }
}
