<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://charlenesweb.ca
 * @since      1.0.0
 *
 * @package    CWSI_Invites
 * @subpackage CWSI_Invites/public/partials
 */
function cwsiShowInvitesAddRsvpPage($current_url, $results_get_guest, $results_add, $event_id) {
	$ct = "";
	if (isset($results_add['status']) && $results_add['status'] == 0) {
		if (isset($results_add['message']) && $results_add['message'] != "") {
			$ct .=  '<p class="cwsi_failmsg">'.esc_html($results_add['message']).'</p>';
		} else {
			$ct .=  '<p class="cwsi_failmsg">There was an error adding your response.</p>';
		}
	} elseif (isset($results_add['status']) && $results_add['status'] == 1) {
		if (isset($results_add['message']) && $results_add['message'] != "") {
			$ct .=  '<p class="cwsi_successmsg" id="message">'.esc_html($results_add['message']).'</p>';
		} else {
			$ct .=  '<p class="cwsi_successmsg" id="message">Your response was saved successfully.</p>';
		}
	} 
	if (isset($results_get_guest['status']) && $results_get_guest['status'] == 0) {
		if (isset($results_get_guest['message']) && $results_get_guest['message'] != "") {
			$ct .=  '<p class="cwsi_failmsg" id="message">'.esc_html($results_get_guest['message']).'</p>';
		} else {
			$ct .=  '<p class="cwsi_failmsg" id="message">There was an error retrieving your response.</p>';
		}
	} elseif (isset($results_get_guest['status']) && $results_get_guest['status'] == 1 && isset($results_get_guest['data']) && is_array($results_get_guest['data'])) {
		$guests = $results_get_guest['data'];
		if (isset($guests[0])) {
			$guest = $guests[0];
		}
	} 
	if (!isset($guest)) {
		// initialize
		$guest = new stdClass();
		$fields = array('email', 'full_name', 'comments', 'rsvp_answer', 'num_guests');
		foreach ($fields as $field) {
			$guest->$field = "";
		}
	}
	$ct .=  '
	<form action="'.esc_html($current_url).'" method="post" class="cwsi_invites_form" id="cwsi_invites_submit">
		<input type="hidden" name="rsvp_answer_form_nonce" value="'.wp_create_nonce('rsvp-answer').'">
		<input type="hidden" value="saveinviteeresponse" name="saveinviteeresponse">
		<input type="hidden" value="'.esc_html($event_id).'" name="event_id" />
		<p>
			<label>Email
			<input type="email" maxlength=150 required name="email" value="'.esc_html($guest->email).'" /></label>
		</p>
		<p>
			<label>Name
			<input type="text" required maxlength=255 name="full_name" value="'.esc_html($guest->full_name).'" /></label>
		</p>
		<p>
			<label>Do you have any notes to include with your response?</label>
			<textarea name="comments">'.esc_html(wp_unslash($guest->comments)).'</textarea>
		</p>
		<p>
			<span>Are you able to attend?</span><br />
			<label class="radio" for="rsvp_yes">
				<input type="radio" name="rsvp_answer" required id="rsvp_yes" value="Yes" ';
				if (isset($guest->rsvp_answer) && $guest->rsvp_answer == "Yes") {
					$ct .= ' checked ';
					$hideclass = "";
				} else {
					$hideclass = "cwsi_invites_hidden";
				}
				$ct .= '
				/> Yes, I will attend!
			</label>&nbsp;&nbsp;
			<label class="radio" for="rsvp_no">
				<input type="radio" name="rsvp_answer" required id="rsvp_no" value="No" ';
				if (isset($guest->rsvp_answer) && $guest->rsvp_answer == "No") {
					$ct .= ' checked ';
					$hideclass = "cwsi_invites_hidden";
				} else {
					$hideclass = "";
				}
				$ct .= '
				/> No, I cannot attend
			</label>
		</p>
		<p id="div_num_guests">
			<label for="num_guests">If yes, how many in your party?</label><br />
			<select name="num_guests" id="num_guests">
				<option value="">Choose &hellip;</option>';
				for ($i=1; $i<=20; $i++) {
					$ct .= '<option value="'.$i.'"';
					if (isset($guest->num_guests) && $guest->num_guests == $i) {
						$ct .= ' selected ';
					}
					$ct .= '> '.$i.' </option>';
				}
				$ct .= '
			</select>
		</p>
		<p class="cwsi_invites_hidden cwsi_failmsg">There was an issue with the form submission.</p>
		<p>
			<button type="submit">Submit</button>
		</p><br /><br />
	</form>';
	return $ct;
}

function cwsiPubInviteShowResponses($results) {
	$ct = "";
	if (isset($results['status']) && $results['status'] == 0) {
		if (isset($results['message']) && $results['message'] != "") {
			$ct .=  '<p class="cwsi_failmsg">'.esc_html($results['message']).'</p>';
		} else {
			$ct .=  '<p class="cwsi_failmsg">There was an error adding your response.</p>';
		}
	} elseif (isset($results['status']) && $results['status'] == 1 && isset($results['data'])) {
		$data = $results['data'];
	} 
	$old_response = "unknown";
	if (!isset($data) || count($data) <1) {
		$ct .= '<p>No responses yet</p>';
	} else {
		foreach ($data as $invite) {
			$new_response = $invite->rsvp_answer;
			if ($new_response != $old_response) {
				$old_response = $new_response;
				switch ($new_response) {
					case "Yes":
						$title = "Yes, We Are Coming!";
						break;
					case "No":
						$title = "No, We Cannot Make It";
						break;
					default:
						$title = "We Don&rsquo;t Know Yet";
				}
				$ct .=  '<br /><h3>'.esc_html($title).'</h3>';
			}
			$ct .= '<p><strong>'.esc_html($invite->full_name).'</strong>';
			if (isset($invite->comments) && $invite->comments != "") {
				$ct .= '<br /><em>'.esc_html(wp_unslash($invite->comments)).'</em>';
			}
			$ct .= '</p>';
		}
	}
	return $ct;
}