<?php

/**
 * Fired during plugin activation
 *
 * @link       https://charlenesweb.ca
 * @since      1.0.0
 *
 * @package    CWSI_Invites
 * @subpackage CWSI_Invites/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    CWSI_Invites
 * @subpackage CWSI_Invites/includes
 * @author     Charlene Copeland <charlene@charlenesweb.ca>
 */
class cwsi_invites_Activator {

	/**
	 * Invitations and RSVPs.
	 *
	 * Manage invitations on your website. 
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		global $wpdb;
		
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		
		// EVENTS table
		$table_name = $wpdb->prefix . "cwsi_events";
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			event_name varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
			organizer varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
			event_date date DEFAULT NULL,
			date_updated timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			PRIMARY KEY  (ID)
		) $charset_collate;";
		dbDelta($sql);
		
		// INVITEES table
		$table_name = $wpdb->prefix . "cwsi_invites";
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			full_name varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
			email varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			date_updated timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			PRIMARY KEY  (ID)
		) $charset_collate;";
		dbDelta($sql);
		
		// alter INVITEES table to add 2nd email
		$table_name = $wpdb->prefix . "cwsi_invites";
		$column_name = "email2";
		$create_ddl = "ALTER TABLE $table_name ADD $column_name varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL;";
		maybe_add_column($table_name, $column_name, $create_ddl);
		
		// EVENTS_INVITEES table
		$table_name = $wpdb->prefix . "cwsi_events_invitees";
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			event_id bigint(20) UNSIGNED NOT NULL DEFAULT 1,
			invitee_id bigint(20) UNSIGNED NOT NULL,
			num_guests tinyint(1) NOT NULL DEFAULT '0',
			rsvp_answer varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			comments text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			personal_note varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			admin_notes varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			date_save_sent date DEFAULT NULL,
			date_email_sent date DEFAULT NULL,
			date_responded date DEFAULT NULL,
			date_reminder_sent date DEFAULT NULL,
			date_updated timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			PRIMARY KEY  (ID)
		) $charset_collate;";
		dbDelta($sql);
		
		// SETTINGS table
		$table_name = $wpdb->prefix . "cwsi_invitesettings";
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS $table_name (
			ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			email_fromname varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_from varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_replyto varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_subject varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_cc varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_bcc varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_body text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			email_body_2 text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			message_type varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			date_updated timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			PRIMARY KEY  (ID)
		) $charset_collate;";
		dbDelta($sql);
		
		// alter cwsi_invitesettings table to add event_id
		$column_name = "event_id";
		$create_ddl = "ALTER TABLE $table_name ADD $column_name bigint(20) UNSIGNED NOT NULL DEFAULT 1;";
		maybe_add_column($table_name, $column_name, $create_ddl);
	} // END activate
}
