<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://charlenesweb.ca
 * @since             1.0.0
 * @package           CWSI_Invites
 *
 * @wordpress-plugin
 * Plugin Name: Invitations and RSVPs
 * Description:       Invite guests and allow them to enter their RSVP responses for your event. 
 * Requires at least: 6.3
 * Requires PHP:	  8.0
 * Version:           1.5.1
 * Author:            Charlene's Web Services
 * Author URI:        https://charlenesweb.ca
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       cwsi-invites
 * Domain Path:       /languages
 */
// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
    die;
}
if ( function_exists( 'ci_fs' ) ) {
    ci_fs()->set_basename( false, __FILE__ );
} else {
    /**
     * DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE
     * `function_exists` CALL ABOVE TO PROPERLY WORK.
     */
    if ( !function_exists( 'ci_fs' ) ) {
        // Create a helper function for easy SDK access.
        function ci_fs() {
            global $ci_fs;
            if ( !isset( $ci_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
                $ci_fs = fs_dynamic_init( array(
                    'id'             => '17787',
                    'slug'           => 'cwsi-invites',
                    'type'           => 'plugin',
                    'public_key'     => 'pk_72a299302116df5b537ea25bddb9f',
                    'is_premium'     => false,
                    'has_addons'     => false,
                    'has_paid_plans' => true,
                    'menu'           => array(
                        'first-path' => 'plugins.php',
                    ),
                    'is_live'        => true,
                ) );
            }
            return $ci_fs;
        }

        // Init Freemius.
        ci_fs();
        // Signal that SDK was initiated.
        do_action( 'ci_fs_loaded' );
    }
    /**
     * First release 1.0.0 and then using SemVer - https://semver.org X.Y.Z (Major.Minor.Patch)
     */
    define( 'CWSI_INVITES_VERSION', '1.5' );
    define( 'CWSI_INVITES_SRC_DIR', dirname( __FILE__ ) );
    /**
     * The code that runs during plugin activation.
     * This action is documented in includes/class-cwsi-invites-activator.php
     */
    function cwsi_activate_cws_invites() {
        require_once plugin_dir_path( __FILE__ ) . 'includes/class-cwsi-invites-activator.php';
        cwsi_invites_Activator::activate();
        register_uninstall_hook( __FILE__, 'cwsi_invites_uninstall' );
    }

    /**
     * The code that runs during plugin deactivation.
     * This action is documented in includes/class-cwsi-invites-deactivator.php
     */
    function cwsi_deactivate_cws_invites() {
        require_once plugin_dir_path( __FILE__ ) . 'includes/class-cwsi-invites-deactivator.php';
        cwsi_invites_Deactivator::deactivate();
    }

    // And here goes the uninstallation function:
    function cwsi_invites_uninstall() {
        global $wpdb;
        global $wpdb;
        $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "cwsi_events" );
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery
        $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "cwsi_events_invitees" );
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery
        $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "cwsi_invites" );
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery
        $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "cwsi_invitesettings" );
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery
    }

    register_activation_hook( __FILE__, 'cwsi_activate_cws_invites' );
    register_deactivation_hook( __FILE__, 'cwsi_deactivate_cws_invites' );
    /**
     * The core plugin class that is used to define internationalization,
     * admin-specific hooks, and public-facing site hooks.
     */
    require plugin_dir_path( __FILE__ ) . 'includes/class-cwsi-invites.php';
    /**
     * Begins execution of the plugin.
     *
     * Since everything within the plugin is registered via hooks,
     * then kicking off the plugin from this point in the file does
     * not affect the page life cycle.
     *
     * @since    1.0.0
     */
    function run_cwsi_invites() {
        $plugin = new CWSI_Invites();
        $plugin->run();
    }

    run_cwsi_invites();
}