<?php

/**
 * Provide an admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://charlenesweb.ca
 * @since      1.0.0
 *
 * @package    cwsi_invites
 * @subpackage cwsi_invites/admin/partials
 */
///////////////////////////////////////
// MANAGE Invitations display functions
///////////////////////////////////////
// See the invitees and their responses
function cwsiShowAddInvitesPage(
    $menu_slug,
    $results_add_response,
    $search_event_id,
    $search_event_name
) {
    $now = current_datetime()->format( 'Y-m-d' );
    echo '
	<div class="cwsi_invitee_admin">
	<h3>Add New Invitee to ' . wp_kses( wp_unslash( nl2br( $search_event_name ) ), cwsi_invites_allowed_html() ) . '</h3>';
    // message from add?
    if ( isset( $results_add_response['status'] ) && $results_add_response['status'] == 0 ) {
        if ( isset( $results_add_response['message'] ) && $results_add_response['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_add_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error when adding the invitee.</p>';
        }
    } elseif ( isset( $results_add_response['status'] ) && $results_add_response['status'] == 1 ) {
        if ( isset( $results_add_response['message'] ) && $results_add_response['message'] != "" ) {
            echo '<p class="cwsi_successmsg">' . esc_html( $results_add_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_successmsg">Added successfully.</p>';
        }
    }
    echo '
	<table class="cwsi_invites_admin_table">
		<thead>
			<tr>
				<th width="15%">Name</th>
				<th width="15%">Email</th>
				<th width="8%">Coming?</th>
				<th width="8%">Num Guests</th>
				<th width="15%">Personalized Note</th>
				<th width="15%">Admin Notes</th>
				<th width="8%">Date Emailed</th>
				<th width="8%">Date Responded</th>
				<th align="center" width="14%">Action</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
    wp_nonce_field( 'show-add-invitee-responses', 'showaddinviteeresponsesform' );
    echo '
					<td>
						<input type="text" maxlength=255 required name="full_name" value=""/>
					</td>
					<td>
						<input type="email" style="width:250px" maxlength=150 required name="email" value=""/>
					</td>
					<td>
						<select name="rsvp_answer">
							<option value="">Choose &hellip;</option>
							<option value="Yes"> Yes </option>
							<option value="No"> No </option>
						</select>
					</td>
					<td> 
						<input type="number" required name="num_guests" value=""/>
					</td>
					<td>
						<input type="text" maxlength=255 name="personal_note" value=""/>
						
					</td>
					<td>
						<input type="text" maxlength=255 name="admin_notes" value=""/>
					</td>
					<td>
						<input type="date" maxlength=12 name="date_email_sent" value=""/>
					</td>
					<td>
						<input type="date" maxlength=12 name="date_responded" value=""/>
					</td>
					<td align="center">
						<input type="hidden" name="add_invitee" value="add"/>
						<input type="hidden" name="event_id" value="' . esc_html( $search_event_id ) . '"/>
						<button type="submit">Add</button>
					</td>
				</form>
			</tr>
		</tbody>
	</table>
	</div>';
}

// See the invitees and their responses
function cwsiShowInvitesResponsesPage(
    $menu_slug,
    $results,
    $results_save_response,
    $search_event_id,
    $search_event_name
) {
    $now = current_datetime()->format( 'Y-m-d' );
    echo '<div class="cwsi_invitee_admin">
	<hr />
	<h3>Review and Edit Invitees and Their Responses for ' . wp_kses( wp_unslash( nl2br( $search_event_name ) ), cwsi_invites_allowed_html() ) . '</h3>';
    // message from save?
    if ( isset( $results_save_response['status'] ) && $results_save_response['status'] == 0 ) {
        if ( isset( $results_save_response['message'] ) && $results_save_response['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_save_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error</p>';
        }
    } elseif ( isset( $results_save_response['status'] ) && $results_save_response['status'] == 1 ) {
        if ( isset( $results_save_response['message'] ) && $results_save_response['message'] != "" ) {
            echo '<p class="cwsi_successmsg">' . esc_html( $results_save_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_successmsg">Saved successfully.</p>';
        }
    }
    if ( isset( $results_save_response['download'] ) && $results_save_response['download'] != "" ) {
        echo wp_kses( wp_unslash( $results_save_response['download'] ), cwsi_invites_allowed_html() );
    }
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $data = $results['data'];
        } else {
            $data = array();
        }
        echo '
		<p>This table shows the ' . count( $data ) . ' Invitees and their responses. ';
        // END PREMIUM ONLY
        echo '</p>
		<table class="cwsi_invites_admin_table">
			<thead>
				<tr>
					<th width="15%">Name</th>
				<th width="15%">Email</th>
				<th width="8%">Coming?</th>
				<th width="8%">Num Guests</th>
				<th width="15%">Personalized Note</th>
				<th width="15%">Admin Notes</th>
				<th width="8%">Date Emailed</th>
				<th width="8%">Date Responded</th>
				<th align="center" width="14%">Action</th>
				</tr>
			</thead>
			<tbody>';
        if ( count( $data ) > 0 ) {
            foreach ( $data as $i => $row ) {
                echo '
				<tr>
					<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
                wp_nonce_field( 'show-invitee-responses-' . esc_html( $row->ID ), 'showinviteeresponsesform-' . esc_html( $row->ID ) );
                echo '
						<td>
							<input type="text" maxlength=255 required name="full_name" value="' . esc_html( $row->full_name ) . '"/>
						</td>
						<td>
							<input type="email" style="width:250px" maxlength=150 required name="email" value="' . esc_html( $row->email ) . '"/>
						</td>
						<td>
							<select name="rsvp_answer">
								<option value="">Choose &hellip;</option>
								<option value="Yes" ';
                if ( $row->rsvp_answer == "Yes" ) {
                    echo ' selected ';
                }
                echo '> Yes </option>
								<option value="No" ';
                if ( $row->rsvp_answer == "No" ) {
                    echo ' selected ';
                }
                echo '> No </option>
							</select>';
                if ( $row->comments != "" ) {
                    echo '<br />Comments: <em>' . esc_html( wp_unslash( $row->comments ) ) . '</em><br />';
                }
                echo '
						</td><td> 
							<input type="number" required name="num_guests" value="' . esc_html( $row->num_guests ) . '"/>';
                echo '
						</td>
						<td>
							<input type="text" maxlength=255 name="personal_note" value="' . esc_html( $row->personal_note ) . '"/>
							
						</td>
						<td>
							<input type="text" maxlength=255 name="admin_notes" value="' . esc_html( $row->admin_notes ) . '"/>
						</td>
						<td>
							<input type="date" maxlength=12 name="date_email_sent" value="' . esc_html( $row->date_email_sent ) . '"/>
						</td>
						<td>
							<input type="date" maxlength=12 name="date_responded" value="' . esc_html( $row->date_responded ) . '"/>
						</td>
						<td align="center">
							<input type="hidden" value="' . esc_html( $row->invitee_id ) . '" name="cwsinvitee_id">
							<input type="hidden" name="event_id" value="' . esc_html( $search_event_id ) . '"/>
							<button type="submit" name="saveinvite">Save</button>
							<button type="submit" name="deleteinvite" class="delete_button" onclick="return confirm(\'Are you sure you want to remove this invite? It will remove them plus their response and comments.\')">Delete</button>
						</td>
					</form>
				</tr>';
            }
        }
        echo '</tbody></table>';
    }
    echo '</div>';
}

///////////////////////////////////////
// MANAGE Events display functions
///////////////////////////////////////
// See the invitees and their responses
function cwsiShowAddEventPage(  $menu_slug, $results_add_response, $ctr_events  ) {
    echo '
	<div class="cwsi_invitee_admin">
	<h3>Add New Event</h3>';
    if ( ci_fs()->is_not_paying() ) {
        echo '<p><strong>If you have the free version of the plugin then you can only have 1 event. </strong></p>';
        // Adds a direct checkout link in the free version.
        echo sprintf( '<a href="%s"><small>Unlock Pro</small></a>', ci_fs()->checkout_url() );
    }
    // END NOT PREMIUM PAYING
    // message from add?
    if ( isset( $results_add_response['status'] ) && $results_add_response['status'] == 0 ) {
        if ( isset( $results_add_response['message'] ) && $results_add_response['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_add_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error when adding the invitee.</p>';
        }
    } elseif ( isset( $results_add_response['status'] ) && $results_add_response['status'] == 1 ) {
        if ( isset( $results_add_response['message'] ) && $results_add_response['message'] != "" ) {
            echo '<p class="cwsi_successmsg">' . esc_html( $results_add_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_successmsg">Added successfully.</p>';
        }
    }
    if ( ci_fs()->is_not_paying() ) {
        if ( $ctr_events >= 1 ) {
            return;
        }
    }
    // END NOT PREMIUM
    echo '
	<table class="cwsi_invites_admin_table">
		<thead>
			<tr>
				<th width="25%">Event Name</th>
				<th width="25%">Event Date</th>
				<th width="25%">Organizer</th>
				<th align="center" width="25%">Action</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
    wp_nonce_field( 'show-add-event-responses', 'showaddeventresponsesform' );
    echo '
					<td>
						<input type="text" maxlength="100" required name="event_name" value=""/>
					</td>
					<td>
						<input type="date" maxlength="12" required name="event_date" value=""/>
					</td>
					<td>
						<input type="text" maxlength="100" required name="organizer" value=""/>
					</td>
					<td align="center">
						<input type="hidden" name="add_event" value="add"/>
						<button type="submit">Add</button>
					</td>
				</form>
			</tr>
		</tbody>
	</table>
	</div>';
}

// See the invitees and their responses
function cwsiShowEventsPage(  $menu_slug, $results, $results_save_response  ) {
    echo '<div class="cwsi_invitee_admin">
	<hr />
	<h3>Review and Edit Events</h3>';
    // message from save?
    if ( isset( $results_save_response['status'] ) && $results_save_response['status'] == 0 ) {
        if ( isset( $results_save_response['message'] ) && $results_save_response['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_save_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error</p>';
        }
    } elseif ( isset( $results_save_response['status'] ) && $results_save_response['status'] == 1 ) {
        if ( isset( $results_save_response['message'] ) && $results_save_response['message'] != "" ) {
            echo '<p class="cwsi_successmsg">' . esc_html( $results_save_response['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_successmsg">Saved successfully.</p>';
        }
    }
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $data = $results['data'];
        } else {
            $data = array();
        }
        echo '
		<p>This table shows the ' . count( $data ) . ' Event(s). ';
        echo '</p>
		<table class="cwsi_invites_admin_table">
			<thead>
				<tr>
					<th width="5%">ID</th>
					<th width="25%">Event Name</th>
					<th width="25%">Event Date</th>
					<th width="25%">Organizer</th>
					<th align="center" width="20%">Action</th>
				</tr>
			</thead>
			<tbody>';
        if ( count( $data ) > 0 ) {
            foreach ( $data as $i => $row ) {
                echo '
				<tr>
					<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
                wp_nonce_field( 'show-event-responses-' . esc_html( $row->ID ), 'showeventform-' . esc_html( $row->ID ) );
                echo '
						<td>' . esc_html( $row->ID ) . '</td>
						<td>
							<input type="text" maxlength="100" required name="event_name" value="' . wp_kses( wp_unslash( nl2br( $row->event_name ) ), cwsi_invites_allowed_html() ) . '"/>
						</td>
						<td>
							<input type="date" maxlength="12" required name="event_date" value="' . esc_html( $row->event_date ) . '"/>
						</td>
						
						<td>
							<input type="text" maxlength="100" required name="organizer" value="' . wp_kses( wp_unslash( nl2br( $row->organizer ) ), cwsi_invites_allowed_html() ) . '"/>
						</td>
						<td align="center">
							<input type="hidden" value="' . esc_html( $row->ID ) . '" name="cwsevent_id">
							<button type="submit" name="saveevent">Save</button>
							<button type="submit" name="deleteevent" class="delete_button" onclick="return confirm(\'Are you sure you want to remove this event? \')">Delete</button>
						</td>
					</form>
				</tr>';
            }
        }
        echo '</tbody></table>';
    }
    echo '</div>';
}

// Display search and filter form for events
function cwsiShowFilterEvents(  $menu_slug, $results, $search_event_id  ) {
    echo '
	<div class="cwsi_admin cwsi_noprint">
		<h3>Select an Event</h3>';
    if ( isset( $results['status'] ) && $results['status'] == 0 ) {
        if ( isset( $results['message'] ) && $results['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error</p>';
        }
    } else {
        $events = $results['data'];
    }
    if ( is_array( $events ) && count( $events ) > 0 ) {
        echo '
		<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
        wp_nonce_field( 'show-filter-events', 'showfiltereventsform' );
        echo '
			<select name="search_event_id" required>
				<option value="">Choose Event ... </option>';
        foreach ( $events as $i => $event ) {
            echo '
			<option value="' . esc_html( $event->ID ) . '"';
            if ( $search_event_id == $event->ID ) {
                echo ' selected ';
            }
            echo '> ' . wp_kses( wp_unslash( nl2br( $event->event_name ) ), cwsi_invites_allowed_html() ) . ' on ' . esc_html( $event->event_date ) . '
			</option>';
        }
        // END loop on types
        echo '</select>
		<input type="submit" name="show_filter_event" value="Go >" />
		</form>
	</div>';
    } else {
        echo '<p class="cwsi_failmsg">First add an Event and then add the invitees. </p>';
    }
}

///////////////////////////////////////
// Show file upload form
///////////////////////////////////////
function cwsiShowInvitesUpload(  $menu_slug, $results_save_import, $results_events  ) {
    echo '<h3>Upload Invitees File</h3>';
    // message from save?
    if ( isset( $results_save_import['status'] ) && $results_save_import['status'] == 0 ) {
        if ( isset( $results_save_import['message'] ) && $results_save_import['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_save_import['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error</p>';
        }
    } elseif ( isset( $results_save_import['status'] ) && $results_save_import['status'] == 1 ) {
        if ( isset( $results_save_import['message'] ) && $results_save_import['message'] != "" ) {
            echo '<p class="cwsi_successmsg">' . esc_html( $results_save_import['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_successmsg">Saved successfully.</p>';
        }
    }
    // message from get events?
    if ( isset( $results_events['status'] ) && $results_events['status'] == 0 ) {
        if ( isset( $results_events['message'] ) && $results_events['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_events['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error</p>';
        }
    } elseif ( isset( $results_events['status'] ) && $results_events['status'] == 1 && isset( $results_events['data'] ) ) {
        $events = $results_events['data'];
    } else {
        $events = array();
    }
    $selected = ' selected="selected"';
    echo '<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post" enctype="multipart/form-data">';
    wp_nonce_field( 'show-invites-upload', 'showinvitesuploadform' );
    echo '
		<input type="hidden" name="cwsi_file_name" value="1" />
		<p>
			<label for "event_id">Select Event: </label>
			<select name="event_id" required> 
				<option value="">Choose ...</option>';
    foreach ( $events as $event ) {
        echo '<option value=' . esc_html( $event->ID ) . ' ' . esc_html( $selected ) . '>' . wp_kses( wp_unslash( nl2br( $event->event_name ) ), cwsi_invites_allowed_html() ) . ' on ' . esc_html( $event->event_date ) . '</option>';
        $selected = "";
    }
    echo '
			</select>
		</p>
		<p>
			<label for "upload_file">Select File: </label>
			<input type="file" id="upload_file" name="upload_file"value="" accept=".csv" required /> 
		</p>
		<p><button type="submit" class="single_add_to_cart_button button">Upload Invitees</button></p>
	</form>
	<p>File must be a CSV and have a header row with the following columns: </p>
	<ol>
		<li>email</li>
		<li>full_name</li>
		<li>num_guests</li>
		<li>rsvp_answer (must be Yes, No or blank)</li>
		<li>invitee_comments (can be blank)</li>
		<li>personal_note (can be blank - if entered then can be included in the emailed invitation)</li>
		<li>admin_notes (can be blank)</li>
		
	</ol>';
}

///////////////////////////////////////
// Show send emails form
///////////////////////////////////////
function cwsiShowInvitesSendEmails(
    $menu_slug,
    $results,
    $results_settings,
    $results_recips
) {
    // message from save?
    if ( isset( $results['status'] ) && $results['status'] == 0 ) {
        if ( isset( $results['message'] ) && $results['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error</p>';
        }
    } elseif ( isset( $results['status'] ) && $results['status'] == 1 ) {
        if ( isset( $results['message'] ) && $results['message'] != "" ) {
            $good = $results['good'];
            $bad = $results['bad'];
            echo '<p class="cwsi_successmsg">' . esc_html( $results['message'] ) . '<br />' . count( $bad ) . ' not sent and ' . count( $good ) . ' sent.</p>
			<h3>Sent</h3>';
            foreach ( $good as $i => $email ) {
                echo esc_html( $email ) . '<br />';
            }
            echo '
			<h3>Not Sent</h3>';
            foreach ( $bad as $i => $email ) {
                echo esc_html( $email ) . '<br />';
            }
        } else {
            echo '<p class="cwsi_successmsg">Sent successfully.</p>';
        }
    }
    // message from get settings
    if ( isset( $results_settings['status'] ) && $results_settings['status'] == 0 ) {
        if ( isset( $results_settings['message'] ) && $results_settings['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_settings['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error getting the invitations.</p>';
        }
    } elseif ( isset( $results_settings['status'] ) && $results_settings['status'] == 1 && isset( $results_settings['data'] ) && count( $results_settings['data'] ) >= 1 ) {
        $settings = $results_settings['data'][0];
    }
    // message from get recipents
    if ( isset( $results_recips['status'] ) && $results_recips['status'] == 0 ) {
        if ( isset( $results_recips['message'] ) && $results_recips['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_recips['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error getting the invitees.</p>';
        }
    } elseif ( isset( $results_recips['status'] ) && $results_recips['status'] == 1 && isset( $results_recips['data'] ) && count( $results_recips['data'] ) >= 1 ) {
        $invitees = $results_recips['data'];
    }
    if ( !isset( $invitees ) || count( $invitees ) == 0 ) {
        echo '<p><strong>There are no invitees that have not received invitations.</strong></p>';
    } else {
        echo '<h3>These people will receive an invitation.</h3>';
        foreach ( $invitees as $invitee ) {
            if ( isset( $invitee->full_name ) && isset( $invitee->email ) ) {
                echo '<p>' . esc_html( $invitee->full_name ) . ', ' . esc_html( $invitee->email ) . '</p>';
            }
        }
        echo '<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
        wp_nonce_field( 'show-invites-send-emails', 'showinvitessendemailsform' );
        echo '
			<input type="hidden" name="cws_send_email" value="1" />
			<p><button type="submit" class="single_add_to_cart_button button">Send Emails to All Invitees</button></p>
		</form>';
    }
    // show current invitation
    if ( isset( $settings ) ) {
        $fields = array(
            'email_fromname' => "Email From Name",
            'email_from'     => "Email From",
            'email_replyto'  => "Reply-to",
            'email_cc'       => "CC",
            'email_bcc'      => "Bcc",
            'email_subject'  => "Subject",
            'email_body'     => "Body of Email",
        );
        echo '<h1>Current Invitation</h1><p>You can change this in Design Invitation Email.</p>';
        foreach ( $fields as $field => $desc ) {
            if ( isset( $settings->{$field} ) && $settings->{$field} != "" ) {
                echo '<br /><strong>' . esc_html( $desc ) . ': </strong>';
                if ( $field == "email_body" ) {
                    echo '<br />' . wp_kses( wp_unslash( nl2br( $settings->{$field} ) ), cwsi_invites_allowed_html() ) . '<br />';
                } else {
                    echo esc_html( $settings->{$field} ) . '<br />';
                }
            }
        }
    }
}

///////////////////////////////////////
// Show responses so far
///////////////////////////////////////
function cwsiShowInvitesViewResponses(
    $menu_slug,
    $results_yes,
    $results_no,
    $results_null
) {
    echo '<div class="cwsi_invitee_admin">
	<hr />
	<h3>View Responses</h3>';
    // message from yes?
    if ( isset( $results_yes['status'] ) && $results_yes['status'] == 0 ) {
        if ( isset( $results_yes['message'] ) && $results_yes['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_yes['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error when retrieving the YES responses.</p>';
        }
        $yes = array();
    } else {
        $yes = $results_yes['data'];
    }
    // message from no?
    if ( isset( $results_no['status'] ) && $results_no['status'] == 0 ) {
        if ( isset( $results_no['message'] ) && $results_no['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_no['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error when retrieving the NO responses.</p>';
        }
        $no = array();
    } else {
        $no = $results_no['data'];
    }
    // message from nulls?
    if ( isset( $results_null['status'] ) && $results_null['status'] == 0 ) {
        if ( isset( $results_null['message'] ) && $results_null['message'] != "" ) {
            echo '<p class="cwsi_failmsg">' . esc_html( $results_null['message'] ) . '</p>';
        } else {
            echo '<p class="cwsi_failmsg">There was an error when retrieving the NULL responses.</p>';
        }
        $null = array();
    } else {
        $null = $results_null['data'];
    }
    // count guests
    $total_yes_guests = 0;
    foreach ( $yes as $ctr => $rsvp ) {
        $total_yes_guests += $rsvp->num_guests;
    }
    $total_no_guests = 0;
    foreach ( $no as $ctr => $rsvp ) {
        $total_no_guests += $rsvp->num_guests;
    }
    $total_null_guests = 0;
    foreach ( $null as $ctr => $rsvp ) {
        $total_null_guests += $rsvp->num_guests;
    }
    $total = $total_yes_guests + $total_no_guests + $total_null_guests;
    echo '
	<table class="cwsi_invites_admin_table" style="width:50%">
		<thead>
			<tr>
				<th>Response</th>
				<th width="50%">Number of Guests</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<th>YES, Coming</th>
				<td>' . esc_html( $total_yes_guests ) . '</td>
			</tr>
			<tr>
				<th>NO, Not Coming</th>
				<td>' . esc_html( $total_no_guests ) . '</td>
			</tr>
			<tr>
				<th>Emailed, but no answer yet</th>
				<td>' . esc_html( $total_null_guests ) . '</td>
			</tr>
			<tr>
				<th>TOTAL:</th>
				<th>' . esc_html( $total ) . '</th>
			</tr>
		</tbody>
	</table>';
    //The Yes's
    echo '<h3>' . esc_html( $total_yes_guests ) . ' YES, Coming Responses</h3>
	<table class="cwsi_invites_admin_table">
		<thead>
			<tr>
				<th width="25%">Name</th>
				<th width="25%">Email</th>
				<th width="25%">Total Guests</th>
				<th width="50%">Comments</th>
			</tr>
		</thead>
		<tbody>';
    foreach ( $yes as $ctr => $rsvp ) {
        echo '
			<tr>
				<td>' . esc_html( $rsvp->full_name ) . '</td>
				<td>' . esc_html( $rsvp->email ) . '</td>
				<td>' . esc_html( $rsvp->num_guests ) . '</td>
				<td>' . esc_html( wp_unslash( $rsvp->comments ) ) . '</td>
			</tr>';
    }
    echo '
			<tr>
				<th colspan=2>TOTAL:</th>
				<th>' . esc_html( $total_yes_guests ) . '</th>
				<td>&nbsp;</td>
			</tr>
		</tbody>
	</table>';
    //The No's
    echo '<h3>' . esc_html( $total_no_guests ) . ' NO, Not Coming Responses</h3>
	<table class="cwsi_invites_admin_table">
		<thead>
			<tr>
				<th width="25%">Name</th>
				<th width="25%">Email</th>
				<th width="25%">Total Guests</th>
				<th width="50%">Comments</th>
			</tr>
		</thead>
		<tbody>';
    foreach ( $no as $ctr => $rsvp ) {
        echo '
			<tr>
				<td>' . esc_html( $rsvp->full_name ) . '</td>
				<td>' . esc_html( $rsvp->email ) . '</td>
				<td>' . esc_html( $rsvp->num_guests ) . '</td>
				<td>' . esc_html( wp_unslash( $rsvp->comments ) ) . '</td>
			</tr>';
    }
    echo '
			<tr>
				<th colspan=2>TOTAL:</th>
				<th>' . esc_html( $total_no_guests ) . '</th>
				<td>&nbsp;</td>
			</tr>
		</tbody>
	</table>';
    //The Null's
    echo '<h3>' . esc_html( $total_null_guests ) . ' No Answer Yet Responses</h3>
	<table class="cwsi_invites_admin_table">
		<thead>
			<tr>
				<th width="25%">Name</th>
				<th width="25%">Email</th>
				<th width="25%">Total Guests</th>
				<th width="50%">Comments</th>
			</tr>
		</thead>
		<tbody>';
    foreach ( $null as $ctr => $rsvp ) {
        echo '
			<tr>
				<td>' . esc_html( $rsvp->full_name ) . '</td>
				<td>' . esc_html( $rsvp->email ) . '</td>
				<td>' . esc_html( $rsvp->num_guests ) . '</td>
				<td>' . esc_html( wp_unslash( $rsvp->comments ) ) . '</td>
			</tr>';
    }
    echo '
			<tr>
				<th colspan=2>TOTAL:</th>
				<th>' . esc_html( $total_null_guests ) . '</th>
				<td>&nbsp;</td>
			</tr>
		</tbody>
	</table>';
    echo '</div>';
}

/////////////////////////////////////////////
// Send Reminder Emails Form
////////////////////////////////////////////
function cwsiShowInvitesReminderEmailsForm(  $menu_slug, $results, $results_send  ) {
    $data = array();
    echo '
	<div class="cwsi_invitee_admin">';
    if ( is_array( $results_send ) ) {
        if ( isset( $results_send['status'] ) && $results_send['status'] == 0 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        } elseif ( isset( $results_send['status'] ) && $results_send['status'] == 1 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_successmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_successmsg">Saved successfully.</p>';
            }
        }
    }
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $invites = $results['data'];
        }
    }
    $emails = array();
    echo '
		<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
    wp_nonce_field( 'send-invites-reminder-emails', 'sendinvitesreminderemailsform' );
    echo '
			<table class="cwsi_invites_admin_table">
				<thead>
					<tr>
						<th width="25%">Email Settings</th>
						<th>Value</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>Subject</td>
						<td><input type="text" name="email_subject" required maxlength="255" autocomplete="off" value="" /></td>
					</tr>
					<tr>
						<td>FROM name</td>
						<td><input type="text" name="email_fromname" required maxlength="100" placeholder="Max. chars 100" autocomplete="off" value="" /></td>
					</tr>
					<tr>
						<td>FROM email<br />If your email is not sending, try using an email from the same domain as this website or use the Admin Email.</td>
						<td><input type="text" name="email_from" required maxlength="150" autocomplete="off" placeholder="Max. 150 chars" value=""/></td>
					</tr>
					<tr>
						<td>REPLY-TO email</td>
						<td><input type="email" name="email_replyto" maxlength="150" autocomplete="off" placeholder="Optional" value="" /></td>
					</tr>
					<tr>
						<td>Email Body<br /><span class="cwsi_small">Use placeholders such as: <ul><li>[full_name] - invitee&rsquo;s name</li> <li>[email] - their email</li></ul></td>
						<td>';
    $initial_data = '';
    $mce_settings = array(
        'quicktags'      => array(
            'buttons' => 'em,strong,link',
        ),
        'text_area_name' => 'email_body',
        'textarea_rows'  => get_option( 'default_post_edit_rows', 10 ),
        'tinymce'        => true,
    );
    $id = 'email_body';
    //has to be lower case
    wp_editor( $initial_data, $id, $mce_settings );
    echo '
						</td>
					</tr>
					<tr>
						<td>Is There an Attachment?</td>
						<td>
							<p><a href="" target="_blank" class="cwsi_small cwsi_hidden" id="cwsi_span_file">View Attachment In Other Tab</a></p>
							<input type="hidden" name="cwsi_attachment_id" id="cwsi_attachment_id" value="" />
							<input type="hidden" name="cwsi_attachment_url" id="cwsi_attachment_url" value="" />
							<button type="button" name="email_attachment" id="cwsi_invites_add_attachment">Browse Library</button>
						</td>
					</tr>
					<tr>
						<td>TO email(s)
							<br /><span class="cwsi_small">
								Enter 1 or more email addresses separated by commas here. Or select from the list of emails below. 
							</span>
						</td>
						<td>
							<textarea name="email_tofield" ></textarea>
						</td>
					</tr>
					<tr><th colspan=2 align="center">Select From The Invitees Who Have Not Responded</th></tr>
					<tr>
						<td colspan="2">
							<label class="checkbox" for="cwsi_all_invites">
								<input type="checkbox" name="cwsi_all_invites" id="cwsi_all_invites" value="1" /> Select All Invitees Who Have Not Responded
							</label><br /><br />Or select from the list below:<br /><br />';
    foreach ( $invites as $invite ) {
        // only show once
        if ( !in_array( $invite->email, $emails ) ) {
            $emails[] = $invite->email;
            echo '
									<label class="checkbox" for="inviteid_' . esc_html( $invite->ID ) . '">
									<input type="checkbox" name="invite[]" id="inviteid_' . esc_html( $invite->ID ) . '" value="' . esc_html( $invite->email ) . '" /> ' . esc_html( $invite->full_name ) . ' - ' . esc_html( $invite->email );
            echo '
									</label><br />';
        }
    }
    echo '
						</td>	
					</tr>
				</tbody>
			</table>
			<p><button type="submit">Send Email</button></p>
		</form>
	</div>';
}

/////////////////////////////////////////////
// Send SAVE THE DATE Emails Form
////////////////////////////////////////////
function cwsiShowInvitesSaveTheDateEmailsForm(  $menu_slug, $results, $results_send  ) {
    $data = array();
    echo '<br /><br />
	<div class="cwsi_invitee_admin">';
    if ( is_array( $results_send ) ) {
        if ( isset( $results_send['status'] ) && $results_send['status'] == 0 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        } elseif ( isset( $results_send['status'] ) && $results_send['status'] == 1 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_successmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_successmsg">Saved successfully.</p>';
            }
        }
    }
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $invites = $results['data'];
        }
    }
    $emails = array();
    echo '
		<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
    wp_nonce_field( 'send-invites-save-emails', 'sendinvitessaveemailsform' );
    echo '
			<table class="cwsi_invites_admin_table">
				<thead>
					<tr>
						<th width="25%">Email Settings</th>
						<th>Value</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>Subject</td>
						<td><input type="text" name="email_subject" required maxlength="255" autocomplete="off" value="" /></td>
					</tr>
					<tr>
						<td>FROM name</td>
						<td><input type="text" name="email_fromname" required maxlength="100" placeholder="Max. chars 100" autocomplete="off" value="" /></td>
					</tr>
					<tr>
						<td>FROM email<br />If your email is not sending, try using an email from the same domain as this website or use the Admin Email.</td>
						<td><input type="email" name="email_from" required maxlength="150"  autocomplete="off" placeholder="Max. 150 chars" value=""/></td>
					</tr>
					<tr>
						<td>REPLY-TO email</td>
						<td><input type="email" name="email_replyto" maxlength="150" autocomplete="off" placeholder="Optional" value="" /></td>
					</tr>
					<tr>
						<td>Email Body<br /><span class="cwsi_small">Use placeholders such as: <ul><li>[full_name] - invitee&rsquo;s name</li> <li>[email] - their email</li></ul></td>
						<td>';
    $initial_data = '';
    $mce_settings = array(
        'quicktags'      => array(
            'buttons' => 'em,strong,link',
        ),
        'text_area_name' => 'email_body',
        'textarea_rows'  => get_option( 'default_post_edit_rows', 10 ),
        'tinymce'        => true,
    );
    $id = 'email_body';
    //has to be lower case
    wp_editor( $initial_data, $id, $mce_settings );
    echo '
						</td>
					</tr>
					<tr>
						<td>TO email(s)
							<br /><span class="cwsi_small">
								Enter 1 or more email addresses separated by commas here. Or select from the list of emails below. 
							</span>
						</td>
						<td>
							<textarea name="email_tofield" ></textarea>
						</td>
					</tr>
					<tr><th colspan=2 align="center">Select From The Full List of Invitees</th></tr>
					<tr>
						<td colspan="2">
							<label class="checkbox" for="cwsi_all_invites">
								<input type="checkbox" name="cwsi_all_invites" id="cwsi_all_invites" value="1" /> Select All Invitees
							</label><br />
							<label class="checkbox" for="cwsi_unemailed_invites">
								<input type="checkbox" name="cwsi_unemailed_invites" id="cwsi_unemailed_invites" value="1" /> Select Anyone Not Emailed Yet (in blue below)
							</label><br /><br />
							Or select from the list below:<br /><br />';
    foreach ( $invites as $invite ) {
        // only show once
        if ( !in_array( $invite->email, $emails ) ) {
            $emails[] = $invite->email;
            if ( $invite->date_save_sent == "" || $invite->date_save_sent == "0000-00-00" ) {
                $class = "cwsi_blue_label";
            } else {
                $class = "";
            }
            echo '
									<label class="checkbox ' . esc_html( $class ) . '" for="inviteid_' . esc_html( $invite->ID ) . '">
									<input type="checkbox" name="invite[]" id="inviteid_' . esc_html( $invite->ID ) . '" value="' . esc_html( $invite->email ) . '" /> ' . esc_html( $invite->full_name ) . ' &lt;' . esc_html( $invite->email ) . '&gt;';
            echo '
									</label><br />';
        }
    }
    echo '
						</td>	
					</tr>
				</tbody>
			</table>
			<p><button type="submit">Send Email</button></p>
		</form>
	</div>';
}

////////////////////////////////////////////////////
// Invite Email Settings
///////////////////////////////////////////////////
function cwsiAdminInviteShowInviteSettings(
    $menu_slug,
    $results,
    $results_save,
    $results_send,
    $search_event_id
) {
    $data = array();
    echo '
	<div class="cwsi_invitee_admin">
		<p>These settings are used to send invitees the initial invitation email. Once you have saved the settings, you can send a test email below. </p>';
    if ( is_array( $results_save ) ) {
        if ( isset( $results_save['status'] ) && $results_save['status'] == 0 ) {
            if ( isset( $results_save['message'] ) && $results_save['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results_save['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        } elseif ( isset( $results_save['status'] ) && $results_save['status'] == 1 ) {
            if ( isset( $results_save['message'] ) && $results_save['message'] != "" ) {
                echo '<p class="cwsi_successmsg">' . esc_html( $results_save['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_successmsg">Saved successfully.</p>';
            }
        }
    }
    if ( is_array( $results_send ) ) {
        if ( isset( $results_send['status'] ) && $results_send['status'] == 0 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error sending the test message</p>';
            }
        } elseif ( isset( $results_send['status'] ) && $results_send['status'] == 1 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_successmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_successmsg">The test email was sent successfully.</p>';
            }
        }
    }
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $data = $results['data'];
        }
    }
    if ( count( $data ) <= 0 ) {
        $settings = new stdClass();
        $settings->ID = -1;
    } else {
        $settings = $data[0];
    }
    echo '
		<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
    wp_nonce_field( 'save-design-invite-settings', 'savedesigninvitesettingsform' );
    echo '
			<input type="hidden" value="' . esc_html( $settings->ID ) . '" name="settings_id">
			<input type="hidden" value="invite" name="message_type">
			<input type="hidden" value="' . esc_html( $search_event_id ) . '" name="event_id" />
			<table class="cwsi_invites_admin_table">
				<thead>
					<tr>
						<th width="33%">Setting</th>
						<th>Value</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>Email Subject</td>
						<td><input type="text" name="email_subject" required maxlength="255" autocomplete="off" value="';
    if ( isset( $settings->email_subject ) ) {
        echo esc_html( $settings->email_subject );
    }
    echo '"
						/>
						</td>
					</tr>
					<tr>
						<td>FROM name</td>
						<td><input type="text" name="email_fromname" required maxlength="100" placeholder="Max. chars 100" autocomplete="off" value="';
    if ( isset( $settings->email_fromname ) ) {
        echo esc_html( $settings->email_fromname );
    }
    echo '"
						/></td>
					</tr>
					<tr>
						<td>FROM email<br />If your email is not sending, try using an email from the same domain as this website or use the Admin Email.</td>
						<td><input type="text" name="email_from" required maxlength="150" autocomplete="off" placeholder="Max. 150 chars" value="';
    if ( isset( $settings->email_from ) ) {
        echo esc_html( $settings->email_from );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>REPLY-TO email</td>
						<td><input type="email" name="email_replyto" maxlength="150" autocomplete="off" placeholder="Optional" value="';
    if ( isset( $settings->email_replyto ) ) {
        echo esc_html( $settings->email_replyto );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>CC email (optional)</td>
						<td><input type="email" name="email_cc" maxlength="150" autocomplete="off" placeholder="Optional" value="';
    if ( isset( $settings->email_cc ) ) {
        echo esc_html( $settings->email_cc );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>BCC email (optional)</td>
						<td><input type="email" name="email_bcc" maxlength="150" autocomplete="off" placeholder="Optional" value="';
    if ( isset( $settings->email_bcc ) ) {
        echo esc_html( $settings->email_bcc );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>Email Body<br /><span class="cwsi_small">Use placeholders such as: 
							<ol>
								<li>[full_name]</li>
								<li>[email] - you can set up a customized RSVP button in your emailed invitation. Just add <em>?email=[email]</em> to the URL. When the invitee clicks on the RSVP button, the form uses their email to retrieve their name and any prior responses and displays on the form. For example, <pre>&lt;a href="https://www.charlenesweb.ca/test-rsvp/?email=[email]"&gt;RSVP&lt;/a&gt;</pre></li>
								<li>[personal_note] - if there is a personal note saved with the invitee then it can be added to the email.</li> 
							</ol>
						</td>
						<td>';
    if ( isset( $settings->email_body ) && $settings->email_body != "" ) {
        $initial_data = wp_kses( wp_unslash( $settings->email_body ), cwsi_invites_allowed_html() );
    } else {
        $initial_data = '';
    }
    $mce_settings = array(
        'quicktags'      => array(
            'buttons' => 'em,strong,link',
        ),
        'text_area_name' => 'email_body',
        'tinymce'        => true,
    );
    $id = 'email_body';
    //has to be lower case
    wp_editor( $initial_data, $id, $mce_settings );
    echo '
						</td>
					</tr>
				</tbody>
			</table>';
    echo '
			<p><button type="submit">Save</button></p>
		</form>
	</div>';
}

function cwsiAdminShowSendTestInviteEmail(  $menu_slug, $results, $message_type  ) {
    $data = array();
    echo '
	<div class="cwsi_invitee_admin">
		<h2>Send Test Email</h2>
		<p>Send a test email using the most recently saved settings. If you have changed the settings above then Save first and then send a test email. </p>';
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $data = $results['data'];
        }
    }
    if ( count( $data ) <= 0 ) {
        $settings = new stdClass();
        $fields = array(
            'email_subject',
            'email_fromname',
            'email_from',
            'email_replyto',
            'email_cc',
            'email_bcc',
            'email_body',
            'event_id'
        );
        foreach ( $fields as $field ) {
            $settings->{$field} = "";
        }
        $settings->ID = -1;
    } else {
        $settings = $data[0];
    }
    echo '
		<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post" style="background-color:#FFF; padding:16px;">';
    wp_nonce_field( 'send-test-email', 'sendtestemailform' );
    echo '
			<input type="hidden" value="send" name="send_email_test">
			<input type="hidden" value="' . esc_html( $settings->event_id ) . '" name="event_id">
			<input type="hidden" value="' . esc_html( $message_type ) . '" name="message_type">
			<p><strong>Subject: </strong>' . wp_kses( wp_unslash( nl2br( $settings->email_subject ) ), cwsi_invites_allowed_html() ) . '</p>
			<p><strong>From: </strong>' . esc_html( $settings->email_fromname ) . '&lt;' . esc_html( $settings->email_from ) . '&gt;';
    if ( isset( $settings->email_replyto ) && $settings->email_replyto != "" ) {
        echo '<p><strong>Reply-to: </strong>' . esc_html( $settings->email_replyto ) . '</p>';
    }
    if ( isset( $settings->email_cc ) && $settings->email_cc != "" ) {
        echo '<p><strong>Cc: </strong>' . esc_html( $settings->email_cc ) . '</p>';
    }
    if ( isset( $settings->email_bcc ) && $settings->email_bcc != "" ) {
        echo '<p><strong>Bcc: </strong>' . esc_html( $settings->email_bcc ) . '</p>';
    }
    if ( $message_type == "invite" ) {
        echo '<p><strong>Email Body</strong></p>';
    } else {
        echo '<p><strong>Email Body If Yes</strong></p>';
    }
    echo wp_kses( wp_unslash( nl2br( $settings->email_body ) ), cwsi_invites_allowed_html() );
    if ( $message_type == "confirmation" ) {
        echo '<p><strong>Email Body If No</strong></p>';
        if (isset($settings->email_body_2)) {
            echo wp_kses( wp_unslash( nl2br( $settings->email_body_2 ) ), cwsi_invites_allowed_html() );
        }
    }
    echo '<p><strong>To Email Address:</strong> <input type="email" name="email_to" maxlength="150" autocomplete="off" required value="" style="width:60%"; /></p>
			<p><button type="submit">Send</button></p>
		</form>
	</div>';
}

////////////////////////////////////////////////////
// Confirmation Email Settings
///////////////////////////////////////////////////
function cwsiAdminInviteShowConfirmationSettings(
    $menu_slug,
    $results,
    $results_save,
    $results_send,
    $search_event_id
) {
    $data = array();
    echo '
	<div class="cwsi_invitee_admin">
		<p>These settings are used to send invitees a confirmation email. Once you have saved the settings, you can send a test email below. </p>';
    if ( is_array( $results_save ) ) {
        if ( isset( $results_save['status'] ) && $results_save['status'] == 0 ) {
            if ( isset( $results_save['message'] ) && $results_save['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results_save['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        } elseif ( isset( $results_save['status'] ) && $results_save['status'] == 1 ) {
            if ( isset( $results_save['message'] ) && $results_save['message'] != "" ) {
                echo '<p class="cwsi_successmsg">' . esc_html( $results_save['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_successmsg">Saved successfully.</p>';
            }
        }
    }
    if ( is_array( $results_send ) ) {
        if ( isset( $results_send['status'] ) && $results_send['status'] == 0 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error sending the test message</p>';
            }
        } elseif ( isset( $results_send['status'] ) && $results_send['status'] == 1 ) {
            if ( isset( $results_send['message'] ) && $results_send['message'] != "" ) {
                echo '<p class="cwsi_successmsg">' . esc_html( $results_send['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_successmsg">The test email was sent successfully.</p>';
            }
        }
    }
    if ( is_array( $results ) ) {
        if ( isset( $results['status'] ) && $results['status'] == 0 ) {
            if ( isset( $results['message'] ) && $results['message'] != "" ) {
                echo '<p class="cwsi_failmsg">' . esc_html( $results['message'] ) . '</p>';
            } else {
                echo '<p class="cwsi_failmsg">There was an error</p>';
            }
        }
        if ( isset( $results['status'] ) && $results['status'] == 1 && isset( $results['data'] ) ) {
            $data = $results['data'];
        }
    }
    if ( count( $data ) <= 0 ) {
        $settings = new stdClass();
        $settings->ID = -1;
    } else {
        $settings = $data[0];
    }
    echo '
		<form action="/wp-admin/admin.php?page=' . esc_html( $menu_slug ) . '" method="post">';
    wp_nonce_field( 'save-design-confirmation-settings', 'savedesignconfirmationsettingsform' );
    echo '
			<input type="hidden" value="' . esc_html( $settings->ID ) . '" name="settings_id">
			<input type="hidden" value="confirmation" name="message_type">
			<input type="hidden" value="' . esc_html( $search_event_id ) . '" name="event_id">
			<table class="cwsi_invites_admin_table">
				<thead>
					<tr>
						<th width="33%">Setting</th>
						<th>Value</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>Email Subject</td>
						<td><input type="text" name="email_subject" required maxlength="255" autocomplete="off" value="';
    if ( isset( $settings->email_subject ) ) {
        echo esc_html( $settings->email_subject );
    }
    echo '"
						/>
						</td>
					</tr>
					<tr>
						<td>FROM name</td>
						<td><input type="text" name="email_fromname" required maxlength="100" placeholder="Max. chars 100" autocomplete="off" value="';
    if ( isset( $settings->email_fromname ) ) {
        echo esc_html( $settings->email_fromname );
    }
    echo '"
						/></td>
					</tr>
					<tr>
						<td>FROM email<br />If your email is not sending, try using an email from the same domain as this website or use the Admin Email.</td>
						<td><input type="text" name="email_from" required maxlength="150" autocomplete="off" placeholder="Max. 150 chars" value="';
    if ( isset( $settings->email_from ) ) {
        echo esc_html( $settings->email_from );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>REPLY-TO email</td>
						<td><input type="email" name="email_replyto" maxlength="150" autocomplete="off" placeholder="Optional" value="';
    if ( isset( $settings->email_replyto ) ) {
        echo esc_html( $settings->email_replyto );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>CC email (optional)</td>
						<td><input type="email" name="email_cc" maxlength="150" autocomplete="off" placeholder="Optional" value="';
    if ( isset( $settings->email_cc ) ) {
        echo esc_html( $settings->email_cc );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>BCC email (optional)</td>
						<td><input type="email" name="email_bcc" maxlength="150" autocomplete="off" placeholder="Optional" value="';
    if ( isset( $settings->email_bcc ) ) {
        echo esc_html( $settings->email_bcc );
    }
    echo '
						"/></td>
					</tr>
					<tr>
						<td>Email Body If Answer Is Yes<br /><span class="cwsi_small">Use placeholders such as: <ul><li>[full_name]</li><li>[email]</li><li>[num_guests] - total number of guests in the party</li><li>[rsvp_answer] - Yes or no</li><li>[comments] - if the invitee entered any</li></ul></td>
						<td>';
    if ( isset( $settings->email_body ) && $settings->email_body != "" ) {
        $initial_data = wp_kses( wp_unslash( $settings->email_body ), cwsi_invites_allowed_html() );
    } else {
        $initial_data = '';
    }
    $mce_settings = array(
        'quicktags'      => array(
            'buttons' => 'em,strong,link',
        ),
        'text_area_name' => 'email_body',
        'tinymce'        => true,
    );
    $id = 'email_body';
    //has to be lower case
    wp_editor( $initial_data, $id, $mce_settings );
    echo '
						</td>
					</tr>
					<tr>
						<td>Email Body If Answer Is No<br /><span class="cwsi_small">Use placeholders such as: <ul><li>[full_name]</li><li>[email]</li><li>[num_guests] - total number of guests in the party</li><li>[rsvp_answer] - Yes or no</li><li>[comments] - if the invitee entered any</li></ul></td>
						<td>';
    if ( isset( $settings->email_body_2 ) && $settings->email_body_2 != "" ) {
        $initial_data = wp_kses( wp_unslash( $settings->email_body_2 ), cwsi_invites_allowed_html() );
    } else {
        $initial_data = '';
    }
    $mce_settings = array(
        'quicktags'      => array(
            'buttons' => 'em,strong,link',
        ),
        'text_area_name' => 'email_body_2',
        'tinymce'        => true,
    );
    $id = 'email_body_2';
    //has to be lower case
    wp_editor( $initial_data, $id, $mce_settings );
    echo '
						</td>
					</tr>
				</tbody>
			</table>';
    echo '
			<p><button type="submit">Save</button></p>
		</form>
	</div>';
}
