(function( $ ) {
	'use strict';
	
	$( window ).load(function() {
		$( '#cwsi_invites_add_attachment' ).on( 'click', function( e ) {
			 e.preventDefault();
             var image_frame;
             if(image_frame){
                 image_frame.open();
             }
             // Define image_frame as wp.media object
             image_frame = wp.media({
                           title: 'Select Media',
                           multiple : false,
                           library : {
                                type : 'image,application/pdf',
                            }
             });

			image_frame.on('close',function() {
				// On close, get selections and save to the hidden input
				// plus other AJAX stuff to refresh the image preview
				var selection =  image_frame.state().get('selection');
				var gallery_ids = new Array();
				var my_index = 0;
				var selected_url = "";
				selection.each(function(attachment) {
					gallery_ids[my_index] = attachment['id'];
					selected_url = attachment.attributes.url;
					my_index++;
				});
				var ids = gallery_ids.join(",");
				if(ids.length === 0) return true;//if closed withput selecting an image
				jQuery('input#cwsi_attachment_id').val(ids);
				jQuery('input#cwsi_attachment_url').val(selected_url);
				jQuery('#cwsi_span_file').removeClass("cwsi_hidden").html("Click to view " + selected_url + " in new tab").attr("href", selected_url);
			});

			image_frame.on('open',function() {
				// On open, get the id from the hidden input
				// and select the appropiate images in the media manager
				var selection =  image_frame.state().get('selection');
				var ids = jQuery('input#cwsi_attachment_id').val().split(',');
				ids.forEach(function(id) {
					var attachment = wp.media.attachment(id);
					attachment.fetch();
					selection.add( attachment ? [ attachment ] : [] );
				});
			
			});
			
			image_frame.open();
		
		});
		$('#cwsi_all_invites').click(function(){
            if($(this).is(":checked")){
				$('input[type="checkbox"]'). prop('checked', true);
            }
            else if($(this).is(":not(:checked)")){
				$('input[type="checkbox"]'). prop('checked', false);
            }
        });
		$('#cwsi_unemailed_invites').click(function(){
            if($(this).is(":checked")){
				$('label.cwsi_blue_label input[type="checkbox"]'). prop('checked', true);
            }
            else if($(this).is(":not(:checked)")){
				$('label.cwsi_blue_label input[type="checkbox"]'). prop('checked', false);
            }
        });
	}); // END load
})( jQuery );
