<?php
/*
Plugin Name: CutQueue - Barber Booking System
Description: A modern and powerful barber booking system with built-in Stripe payments. Easily manage barber appointments, time slots, staff schedules, and client bookings. Perfect for barbershops, salons, and haircut businesses looking for an all-in-one online scheduling and queue management solution.
Version:     1.1
Author:      Stoyan Rizov
License:     GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/


if (!defined('ABSPATH'))
    exit;

define('CUTQUEUE_PATH', plugin_dir_path(__FILE__));
define('CUTQUEUE_URL', plugin_dir_url(__FILE__));

require_once CUTQUEUE_PATH . 'includes/cutqueue-shortcode.php';
require_once CUTQUEUE_PATH . 'includes/cutqueue-save.php';
require_once CUTQUEUE_PATH . 'includes/cutqueue-admin.php';

function cutqueue_booking_enqueue_scripts()
{
    wp_enqueue_script(
        'flatpickr',
        plugin_dir_url(__FILE__) . 'assets/js/flatpickr.js',
        array('jquery'),
        '4.6.13',
        true
    );

    wp_enqueue_style(
        'flatpickr-style',
        plugin_dir_url(__FILE__) . 'assets/css/flatpickr.min.css',
        array(),
        '4.6.13'
    );

    wp_enqueue_script(
        'stripe-js',
        'https://js.stripe.com/v3/',
        array(),
        3.0,
        true
    );

    wp_localize_script('cutqueue-script', 'cutqueue_booking_system_ajax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('cutqueue_booking_system_booking_nonce'),
        'slot_duration' => get_option('cutqueue_booking_system_slot_duration', 30)
    ));
}
add_action('wp_enqueue_scripts', 'cutqueue_booking_enqueue_scripts');

