<?php

$sva_plugin_label = "Spacer - Constructor";
$sva_plugin_slug = "spacer_layout_aid_preview";

class spacer_layout_aid_preview {

    public function __construct() {
        global $sva_plugin_label, $plugin_slug;
        $this->sva_plugin_slug = $plugin_slug;
        $this->sva_plugin_label = $sva_plugin_label;

        $checkaddspacers = get_option("motech_spacer_addspacer_id");
        $this->key_array = !empty($checkaddspacers) ? $checkaddspacers : array(0);
        $this->has_addspacers = !empty($checkaddspacers);
        $this->ihmsa = 'hmsia';

        add_filter('spacer_add_css', array($this, 'spacer_add_css'), 50, 2);
        add_filter('spacer_add_to_default', array($this, 'spacer_add_to_default'), 50);
        add_filter('spacer_add_to_extras', array($this, 'spacer_add_to_extras'), 50, 2);

        if (is_admin()) {
            add_action('admin_enqueue_scripts', array($this, 'enqueue_motech_javascript'), 10);
            add_filter('spacer_default_settings', array($this, 'add_layout_aid_section'), 50, 2);
            if ($this->ihmsa == 'hmsia') {
                add_filter('spacer_default_sections', array($this, 'add_layout_aid_section_container'), 50, 2);
            }
            add_filter('spacer_add_to_admincss', array($this, 'spacer_add_to_admincss'), 50);
            if ($this->ihmsa == 'hmsia') {
                add_action('admin_enqueue_scripts', array($this, 'load_custom_wp_admin_style'), 60);
            }
            $key_array = $this->key_array;
            if ($this->ihmsa == 'hmsia') {
                foreach ($key_array as $key => $value) {
                    add_filter('spacer_addspacer_sections' . $key, array($this, 'add_layout_aid_addspacer_section_container'), 50, 2);
                }
            }
        }
    }

    // Load custom styles
    function load_custom_wp_admin_style() {
        // Placeholder for additional styles if needed
    }

    // Add custom CSS for admin interface
    function spacer_add_to_admincss($val) {
        ?>
        <style>
            <?php if ($this->ihmsa == 'hmsia') { ?> #motech_spacer_visualartist_license { display: none; } <?php } ?>
            /* Modern column box styling */
            .columnbox-container {
                display: flex;
                flex-wrap: wrap;
                gap: 20px;
                margin-top: 20px;
            }
            .columnbox {
                flex: 1;
                min-width: 250px;
                max-width: 300px;
                background: #ffffff;
                border: 1px solid #e0e0e0;
                border-radius: 8px;
                box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
                padding: 15px;
                margin: 0;
                transition: transform 0.2s ease, box-shadow 0.2s ease;
            }
            .columnbox:hover {
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            }
            .columnbox h2, .postbox .inside .columnbox h2 {
                background: none;
                color: #333;
                font-size: 16px;
                font-weight: 600;
                margin: 0 0 15px 0;
                padding: 0;
                border-bottom: none;
            }
            .addspacerunit .columnbox {
                background: #f9f9f9;
            }
            .addspacerunit .columnbox h2, .addspacerunit .postbox .inside .columnbox h2 {
                background: none;
            }
            .columnbox .form-table th {
                font-weight: 500;
                color: #555;
                padding: 5px 0;
            }
            .columnbox .form-table td {
                padding: 5px 0;
            }
            .columnbox input[type="text"], .columnbox select {
                width: 100%;
                max-width: 100%;
                border: 1px solid #ddd;
                border-radius: 4px;
                padding: 6px 8px;
                font-size: 14px;
            }
            .columnbox .motech_upload_image_button {
                background: #0073aa;
                color: #fff;
                border: none;
                border-radius: 4px;
                padding: 6px 12px;
                margin-top: 5px;
                cursor: pointer;
                transition: background 0.2s ease;
            }
            .columnbox .motech_upload_image_button:hover {
                background: #005d87;
            }
            .motech_spacer_preview_image_container {
                display: none;
            }
            .wp-picker-holder {
                position: absolute;
            }
            /* Responsive adjustments */
            @media only screen and (max-width: 1200px) {
                .columnbox {
                    flex: 1 1 45%;
                    max-width: none;
                }
            }
            @media only screen and (max-width: 768px) {
                .columnbox {
                    flex: 1 1 100%;
                }
            }
        </style>
        <?php
    }

    // Add CSS for spacer
    function spacer_add_css($spacer_css, $activespacer) {
        extract($activespacer);
        if (!empty($bgcolor)) $spacer_css .= "background-color:$bgcolor;";
        if (!empty($bgimage)) $spacer_css .= "background-image:url($bgimage);";
        if (!empty($bordertopstyle)) $spacer_css .= "border-top-style:$bordertopstyle;";
        if (!empty($bordertopwidth)) $spacer_css .= "border-top-width:${bordertopwidth}px;";
        else $spacer_css .= "border-top-width:0px;";
        if (!empty($bordertopcolor)) $spacer_css .= "border-top-color:$bordertopcolor;";
        if (!empty($borderbottomwidth)) $spacer_css .= "border-bottom-width:${borderbottomwidth}px;";
        else $spacer_css .= "border-bottom-width:0px;";
        if (!empty($borderbottomstyle)) $spacer_css .= "border-bottom-style:$borderbottomstyle;";
        if (!empty($borderbottomcolor)) $spacer_css .= "border-bottom-color:$borderbottomcolor;";
        if (!empty($bottommargin)) $spacer_css .= "margin-bottom:${bottommargin}px;";
        if (!empty($shadow)) $spacer_css .= $this->use_shadow($shadow);
        if (!empty($bgimageposition)) $spacer_css .= $this->use_bgimageposition($bgimageposition);
        return $spacer_css;
    }

    // Add default spacer attributes
    function spacer_add_to_default($return) {
        $return["bgcolor"] = get_option('motech_spacer_default_bg_color');
        $return["bgimage"] = get_option('motech_spacer_default_background_image_upload');
        $return["bordertopwidth"] = get_option('motech_spacer_default_border_top_width');
        $return["bordertopstyle"] = get_option('motech_spacer_default_border_top_style');
        $return["bordertopcolor"] = get_option('motech_spacer_default_border_top_color');
        $return["borderbottomwidth"] = get_option('motech_spacer_default_border_bottom_width');
        $return["borderbottomstyle"] = get_option('motech_spacer_default_border_bottom_style');
        $return["borderbottomcolor"] = get_option('motech_spacer_default_border_bottom_color');
        $return["bottommargin"] = get_option('motech_spacer_default_bottom_margin');
        $return["shadow"] = get_option('motech_spacer_default_shadow');
        $return["bgimageposition"] = get_option('motech_spacer_custom_background_image_position');
        return $return;
    }

    // Add extra spacer attributes
    function spacer_add_to_extras($return, $key) {
        $get = get_option('motech_spacer_default_bg_color_addspacers');
        if (isset($get[$key])) $return["bgcolor"] = $get[$key];
        $get = get_option('motech_spacer_default_background_image_upload_addspacers');
        if (isset($get[$key])) $return["bgimage"] = $get[$key];
        $get = get_option('motech_spacer_default_border_top_width_addspacers');
        if (isset($get[$key])) $return["bordertopwidth"] = $get[$key];
        $get = get_option('motech_spacer_default_border_top_style_addspacers');
        if (isset($get[$key])) $return["bordertopstyle"] = $get[$key];
        $get = get_option('motech_spacer_default_border_top_color_addspacers');
        if (isset($get[$key])) $return["bordertopcolor"] = $get[$key];
        $get = get_option('motech_spacer_default_border_bottom_width_addspacers');
        if (isset($get[$key])) $return["borderbottomwidth"] = $get[$key];
        $get = get_option('motech_spacer_default_border_bottom_style_addspacers');
        if (isset($get[$key])) $return["borderbottomstyle"] = $get[$key];
        $get = get_option('motech_spacer_default_border_bottom_color_addspacers');
        if (isset($get[$key])) $return["borderbottomcolor"] = $get[$key];
        $get = get_option('motech_spacer_default_bottom_margin_addspacers');
        if (isset($get[$key])) $return["bottommargin"] = $get[$key];
        $get = get_option('motech_spacer_default_shadow_addspacers');
        if (isset($get[$key])) $return["shadow"] = $get[$key];
        $get = get_option('motech_spacer_custom_background_image_position_addspacers');
        if (isset($get[$key])) $return["bgimageposition"] = $get[$key];
        return $return;
    }

    // Apply shadow style
    function use_shadow($shadow) {
        if ($shadow == "light") return "box-shadow:0px 2px 3px rgba(119, 119, 119,0.5);";
        elseif ($shadow == "medium") return "box-shadow:0px 2px 4px #777;";
        elseif ($shadow == "heavy") return "box-shadow:0px 2px 10px #888;";
    }

    // Apply background image position
    function use_bgimageposition($bgimageposition) {
        if ($bgimageposition == "repeat") return "background-repeat:repeat;";
        elseif ($bgimageposition == "croptofit") return "background-size:cover;background-position:center;";
        elseif ($bgimageposition == "stretch") return "background-size:100% 100%;background-repeat:no-repeat;background-position:center;";
        elseif ($bgimageposition == "propstretch") return "background-size:contain;background-repeat:no-repeat;background-position:center;";
        elseif ($bgimageposition == "proprepeat") return "background-size:contain;background-repeat:repeat;background-position:center;";
    }

    // Enqueue custom JS
    function enqueue_motech_javascript() {
        if (isset($_GET['page']) && $_GET['page'] == 'motech_spacer-setting-admin') {
            wp_enqueue_script($this->sva_plugin_slug . '-motech-javascript2', plugins_url('js/motech-javascript.js', __FILE__), ['jquery'], false, true);
        }
    }

    // Render section for default spacer
    function add_layout_aid_section_container($val, $object) {
        ?>
        <div class="motech-spacer-options section layoutaid" style="border-top: solid 1px #BFBFBF; margin-top: 3px;">
            <div class="postbox" style="margin-top: 20px; margin-bottom: 12px;">
                <button type="button" class="handlediv button-link" aria-expanded="true"><span class="toggle-indicator" aria-hidden="true"></span></button>
                <h2 class="hndle ui-sortable-handle" style="font-size: 1.3em; font-weight: bold; padding-left: 51px; position: relative;">
                    <img style="position: absolute; top: -1px; width: 42px; left: 7px;" src="<?php echo plugins_url('images/palette.png', __FILE__); ?>" />
                    <span><?php _e('Constructor', 'spacer-layout-aid'); ?></span>
                </h2>
                <div class="inside">
                    <div class="columnbox-container">
                        <div class="columnbox">
                            <h2><?php _e('Background', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections($object->plugin_slug . '-setting-admin_layoutaidbg'); ?>
                        </div>
                        <div class="columnbox">
                            <h2><?php _e('Top Border', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections($object->plugin_slug . '-setting-admin_layoutaidtb'); ?>
                        </div>
                        <div class="columnbox">
                            <h2><?php _e('Bottom Border', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections($object->plugin_slug . '-setting-admin_layoutaidbb'); ?>
                        </div>
                        <div class="columnbox">
                            <h2><?php _e('Other', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections($object->plugin_slug . '-setting-admin_layoutaidother'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    // Render Constructor section for additional spacers
    function add_layout_aid_addspacer_section_container($val, $key) {
        ?>
        <div class="motech-spacer-options section layoutaid aslayoutaid" style="border-top: solid 1px #eee; margin-top: 3px;">
            <div class="postbox" style="margin-top: 20px; margin-bottom: 12px; background: #fafafa;">
                <button type="button" class="handlediv button-link" aria-expanded="true"><span class="toggle-indicator" aria-hidden="true"></span></button>
                <h2 class="hndle ui-sortable-handle" style="font-size: 1.3em; font-weight: bold; padding-left: 51px; position: relative;">
                    <img style="position: absolute; top: -1px; width: 42px; left: 7px;" src="<?php echo plugins_url('images/palette.png', __FILE__); ?>" />
                    <span><?php _e('Constructor', 'spacer-layout-aid'); ?></span>
                </h2>
                <div class="inside">
                    <div class="columnbox-container">
                        <div class="columnbox">
                            <h2><?php _e('Background', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections('motech_spacer-setting-admin_layoutaidbg_addspacer' . $key); ?>
                        </div>
                        <div class="columnbox">
                            <h2><?php _e('Top Border', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections('motech_spacer-setting-admin_layoutaidtb_addspacer' . $key); ?>
                        </div>
                        <div class="columnbox">
                            <h2><?php _e('Bottom Border', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections('motech_spacer-setting-admin_layoutaidbb_addspacer' . $key); ?>
                        </div>
                        <div class="columnbox">
                            <h2><?php _e('Other', 'spacer-layout-aid'); ?></h2>
                            <?php do_settings_sections('motech_spacer-setting-admin_layoutaidother_addspacer' . $key); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    // Register settings for ConstructorConstructor section
    function add_layout_aid_section($val, $object) {
        add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidbg');
        add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidtb');
        add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidbb');
        add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidother');

        // Background Color
        $field_id = $object->plugin_slug . '_default_bg_color';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, __('Color', 'spacer-layout-aid'), array($object, 'create_a_text_input'), $object->plugin_slug . '-setting-admin_layoutaidbg', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => '', "class" => "motech-color-field"
        ]);

        // Background Image
        $field_id = $object->plugin_slug . '_default_background_image_upload';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, 'Image', array($object, 'create_image_upload'), $object->plugin_slug . '-setting-admin_layoutaidbg', $object->plugin_slug . '_setting_section', [
            "id" => $field_id
        ]);

        // Image Position
        $field_id = $object->plugin_slug . '_custom_background_image_position';
        $object->back_options = [
            ["label" => "Repeat", "value" => "repeat"],
            ["label" => "Proportional Stretch", "value" => "propstretch"],
            ["label" => "Proportional Repeat", "value" => "proprepeat"],
            ["label" => "Crop to Fit", "value" => "croptofit"],
            ["label" => "Stretch", "value" => "stretch"]
        ];
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_repeat'));
        add_settings_field($field_id, 'Image Position', array($object, 'create_a_select_input'), $object->plugin_slug . '-setting-admin_layoutaidbg', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => 'repeat', "select_options" => $object->back_options
        ]);

        // Top Border Width
        $field_id = $object->plugin_slug . '_default_border_top_width';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, __('Width (px)', 'spacer-layout-aid'), array($object, 'create_a_text_input'), $object->plugin_slug . '-setting-admin_layoutaidtb', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "placeholder" => __('eg: 5', 'spacer-layout-aid'), "default" => ''
        ]);

        // Top Border Style
        $field_id = $object->plugin_slug . '_default_border_top_style';
        $object->unit_options = [
            ["label" => "Solid", "value" => "solid"],
            ["label" => "Dotted", "value" => "dotted"],
            ["label" => "Dashed", "value" => "dashed"],
            ["label" => "Double", "value" => "double"],
            ["label" => "Groove", "value" => "groove"],
            ["label" => "Inset", "value" => "inset"],
            ["label" => "Outset", "value" => "outset"]
        ];
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_solid'));
        add_settings_field($field_id, __('Style', 'spacer-layout-aid'), array($object, 'create_a_select_input'), $object->plugin_slug . '-setting-admin_layoutaidtb', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => 'solid', "meta" => 'style="max-width:450px;"', "select_options" => $object->unit_options
        ]);

        // Top Border Color
        $field_id = $object->plugin_slug . '_default_border_top_color';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, __('Color', 'spacer-layout-aid'), array($object, 'create_a_text_input'), $object->plugin_slug . '-setting-admin_layoutaidtb', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => '', "class" => "motech-color-field"
        ]);

        // Bottom Border Width
        $field_id = $object->plugin_slug . '_default_border_bottom_width';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, __('Width (px)', 'spacer-layout-aid'), array($object, 'create_a_text_input'), $object->plugin_slug . '-setting-admin_layoutaidbb', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "placeholder" => __('eg: 5', 'spacer-layout-aid'), "default" => ''
        ]);

        // Bottom Border Style
        $field_id = $object->plugin_slug . '_default_border_bottom_style';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_solid'));
        add_settings_field($field_id, __('Style', 'spacer-layout-aid'), array($object, 'create_a_select_input'), $object->plugin_slug . '-setting-admin_layoutaidbb', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => 'solid', "meta" => 'style="max-width:450px;"', "select_options" => $object->unit_options
        ]);

        // Bottom Border Color
        $field_id = $object->plugin_slug . '_default_border_bottom_color';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, __('Color', 'spacer-layout-aid'), array($object, 'create_a_text_input'), $object->plugin_slug . '-setting-admin_layoutaidbb', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => '', "class" => "motech-color-field"
        ]);

        // Bottom Margin
        $field_id = $object->plugin_slug . '_default_bottom_margin';
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
        add_settings_field($field_id, __('Bottom Margin (px)', 'spacer-layout-aid'), array($object, 'create_a_text_input'), $object->plugin_slug . '-setting-admin_layoutaidother', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "placeholder" => __('eg: 5', 'spacer-layout-aid'), "default" => ''
        ]);

        // Shadow
        $field_id = $object->plugin_slug . '_default_shadow';
        $object->unit_options = [
            ["label" => "None", "value" => "none"],
            ["label" => "Light", "value" => "light"],
            ["label" => "Medium", "value" => "medium"],
            ["label" => "Heavy", "value" => "heavy"]
        ];
        register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_none'));
        add_settings_field($field_id, __('Shadow', 'spacer-layout-aid'), array($object, 'create_a_select_input'), $object->plugin_slug . '-setting-admin_layoutaidother', $object->plugin_slug . '_setting_section', [
            "id" => $field_id, "default" => 'solid', "meta" => 'style="max-width:450px;"', "select_options" => $object->unit_options
        ]);

        // Add Spacer Layout Fields
        $key_array = $object->key_array;
        foreach ($key_array as $key => $value) {
            add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidbg_addspacer' . $key);
            add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidtb_addspacer' . $key);
            add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidbb_addspacer' . $key);
            add_settings_section($object->plugin_slug . '_setting_section', '', false, $object->plugin_slug . '-setting-admin_layoutaidother_addspacer' . $key);

            // Background Color (Add Spacer)
            $field_id = $object->plugin_slug . '_default_bg_color_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, __('Color', 'spacer-layout-aid'), array($object, 'create_a_text_input_array'), $object->plugin_slug . '-setting-admin_layoutaidbg_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => '', "key" => $key, "class" => "motech-color-field"
            ]);

            // Background Image (Add Spacer)
            $field_id = $object->plugin_slug . '_default_background_image_upload_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, 'Image', array($object, 'create_image_upload_array'), $object->plugin_slug . '-setting-admin_layoutaidbg_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "key" => $key
            ]);

            // Image Position (Add Spacer)
            $field_id = $object->plugin_slug . '_custom_background_image_position_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_repeat'));
            add_settings_field($field_id, 'Image Position', array($object, 'create_a_select_input_array'), $object->plugin_slug . '-setting-admin_layoutaidbg_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => 'repeat', "key" => $key, "select_options" => $object->back_options
            ]);

            // Top Border Width (Add Spacer)
            $field_id = $object->plugin_slug . '_default_border_top_width_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, __('Width (px)', 'spacer-layout-aid'), array($object, 'create_a_text_input_array'), $object->plugin_slug . '-setting-admin_layoutaidtb_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "placeholder" => __('eg: 5', 'spacer-layout-aid'), "key" => $key, "default" => '0'
            ]);

            // Top Border Style (Add Spacer)
            $field_id = $object->plugin_slug . '_default_border_top_style_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_solid'));
            add_settings_field($field_id, __('Style', 'spacer-layout-aid'), array($object, 'create_a_select_input_array'), $object->plugin_slug . '-setting-admin_layoutaidtb_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => 'solid', "meta" => 'style="max-width:450px;"', "key" => $key, "select_options" => $object->unit_options
            ]);

            // Top Border Color (Add Spacer)
            $field_id = $object->plugin_slug . '_default_border_top_color_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, __('Color', 'spacer-layout-aid'), array($object, 'create_a_text_input_array'), $object->plugin_slug . '-setting-admin_layoutaidtb_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => '', "key" => $key, "class" => "motech-color-field"
            ]);

            // Bottom Border Width (Add Spacer)
            $field_id = $object->plugin_slug . '_default_border_bottom_width_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, __('Width (px)', 'spacer-layout-aid'), array($object, 'create_a_text_input_array'), $object->plugin_slug . '-setting-admin_layoutaidbb_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "placeholder" => __('eg: 5', 'spacer-layout-aid'), "key" => $key, "default" => '0'
            ]);

            // Bottom Border Style (Add Spacer)
            $field_id = $object->plugin_slug . '_default_border_bottom_style_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_solid'));
            add_settings_field($field_id, __('Style', 'spacer-layout-aid'), array($object, 'create_a_select_input_array'), $object->plugin_slug . '-setting-admin_layoutaidbb_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => 'solid', "meta" => 'style="max-width:450px;"', "key" => $key, "select_options" => $object->unit_options
            ]);

            // Bottom Border Color (Add Spacer)
            $field_id = $object->plugin_slug . '_default_border_bottom_color_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, __('Color', 'spacer-layout-aid'), array($object, 'create_a_text_input_array'), $object->plugin_slug . '-setting-admin_layoutaidbb_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => '', "key" => $key, "class" => "motech-color-field"
            ]);

            // Bottom Margin (Add Spacer)
            $field_id = $object->plugin_slug . '_default_bottom_margin_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po'));
            add_settings_field($field_id, __('Bottom Margin (px)', 'spacer-layout-aid'), array($object, 'create_a_text_input_array'), $object->plugin_slug . '-setting-admin_layoutaidother_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "placeholder" => __('eg: 5', 'spacer-layout-aid'), "key" => $key, "default" => '0'
            ]);

            // Shadow (Add Spacer)
            $field_id = $object->plugin_slug . '_default_shadow_addspacers';
            register_setting($object->plugin_slug . '_option_group', $field_id, array($object, 'po_none'));
            add_settings_field($field_id, __('Shadow', 'spacer-layout-aid'), array($object, 'create_a_select_input_array'), $object->plugin_slug . '-setting-admin_layoutaidother_addspacer' . $key, $object->plugin_slug . '_setting_section', [
                "id" => $field_id, "default" => 'solid', "meta" => 'style="max-width:450px;"', "key" => $key, "select_options" => $object->unit_options
            ]);
        }
    }

    // Add plugin action links
    function add_plugin_action_links($links) {
        return array_merge(['settings' => '<a href="' . get_bloginfo('wpurl') . '/wp-admin/options-general.php?page=' . $this->sva_plugin_slug . '-setting-admin">Settings</a>'], $links);
    }

    // Add plugin row links
    function plugin_row_links($links, $file) {
        if ($file == plugin_basename(__FILE__)) {
            return array_merge($links, [
                '<a target="_blank" href="http://www.linkedin.com/in/ClevelandWebDeveloper/">' . __('Find me on LinkedIn') . '</a>',
                '<a target="_blank" href="http://twitter.com/ClevelandWebDev">' . __('Follow me on Twitter') . '</a>'
            ]);
        }
        return $links;
    }
}

$custom_plugin = new $sva_plugin_slug();