<?php
/*
Plugin Name: Cute Editor Text Divider
Description: Adds a text divider button to the WYSIWYG visual editor which allows you to add precise custom spacing between lines in your posts and pages.
Version: 1.1
Author: andykendev
License: GPL2
*/

if (is_admin()) {
	
	register_uninstall_hook(__FILE__, 'CuteEditorTextDivider_uninstall_B84890E');


    function CuteEditorTextDivider_uninstall_B84890E() 
	{
		global $wpdb;

		$plugin_slug = "motech_spacer";
		$like_pattern = $wpdb->esc_like($plugin_slug . '_') . '%';

		// Get all matching option names
		$options = $wpdb->get_col(
			$wpdb->prepare(
				"SELECT option_name FROM {$wpdb->options} WHERE option_name LIKE %s",
				$like_pattern
			)
		);

		// Delete each option
		if (!empty($options)) {
			foreach ($options as $option_name) {
				delete_option($option_name);
			}
		}
	}
}



$plugin_label = "Cute Text Divider";
$plugin_slug = "motech_spacer";

class motech_spacer {

    public function __construct() {
        global $plugin_label, $plugin_slug;
        $this->plugin_slug = $plugin_slug;
        $this->plugin_label = $plugin_label;
        $this->plugin_dir = plugins_url('', __FILE__);
        $checkaddspacers = get_option($this->plugin_slug . "_addspacer_id");
        $this->key_array = !empty($checkaddspacers) ? $checkaddspacers : array(0);
        $this->has_addspacers = !empty($checkaddspacers);

        // Register shortcode and TinyMCE filter
        add_shortcode('spacer', array($this, 'addShortcodeHandler'));
        add_filter('tiny_mce_version', array($this, 'my_refresh_mce'));

        // Plugin row links
        add_filter('plugin_row_meta', array($this, 'plugin_row_links'), 10, 2);

        if (is_admin()) {
            add_action('admin_init', array($this, 'page_init'));
            add_action('admin_menu', array($this, 'add_plugin_page'));
            add_action('admin_head', array($this, 'motech_imagepicker_admin_css'));
            add_action('admin_footer', array($this, 'motech_imagepicker_admin_jquery'));
            add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'add_plugin_action_links'));
            add_action('admin_enqueue_scripts', array($this, 'spacer_imageupload_script'));
            add_action('admin_enqueue_scripts', array($this, 'enqueue_color_picker'));
            add_action('admin_enqueue_scripts', array($this, 'enqueue_motech_javascript'), 50);
            add_action('wp_ajax_motech_spacer', array($this, 'motech_spacer_callback'));
            add_action('wp_ajax_add_new_spacer', array($this, 'add_new_spacer_callback')); // Add AJAX handler
            add_action('admin_init', array($this, 'adminmessage_init'));
            add_action('admin_enqueue_scripts', array($this, 'load_custom_wp_admin_style'), 50);
        } else {
            add_action('wp_enqueue_scripts', array($this, 'load_custom_wp_admin_style'));
        }

        // Load plugin text domain for localization
        load_plugin_textdomain('motech-spacer', false, dirname(plugin_basename(__FILE__)) . '/languages/');

        register_activation_hook(__FILE__, array($this, 'activate'));
		add_action('admin_init', array($this, 'redirect_after_activation'));
    }

	public function redirect_after_activation() 
	{
		$plugin_slug = "motech_spacer";
		
		if (get_option($plugin_slug . '_do_activation_redirect')) {
			delete_option($plugin_slug . '_do_activation_redirect');
			
			// Prevent redirect on bulk activation
			if (isset($_GET['activate-multi'])) {
				return;
			}

			wp_safe_redirect(admin_url('options-general.php?page=motech_spacer-setting-admin'));
			exit;
		}
	}

    public function activate() {

        //global $plugin_label, $plugin_slug;

        $plugin_slug = "motech_spacer";

        $this->plugin_slug = $plugin_slug;

        $check = get_option($plugin_slug . '_default_bg_color_addspacers','');
        if ($check === false || is_null($check) || (is_string($check) && trim($check) == ''))
        {
            // Define default spacer data as arrays
            $default_spacers = array(
                1 => array(
                    'id' => '1',
                    'title' => 'Medium Divider',
                    'bg_color' => '',
                    'background_image' => '',
                    'background_position' => 'repeat',
                    'border_top_width' => '',
                    'border_top_style' => 'none',
                    'border_top_color' => '',
                    'border_bottom_width' => '',
                    'border_bottom_style' => 'none',
                    'border_bottom_color' => '',
                    'bottom_margin' => '',
                    'shadow' => 'none',
                    'height' => '20',
                    'height_unit' => 'px',
                    'height_mobile' => '',
                    'height_mobile_unit' => 'px',
                    'spacer_class' => '',
                    'spacer_style' => '',
                ),
                2 => array(
                    'id' => '2',
                    'title' => 'Line Divider',
                    'bg_color' => '#9e9e9e',
                    'background_image' => '',
                    'background_position' => 'repeat',
                    'border_top_width' => '',
                    'border_top_style' => 'none',
                    'border_top_color' => '',
                    'border_bottom_width' => '',
                    'border_bottom_style' => 'none',
                    'border_bottom_color' => '',
                    'bottom_margin' => '',
                    'shadow' => 'heavy',
                    'height' => '2',
                    'height_unit' => 'px',
                    'height_mobile' => '',
                    'height_mobile_unit' => 'px',
                    'spacer_class' => '',
                    'spacer_style' => 'margin:30px 0;',
                ),
                3 => array(
                    'id' => '3',
                    'title' => 'Design Divider',
                    'bg_color' => '',
                    'background_image' => '/wp-content/plugins/'.basename(__DIR__).'/images/bg/1754772200-1-7.svg',
                    'background_position' => 'repeat',
                    'border_top_width' => '',
                    'border_top_style' => 'none',
                    'border_top_color' => '',
                    'border_bottom_width' => '',
                    'border_bottom_style' => 'none',
                    'border_bottom_color' => '',
                    'bottom_margin' => '',
                    'shadow' => 'none',
                    'height' => '20',
                    'height_unit' => 'px',
                    'height_mobile' => '',
                    'height_mobile_unit' => 'px',
                    'spacer_class' => '',
                    'spacer_style' => '',
                ),
            );

            // Extract data for each option
            $addspacer_ids = array();
            $titles = array();
            $bg_colors = array();
            $background_images = array();
            $background_positions = array();
            $border_top_widths = array();
            $border_top_styles = array();
            $border_top_colors = array();
            $border_bottom_widths = array();
            $border_bottom_styles = array();
            $border_bottom_colors = array();
            $bottom_margins = array();
            $shadows = array();
            $heights = array();
            $height_units = array();
            $height_mobiles = array();
            $height_mobile_units = array();
            $spacer_classes = array();
            $spacer_styles = array();

            foreach ($default_spacers as $key => $spacer) {
                $addspacer_ids[$key] = $spacer['id'];
                $titles[$key] = $spacer['title'];
                $bg_colors[$key] = $spacer['bg_color'];
                $background_images[$key] = $spacer['background_image'];
                $background_positions[$key] = $spacer['background_position'];
                $border_top_widths[$key] = $spacer['border_top_width'];
                $border_top_styles[$key] = $spacer['border_top_style'];
                $border_top_colors[$key] = $spacer['border_top_color'];
                $border_bottom_widths[$key] = $spacer['border_bottom_width'];
                $border_bottom_styles[$key] = $spacer['border_bottom_style'];
                $border_bottom_colors[$key] = $spacer['border_bottom_color'];
                $bottom_margins[$key] = $spacer['bottom_margin'];
                $shadows[$key] = $spacer['shadow'];
                $heights[$key] = $spacer['height'];
                $height_units[$key] = $spacer['height_unit'];
                $height_mobiles[$key] = $spacer['height_mobile'];
                $height_mobile_units[$key] = $spacer['height_mobile_unit'];
                $spacer_classes[$key] = $spacer['spacer_class'];
                $spacer_styles[$key] = $spacer['spacer_style'];
            }

            // Update options with arrays
            update_option($this->plugin_slug . '_addspacer_id', $addspacer_ids);
            update_option($this->plugin_slug . '_title_addspacers', $titles);
            update_option($this->plugin_slug . '_default_bg_color_addspacers', $bg_colors);
            update_option($this->plugin_slug . '_default_background_image_upload_addspacers', $background_images);
            update_option($this->plugin_slug . '_custom_background_image_position_addspacers', $background_positions);
            update_option($this->plugin_slug . '_default_border_top_width_addspacers', $border_top_widths);
            update_option($this->plugin_slug . '_default_border_top_style_addspacers', $border_top_styles);
            update_option($this->plugin_slug . '_default_border_top_color_addspacers', $border_top_colors);
            update_option($this->plugin_slug . '_default_border_bottom_width_addspacers', $border_bottom_widths);
            update_option($this->plugin_slug . '_default_border_bottom_style_addspacers', $border_bottom_styles);
            update_option($this->plugin_slug . '_default_border_bottom_color_addspacers', $border_bottom_colors);
            update_option($this->plugin_slug . '_default_bottom_margin_addspacers', $bottom_margins);
            update_option($this->plugin_slug . '_default_shadow_addspacers', $shadows);
            update_option($this->plugin_slug . '_default_height_addspacers', $heights);
            update_option($this->plugin_slug . '_default_height_unit_addspacers', $height_units);
            update_option($this->plugin_slug . '_default_height_mobile_addspacers', $height_mobiles);
            update_option($this->plugin_slug . '_default_height_mobile_unit_addspacers', $height_mobile_units);
            update_option($this->plugin_slug . '_spacer_class_addspacers', $spacer_classes);
            update_option($this->plugin_slug . '_spacer_style_addspacers', $spacer_styles);
        }
		
		add_option($this->plugin_slug . '_do_activation_redirect', true);

    }

    function load_custom_wp_admin_style() {
        if ( current_user_can('edit_posts') or current_user_can('edit_pages') ) {
            wp_register_style( 'mspacer_wp_admin_css', plugins_url( 'admin-style.css' , __FILE__ ), false, '1.0.0' );
            wp_enqueue_style( 'mspacer_wp_admin_css' );
        }
        if (isset($_GET['page']) && $_GET['page'] == $this->plugin_slug.'-setting-admin') { //if we are on our admin page
            wp_register_style( 'mspacer_wp_adminpage_css', plugins_url( 'adminpage-style.css' , __FILE__ ), false, '1.0.0' );
            wp_enqueue_style( 'mspacer_wp_adminpage_css' );
        }
    }

    function motech_spacer_callback() {
        $return = array();
        $checkheight = get_option($this->plugin_slug . '_default_height','20');
        $checkunit = get_option($this->plugin_slug . '_default_height_unit','px');
        $return["useheight"] = $checkheight.$checkunit;
        if($this->has_addspacers){
            $ids = $this->key_array;
            $checkaddheights = get_option($this->plugin_slug . '_default_height_addspacers');
            $checkaddheightunits = get_option($this->plugin_slug . '_default_height_unit_addspacers');
            $checktitles = get_option($this->plugin_slug . '_title_addspacers');
            foreach($ids as $key=>$value){
                $useheight = $checkaddheights[$key];
                $useunit = $checkaddheightunits[$key];
                $usetitle = $checktitles[$key];
                if(empty($usetitle)){
                    $usetitle = "Untitled";
                }
                $return["addspacers"][] = array("id"=>$value,"height"=>$useheight.$useunit,"title"=>$usetitle);
            }
        }
        echo json_encode($return);
        wp_die(); // this is required to terminate immediately and return a proper response
    }

// AJAX callback to add new spacer
    /*
     * motech_spacer_custom_background_image_upload_addspacers[2]
     * motech_spacer_default_background_image_upload_addspacers[2]
     *
     *
     */
    function add_new_spacer_callback() {
        // Log request for debugging
        error_log('add_new_spacer_callback called with data: ' . print_r($_POST, true));

        // Check nonce
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'add_new_spacer_nonce')) {
            error_log('Nonce verification failed');
            wp_send_json_error('Nonce verification failed.');
        }

        // Get data
        $title = isset($_POST['title']) ? sanitize_text_field($_POST['title']) : '';
        $image = isset($_POST['image']) ? esc_url_raw($_POST['image']) : '';

        if (empty($title) || empty($image)) {
            error_log('Title or image missing: title=' . $title . ', image=' . $image);
            wp_send_json_error('Title or image is missing.');
        }

        // Get current spacer arrays
        $addspacer_ids = get_option($this->plugin_slug . '_addspacer_id', array());
        $titles = get_option($this->plugin_slug . '_title_addspacers', array());
        //$images = get_option($this->plugin_slug . '_custom_background_image_upload_addspacers', array());
        $images = get_option($this->plugin_slug . '_default_background_image_upload_addspacers', array());
        $heights = get_option($this->plugin_slug . '_default_height_addspacers', array());
        $height_units = get_option($this->plugin_slug . '_default_height_unit_addspacers', array());

        // Generate new ID
        $new_id = !empty($addspacer_ids) ? max($addspacer_ids) + 1 : 1;
        if (!is_array($addspacer_ids)) $addspacer_ids = array();
        $addspacer_ids[] = $new_id;

        if (!is_array($titles)) $titles = array();
        if (!is_array($images)) $images = array();
        if (!is_array($heights)) $heights = array();
        if (!is_array($height_units)) $height_units = array();

        // Save data for new spacer
        $key = array_search($new_id, $addspacer_ids);
        $titles[$key] = $title;
        $images[$key] = $image; // Save full URL
        $heights[$key] = '20'; // Default height
        $height_units[$key] = 'px'; // Default unit


        error_log('key: ' . $key);
        error_log('addspacer_ids: ' . print_r($addspacer_ids, true));
        error_log('titles: ' . print_r($titles, true));
        error_log('images: ' . print_r($images, true));
        error_log('heights: ' . print_r($heights, true));
        error_log('height_units: ' . print_r($height_units, true));

        // Save updated data
        $result1 = update_option($this->plugin_slug . '_addspacer_id', $addspacer_ids);
        $result2 = update_option($this->plugin_slug . '_title_addspacers', $titles);
        //$result3 = update_option($this->plugin_slug . '_custom_background_image_upload_addspacers', $images);
        $result3 = update_option($this->plugin_slug . '_default_background_image_upload_addspacers', $images);
        $result4 = update_option($this->plugin_slug . '_default_height_addspacers', $heights);
        $result5 = update_option($this->plugin_slug . '_default_height_unit_addspacers', $height_units);

        if ($result1 && $result2 && $result3 && $result4 && $result5) {
            wp_send_json_success('Spacer added successfully.');
        } else {
            error_log('Failed to save options: ' . print_r(array(
                    'addspacer_ids' => $result1,
                    'titles' => $result2,
                    'images' => $result3,
                    'heights' => $result4,
                    'height_units' => $result5
                ), true));
            wp_send_json_error('Failed to save spacer data.');
        }
    }



    function adminmessage_init()
    {
        if ( isset($_GET['spacer2295_nag_ignore']) && '0' == $_GET['spacer2295_nag_ignore'] ) {
            $user_id = get_current_user_id();
            add_user_meta($user_id, 'spacer2295_nag_ignore', 'true', true);
            if (wp_get_referer()) {
                /* Redirects user to where they were before */
                wp_safe_redirect(wp_get_referer());
            } else {
                /* if there is no referrer you redirect to home */
                wp_safe_redirect(home_url());
            }
        }
    }

    function enqueue_color_picker( $hook_suffix ) {
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( $this->plugin_slug.'-script-handle', plugins_url('js/motech-color-picker.js', __FILE__ ), array( 'wp-color-picker' ), false, true );
    }

    function enqueue_motech_javascript( ) {
        if (isset($_GET['page']) && $_GET['page'] == $this->plugin_slug.'-setting-admin') {
            wp_enqueue_script( $this->plugin_slug.'-motech-javascript', plugins_url('js/motech-javascript.js', __FILE__ ), array('jquery'), false, true );
        }
    }

    function spacer_imageupload_script() {
        if (isset($_GET['page']) && $_GET['page'] == $this->plugin_slug.'-setting-admin') {
            if(function_exists('wp_enqueue_media')){
                wp_enqueue_media();
            }
            wp_register_script('spacer_imageupload-js', plugins_url( 'js/spacer_imageupload.js' , __FILE__ ), array('jquery'));
            wp_enqueue_script('spacer_imageupload-js');
        }
    }

    // Get active spacer attributes
    function activespacer($id = "") {
        $return = array();
        if ($this->has_addspacers && $id != "") {
            $ids = $this->key_array;
            $key = array_search($id, $ids);
            if ($key !== false) {
                $get = get_option($this->plugin_slug . '_spacer_style_addspacers');
                $return["defaultstyle"] = $get[$key];
                $get = get_option($this->plugin_slug . '_default_height_mobile_addspacers');
                $return["mobile_height_default"] = $get[$key];
                $return["mobile_height"] = $return["mobile_height_default"];
                $get = get_option($this->plugin_slug . '_default_height_mobile_unit_addspacers');
                $return["mobileunit"] = $get[$key];
                $get = get_option($this->plugin_slug . '_default_height_addspacers');
                $return["checkheight"] = $get[$key];
                $get = get_option($this->plugin_slug . '_default_height_unit_addspacers');
                $return["checkunit"] = $get[$key];
                $get = get_option($this->plugin_slug . '_custom_background_image_upload_addspacers');
                $return["bg"] = $get[$key]; // Add image path
                $get = get_option($this->plugin_slug . '_spacer_class_addspacers');
                $return["defaultclasses"] = $get[$key];
                if (has_filter('spacer_add_to_extras')) {
                    $return = apply_filters('spacer_add_to_extras', $return, $key);
                }
                return $return;
            }
        }

        $return["mobile_height_default"] = get_option($this->plugin_slug . '_default_height_mobile', '');
        $return["mobile_height"] = get_option($this->plugin_slug . '_default_height_mobile', '');
        $return["mobileunit"] = get_option($this->plugin_slug . '_default_height_mobile_unit', 'px');
        $return["checkheight"] = get_option($this->plugin_slug . '_default_height', '20');
        $return["checkunit"] = get_option($this->plugin_slug . '_default_height_unit', 'px');
        $return["bg"] = get_option($this->plugin_slug . '_custom_background_image_upload', '');
        $return["defaultclasses"] = get_option($this->plugin_slug . '_spacer_class', '');
        $return["defaultstyle"] = get_option($this->plugin_slug . '_spacer_style', '');
        if (has_filter('spacer_add_to_default')) {
            $return = apply_filters('spacer_add_to_default', $return);
        }

        return $return;
    }

    // add the shortcode handler
    // Shortcode handler
    function addShortcodeHandler($atts, $content = null) {
        extract(shortcode_atts(array("height" => '', "mheight" => '', "class" => '', "id" => '', "style" => ''), $atts));
        $activespacer = $this->activespacer($id);

        // Prep variables
        $spacer_css = "";
        $classes = "";

        // Prep mobile height
        $mobile_height = "";
        $mobile_height_inline = "";
        $mobile_height_default = $activespacer["mobile_height_default"];

        if (isset($mheight) && $mheight != "") {
            $mobile_height = $mheight;
            $mobile_height_inline = $mheight;
        } elseif (isset($mobile_height_default) && $mobile_height_default != "") {
            $mobile_height = $activespacer["mobile_height"];
            $mobile_height_default = $mobile_height;
        }

        if (function_exists('wp_is_mobile') && wp_is_mobile() && (isset($mobile_height) && $mobile_height != "")) {
            $mobileunit = $activespacer["mobileunit"];
            if (isset($mobile_height_inline) && $mobile_height_inline != "") {
                if ($mobile_height_inline > 0) {
                    $spacer_css .= "padding-top: " . $mobile_height_inline . ";";
                } elseif ($mobile_height_inline < 0) {
                    $spacer_css .= "margin-top: " . $mobile_height_inline . ";";
                } elseif ($mobile_height_inline == 0) {
                    $spacer_css .= "display:none;";
                }
            } elseif (isset($mobile_height_default) && $mobile_height_default != "") {
                if ($mobile_height_default > 0) {
                    $spacer_css .= "padding-top: " . $mobile_height_default . $mobileunit . ";";
                } elseif ($mobile_height_default < 0) {
                    $spacer_css .= "margin-top: " . $mobile_height_default . $mobileunit . ";";
                } elseif ($mobile_height_default == 0) {
                    $spacer_css .= "display:none;";
                }
            }
        } elseif ($height == "default") {
            $checkheight = $activespacer["checkheight"];
            $checkunit = $activespacer["checkunit"];
            if ($checkheight > 0) {
                $spacer_css .= "padding-top: " . $checkheight . $checkunit . ";";
            } elseif ($checkheight < 0) {
                $spacer_css .= "margin-top: " . $checkheight . $checkunit . ";";
            }
        } elseif ($height > 0) {
            $spacer_css .= "padding-top: " . $height . ";";
        } elseif ($height < 0) {
            $spacer_css .= "margin-top: " . $height . ";";
        }

        // Custom background image
        $bg = $activespacer["bg"];
        if (!empty($bg)) {
            $spacer_css .= "background: url(" . esc_url($bg) . ");";
        }

        // Classes
        $defaultclasses = $activespacer["defaultclasses"];
        $classes .= $defaultclasses;
        if (!empty($class)) {
            $classes .= " " . $class;
        }

        if (has_filter('spacer_add_css')) {
            $spacer_css = apply_filters('spacer_add_css', $spacer_css, $activespacer);
        }

        // Styles
        $defaultstyle = $activespacer["defaultstyle"];
        $spacer_css .= $defaultstyle;
        if (!empty($style)) {
            $spacer_css .= " " . $style;
        }
        $classes = esc_attr($classes);
        $spacer_css = esc_attr($spacer_css);

        // Create the spacer
        return '<span class="' . $classes . '" style="display:block;clear:both;height: 0px;' . $spacer_css . '"></span>';
    }

    function background_position(){
        $bgposition = get_option($this->plugin_slug.'_custom_background_image_position','repeat');
        if($bgposition=="repeat"){
            return "background-repeat:repeat;";
        } elseif($bgposition=="croptofit"){
            return "background-size:cover;background-position:center;";
        } elseif($bgposition=="stretch"){
            return "background-size: 100% 100%;background-repeat: no-repeat;background-position: center;";
        } elseif($bgposition=="propstretch"){
            return "background-size: contain;background-repeat: no-repeat;background-position: center;";
        }
    }


    function add_custom_button() {
        if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
            return;
        if ( get_user_option('rich_editing') == 'true') {
            add_filter('mce_external_plugins', array($this, 'add_custom_tinymce_plugin'),99999999);
            add_filter('mce_buttons', array($this, 'register_custom_button'),99999999);
            global $wp_version;
            //if($wp_version < 3.9){
            add_action('admin_head', array($this,'motech_spacer_prepjsbuttons'));
            add_action('wp_head', array($this,'motech_spacer_prepjsbuttons'));
            //}
        }

    }

    function register_custom_button($buttons) {
        array_push($buttons, "|", get_class($this));
        return $buttons;
    }

    function add_custom_tinymce_plugin($plugin_array) {
        global $wp_version;
        //use this in a plugin
        if($wp_version >= 3.9){
            $plugin_array[get_class($this)] = plugins_url( 'editor_plugin.js' , __FILE__ );
        }else {
            $plugin_array[get_class($this)] = plugins_url( 'editor_plugin_back.js' , __FILE__ );
        }
        //use this in a theme
        //$plugin_array[get_class($this)] = get_bloginfo('template_url').'/editor_plugin.js';
        return $plugin_array;
    }

    function my_refresh_mce($ver) {
        $ver += 5;
        return $ver;
    }

    function plugin_row_links($links, $file) {
        $plugin = plugin_basename(__FILE__);
        if ($file == $plugin) // only for this plugin
            return array_merge( $links,
                array( '<a target="_blank" href="http://www.clevelandwebdeveloper.com/wordpress-plugins/spacer/">' . __('Project homepage', 'motech-spacer' ) . '</a>' ),
                array( '<a target="_blank" href="http://www.linkedin.com/in/ClevelandWebDeveloper/">' . __('Find me on LinkedIn', 'motech-spacer' ) . '</a>' ),
                array( '<a target="_blank" href="http://twitter.com/ClevelandWebDev">' . __('Follow me on Twitter', 'motech-spacer') . '</a>' )
            );
        return $links;
    }

    public function create_admin_page()
    {
        $action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : '';

        switch ($action)
        {
            case 'restore-purchase':
                self::RestorePurchase();
                break;
        }
        ?>
        <div class="wrap" style="position:relative">

            <h2 class="aplabel"><?php echo $this->plugin_label ?></h2>

            <h2 class="nav-tab-wrapper">
                <a href="#defaultspacer" class="nav-tab nav-tab-active"><span class="dashicons dashicons-align-wide"></span> <?php _e('Default Divider', 'motech-spacer')?></a>
                <a href="#addspacers" class="nav-tab"><span class="dashicons dashicons-menu-alt3"></span> <?php _e('Manage Dividers', 'motech-spacer')?></a>
                <?php do_action( 'spacer_sectiontabhook' ); #use this hook to add additional section tabs ?>
                <a href="#addons" class="nav-tab"><span class="dashicons dashicons-superhero-alt"></span> <?php _e('Premium Dividers', 'motech-spacer')?></a>
                <a href="#licenses" class="nav-tab"><span class="dashicons dashicons-admin-network"></span> <?php _e('License & Support', 'motech-spacer')?></a>
            </h2>

            <form method="post" action="options.php" class="<?php echo $this->plugin_slug ?>_form">
                <?php
                // This prints out all hidden setting fields
                settings_fields($this->plugin_slug.'_option_group');
                ?>
                <div id="defaultspacer" class="metabox-holder mainsection aspacerunit">
                    <div class="motech-spacer-options section general wrap" style="border-bottom: solid 1px #BFBFBF;padding-bottom: 3px;">
                        <?php do_settings_sections($this->plugin_slug.'-setting-admin'); ?>
                    </div>
                    <div class="motech-spacer-options section mobileoptions" style="border-bottom: solid 1px #BFBFBF;padding-bottom: 3px;">
                        <?php do_settings_sections($this->plugin_slug.'-setting-admin_mobileoptions'); ?>
                    </div>
                    <div class="motech-spacer-options section styleoptions">
                        <?php do_settings_sections($this->plugin_slug.'-setting-admin_styleoptions'); ?>
                    </div>
                    <?php
                    if(has_filter('spacer_default_sections')) {
                        apply_filters('spacer_default_sections', '',$this);
                    }
                    ?>
                    <div class="spacer_preview_area_container">
                        <h2><?php _e('Text Preview', 'motech-spacer')?></h2>
                        <div class="spacer_preview_area">
                            <p><?php _e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec eu turpis nulla. Suspendisse laoreet velit nec velit elementum, ac hendrerit sapien tristique. In quis iaculis mauris. Cras viverra aliquet quam vel rutrum.', 'motech-spacer')?></p>
                            <span class="spacer_preview" style="display:block;clear:both;height: 0px;padding-top: 20px;"></span>
                            <p><?php _e('Praesent vehicula nisi ut lacus ultricies, et ultrices neque laoreet. Ut at porta tellus. Quisque tristique erat sit amet turpis tincidunt, sit amet sagittis quam pulvinar. Sed massa ex, accumsan porttitor dui ut, porta efficitur dolor. Interdum et malesuada fames ac ante ipsum primis in faucibus.', 'motech-spacer')?></p>
                        </div>
                    </div>
                    <div class="hidden" style="display:none;"><?php do_settings_sections($this->plugin_slug.'-setting-admin_hdoptions'); ?></div>
                </div>
                <div id="addspacers" class="metabox-holder mainsection hidden wrap">
                    <h2 style="padding-bottom:20px;"><?php _e('Add New Text Divider', 'motech-spacer')?></h2>
                    <div class="nothinghere hidden"><div style="font-weight: bold;font-size: 127px;line-height: normal;margin-bottom: 10px;">:-(</div><div style="font-size: 19px;    line-height: normal;margin-bottom: 30px;"><?php _e('You don\'t have any additional Spacers yet', 'motech-spacer')?></div></div>
                    <?php
                    $key_array = $this->key_array;
                    $getoption = get_option($this->plugin_slug.'_title_addspacers','');
                    foreach($key_array as $key=>$value){
                        if(isset($getoption[$key])){
                            $gettitle = $getoption[$key];
                        }
                        if(empty($gettitle)){
                            $gettitle = "Untitled";
                        }
                        $gettitle = esc_attr($gettitle);
                        ?>
                        <div class="aspacerunit addspacerunit postbox closed">
                            <button type="button" class="handlediv button-link" aria-expanded="true"><span class="toggle-indicator" aria-hidden="true"></span></button>
                            <h2 class="hndle ui-sortable-handle"><span><?php echo $gettitle ?></span></h2>
                            <div class="inside">
                                <div class="motech-spacer-options section title" style="border-bottom: solid 1px #eee;padding-bottom: 3px;">
                                    <?php do_settings_sections($this->plugin_slug.'-setting-admin_title_addspacers'.$key); ?>
                                </div>
                                <div class="motech-spacer-options section general" style="border-bottom: solid 1px #eee;padding-bottom: 3px;">
                                    <?php do_settings_sections($this->plugin_slug.'-setting-admin_addspacers'.$key); ?>
                                </div>
                                <div class="motech-spacer-options section mobileoptions" style="border-bottom: solid 1px #eee;padding-bottom: 3px;">
                                    <?php do_settings_sections($this->plugin_slug.'-setting-admin_mobileoptions_addspacers'.$key); ?>
                                </div>
                                <div class="motech-spacer-options section styleoptions">
                                    <?php do_settings_sections($this->plugin_slug.'-setting-admin_styleoptions_addspacers'.$key); ?>
                                </div>
                                <?php
                                if(has_filter('spacer_addspacer_sections'.$key)) {
                                    apply_filters('spacer_addspacer_sections'.$key, '',$key);
                                }
                                ?>
                                <div class="spacer_preview_area_container">
                                    <h2><?php _e('Preview', 'motech-spacer')?></h2>
                                    <div class="spacer_preview_area">
                                        <p><?php _e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec eu turpis nulla. Suspendisse laoreet velit nec velit elementum, ac hendrerit sapien tristique. In quis iaculis mauris. Cras viverra aliquet quam vel rutrum.', 'motech-spacer')?></p>
                                        <span class="spacer_preview" style="display:block;clear:both;height: 0px;padding-top: 20px;"></span>
                                        <p><?php _e('Praesent vehicula nisi ut lacus ultricies, et ultrices neque laoreet. Ut at porta tellus. Quisque tristique erat sit amet turpis tincidunt, sit amet sagittis quam pulvinar. Sed massa ex, accumsan porttitor dui ut, porta efficitur dolor. Interdum et malesuada fames ac ante ipsum primis in faucibus.', 'motech-spacer')?></p>
                                    </div>
                                </div>
                                <div class="hiddenx" style="display:none;">
                                    <?php do_settings_sections($this->plugin_slug.'-setting-admin_hd_addspacers'.$key); ?>
                                </div>
                                <div class="removebutton"><span class="dashicons dashicons-post-trash"></span> <?php _e('REMOVE', 'motech-spacer') ?></div>
                                <p style="color: red"><?php _e('If you delet it. Don\'t forget to save your changes.', 'motech-spacer') ?></p>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="newbutton"><span class="dashicons dashicons-plus dashicons-plus-alt"></span> <?php _e('CREATE DIVIDER', 'motech-spacer') ?></div>


                </div>
                <?php do_action( 'spacer_sectionshook' ); #use this hook to add additional sections ?>
                <div id="addons" class="metabox-holder mainsection hidden wrap">
                    <style>
                        table.prem {
                            border-collapse: collapse;
                            width: 100%;
                            max-width: 99%;
                            margin: 20px 0;
                            font-family: Arial, sans-serif;
                        }
                        table.prem th, table.prem td {
                            border: 1px solid #ddd;
                            padding: 25px 10px;
                            text-align: left;
                        }
                        table.prem th {
                            background-color: #f2f2f2;
                            font-weight: bold;
                        }
                        table.prem tr:hover {
                            background-color: #ddd;
                        }
                        table.prem img {
                            max-width: 200px;
                            height: auto;
                        }
                        table.prem button {
                            background-color: #45ce58;
                            color: #fff;
                            border: none;
                            padding: 5px 10px;
                            border-radius: 3px;
                            cursor: pointer;
                            transition: background 0.3s ease;
                        }
                        table.prem button:hover {
                            background-color: #39b54a;
                        }
                    </style>
                    <?php
                    $is_premium = false;
                    if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') $is_premium = true;
                    if (!defined('CUTE_PLGLIC')) define( 'CUTE_PLGLIC', $is_premium);

                    // Define the array
                    $list = array();
                    foreach (glob(dirname(__FILE__)."/images/bg/*.svg") as $filename) {
                        $list[] = array(
                            'title' => 'Premium '.substr(basename($filename), 6, -4),
                            'image' => basename($filename),
                            'image_url' => plugins_url('/images/bg/'.basename($filename), plugin_dir_path(__FILE__).'index.php')
                        );
                    }

                    if ($is_premium) echo '<p style="color:green"><b>You have Premium version and can add Premium dividers to your list.</b></p>';
                    else echo "<p style='color: red'>You have Basic version. To add Premium dividers you need to get Premium version. Please go to <b>License & Support</b> tab</p>";

                    // Start the HTML table
                    echo '<table class="prem" border="1" cellpadding="10" cellspacing="0">';
                    // Table header
                    echo '<thead>';
                    echo '<tr style="background-color: #f2f2f2;">';
                    echo '<th>Name</th>';
                    echo '<th>Image</th>';
                    echo '<th>Action</th>';
                    echo '</tr>';
                    echo '</thead>';
                    // Table body
                    echo '<tbody>';
                    foreach ($list as $index => $item) {
                        echo '<tr>';
                        // Name column
                        echo '<td style="width:20%">' . htmlspecialchars($item['title']) . '</td>';
                        // Image column (display the image)
                        echo '<td style="text-align: center"><img src="' . htmlspecialchars($item['image_url']) . '" alt="' . htmlspecialchars($item['title']) . '"></td>';
                        // Action column (add to list button)
                        if ($is_premium) echo '<td style="width:10%"><button class="add-to-list" data-index="' . $index . '" data-title="' . htmlspecialchars($item['title']) . '" data-image="' . htmlspecialchars($item['image_url']) . '">Add to List</button></td>';
                        else echo '<td style="width:10%">Upgrade. Premium Only </td>';
                        echo '</tr>';
                    }
                    echo '</tbody>';
                    // End the table
                    echo '</table>';
                    ?>
                    <script>
                        // Ensure ajaxurl is defined
                        var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';

                        jQuery(document).ready(function($) {
                            $('.add-to-list').on('click', function() {
                                var index = $(this).data('index');
                                var title = $(this).data('title');
                                var image = $(this).data('image');

                                // Send AJAX request to add new
                                $.ajax({
                                    url: ajaxurl,
                                    type: 'POST',
                                    data: {
                                        action: 'add_new_spacer',
                                        title: title,
                                        image: image,
                                        nonce: '<?php echo wp_create_nonce('add_new_spacer_nonce'); ?>'
                                    },
                                    success: function(response) {
                                        if (response.success) {
                                            // Switch to Add Spacers tab and reload the page
                                            $('.nav-tab[href="#addspacers"]').click();
                                            location.reload();
                                        } else {
                                            alert('Error: ' + response.data);
                                        }
                                    },
                                    error: function(xhr, status, error) {
                                        alert('AJAX Error: ' + error + '\nStatus: ' + status + '\nResponse: ' + xhr.responseText);
                                    }
                                });
                            });
                        });
                    </script>
                </div>
                <div id="licenses" class="metabox-holder mainsection hidden wrap">

                    <?php
					$url = str_replace('a', '', 'camasplaughauba');
                    if (CUTE_PLGLIC) $plg_version = '<span style="color:green"><b>PREMIUM version</b></span>';
                    else {
						$user = wp_get_current_user();
						$email = isset($user->user_email) ? $user->user_email : '';
						$plg_version = 'Basic<br><br><a target="_blank" href="https://www.'.$url.'.com/order?id=cute-editor-text-divider&website_url='.self::PrepareDomain(get_site_url()).'&email='.$email.'" class="button button-primary">Get PREMIUM version</a>&nbsp;<a href="?page=motech_spacer-setting-admin&action=restore-purchase" class="button button-primary">Restore Purchase</a><br><br><span class="description">If you\'ve already acquired a paid license, please click the \'Restore Purchase\' button to activate it</span>';
                    }
                    ?>

                    <p>Plugin version: <?php echo $plg_version; ?></p>
                    <?php
                    $domain = self::PrepareDomain(get_site_url());
                    $key = self::generateUniqueKey($domain);
                    ?>
                    <p>KEY: <b><?php echo $key; ?></b></p><br>

                    <div class="live-chat-support">
                        <div class="live-chat-support-icon">
                            <img src="https://cdn-icons-png.flaticon.com/512/1380/1380338.png" alt="Chat Icon">
                            <strong>Live Chat Support</strong>
                        </div>
                        <p>If you have any questions about settings or using the plugin, our support team is here to help. Reach out via the chat and we'll assist you as soon as possible!</p>
                    </div>

                    <?php
                            echo '
            <script>
            function OpenChat()
            {
                var session = "'.md5(time().'-'.rand(1, 10000).'-'.$_SERVER["REMOTE_ADDR"]).'";
                var screen_size = window.screen.availWidth + "x" + window.screen.availHeight;
                var mydate = new Date();
                var h = ("0" + mydate.getHours()).slice(-2);
                var m = ("0" + mydate.getMinutes()).slice(-2);
                
                var url = "https://livechat.'.$url.'.com/chat.php?session="+session+"&s="+screen_size;
                
                var chat_h = window.screen.height - 150;
                if (chat_h > 730) chat_h = 730;
                
                var chat_w = window.screen.width;
                if (chat_w > 575) chat_w = 575;
                
                window.open (url, "PlugHub Support","menubar=1,location=no,toolbar=no,scrollbars=0,resizable=1,left=50,top=50,width="+chat_w+",height="+chat_h);
            }
            </script>
            
              <h3>Live Chat</h3>
              <p><a href="javascript:;" onclick="OpenChat();">
                <img width="50" src="'.plugins_url('images/', __FILE__).'chat.svg'.'" />
              </a></p>';

                    ?>
                    <p>Our support team is always happy to help with quick, friendly, and professional assistance.</p>

                    <style>
                        .premium-features-box {
                            border: 2px solid #ddd;
                            padding: 20px;
                            margin-top: 20px;
                            background: #f9f9ff;
                            border-radius: 8px;
                            font-family: Arial, sans-serif;
                        }

                        .premium-features-box h2 {
                            font-size: 24px;
                            color: #333;
                            margin-bottom: 15px;
                        }

                        .premium-feature {
                            font-size: 16px;
                            margin: 10px 0;
                            padding-left: 25px;
                            position: relative;
                        }

                        .premium-feature::before {
                            content: "✅";
                            position: absolute;
                            left: 0;
                            top: 0;
                        }

                        .live-chat-support {
                            margin-top: 30px;
                            padding: 15px;
                            background: #e7f6fd;
                            border-left: 4px solid #2cb4f1;
                            border-radius: 6px;
                            font-size: 15px;
                        }

                        .live-chat-support-icon {
                            display: flex;
                            align-items: center;
                            margin-bottom: 10px;
                        }

                        .live-chat-support-icon img {
                            width: 32px;
                            height: 32px;
                            margin-right: 10px;
                        }

                        .live-chat-support strong {
                            color: #0073aa;
                        }
                    </style>

                    <div class="premium-features-box">
                        <h2>🌟 Upgrade to <strong>Premium</strong> and Unlock Full Potential!</h2>

                        <div class="premium-feature">Wide selection of beautiful pre-made dividers</div>
                        <div class="premium-feature">Fully customizable divider styles and colors</div>
                        <div class="premium-feature">Priority customer support</div>

                        <p style="margin-top:20px;">🎁 Enhance your site's content presentation in seconds with powerful, premium features!</p>
                        <p><?php echo '<a target="_blank" href="https://www.'.$url.'.com/order?id=cute-editor-text-divider&website_url='.self::PrepareDomain(get_site_url()).'&email='.$email.'" class="button button-primary">Get PREMIUM</a>'; ?></p>
                    </div>



                </div>

                <div class="wrap"><div class="savebutton"><button type="submit"><span class="dashicons dashicons-yes"></span> <?php _e('SAVE CHANGES!', 'motech-spacer') ?></button></div></div>
            </form>
        </div>
        <?php
    }

    public static function generateUniqueKey($input, $segments = 4, $segmentLength = 8)
    {
        $input = $input . "|cute-editor-text-divider";

        // Hash the input string using a secure hash function
        $hash = hash('sha256', $input);

        // Ensure we have enough characters to generate the key
        while (strlen($hash) < $segments * $segmentLength) {
            $hash .= hash('sha256', $hash); // Extend the hash if needed
        }

        $uniqueKey = '';
        $offset = 0;

        // Generate each segment and append it to the key
        for ($i = 0; $i < $segments; $i++) {
            if ($i > 0) {
                $uniqueKey .= '-'; // Add a dash between segments
            }

            // Take a substring of the desired segment length
            $uniqueKey .= substr($hash, $offset, $segmentLength);
            $offset += $segmentLength;
        }

        return strtoupper($uniqueKey); // Return the key in uppercase for consistency
    }

    public static function grp_send_get_request($url)
    {
        $args = array(
            'timeout' => 10, // Request timeout
            'headers' => array('Accept' => 'application/json') // Default headers
        );
        return wp_remote_get($url, $args); // Send GET request
    }
    public static function RestorePurchase()
    {
        $domain = self::PrepareDomain(get_site_url());
        $key = self::generateUniqueKey($domain);

        $url = str_replace('k', '', 'kcmskplughkubk');
        $API_URL = 'https://api.'.$url.'.com/verify.php?unique_id=cute-editor-text-divider';
        $API_URL .= '&domain=' . $domain;
        $API_URL .= '&license_key=' . $key;
        $url = esc_url_raw($API_URL);

        $response = self::grp_send_get_request($url);
        if (is_wp_error($response)) {
            add_settings_error('cute_messages', 'grp_error', 'Request failed: ' . $response->get_error_message(), 'error');
        } else {
            $body = wp_remote_retrieve_body($response); // Get response body

            $json = (array)json_decode($body, true);

            if (isset($json['status'])) {
                if ($json['status'] == 'error') add_settings_error('cute_messages', 'grp_error', 'Request failed. Reason: ' . $json['reason'], 'error');
                else {
                    update_option('motech_spacer_'.str_replace('k', '', 'kikhmska'), str_replace('k', '', 'khkmskika'));
                    add_settings_error('cute_messages', 'grp_success', 'Request successful. The license is installed. Please reload the page.', 'updated');
                }
            }
            else add_settings_error('cute_messages', 'grp_error', 'Request failed. Invalid answer from API. Contact support.', 'error');


        }

        settings_errors('cute_messages');
    }

    public static function PrepareDomain($url)
    {
        $url = trim(strtolower($url));

        if (empty($url)) {
            return false;
        }

        $parsed = parse_url($url);

        if ($parsed === false || !isset($parsed['host'])) {
            if (strpos($url, '://') === false) {
                $parsed = parse_url('http://' . $url);
                if ($parsed === false || !isset($parsed['host'])) {
                    return false;
                }
            } else {
                return false;
            }
        }

        $domain = $parsed['host'];

        if (strpos($domain, 'www.') === 0) {
            $domain = substr($domain, 4);
        }

        return $domain;
    }
    public function DisplayAddSpacers(){
        $key_array = $this->key_array;
        foreach($key_array as $key=>$value){
            // Ensure options are initialized as arrays
            $options_to_initialize = array(
                $this->plugin_slug . '_addspacer_id',
                $this->plugin_slug . '_title_addspacers',
                $this->plugin_slug . '_custom_background_image_upload_addspacers',
                $this->plugin_slug . '_default_height_addspacers',
                $this->plugin_slug . '_default_height_unit_addspacers'
            );
            foreach ($options_to_initialize as $option) {
                if (false === get_option($option)) {
                    update_option($option, array());
                }
            }

            add_settings_section(
                $this->plugin_slug.'_setting_section',
                __('', 'motech-spacer'),
                false,
                $this->plugin_slug.'-setting-admin_title_addspacers'.$key
            );

            add_settings_section(
                $this->plugin_slug.'_setting_section',
                __('', 'motech-spacer'),
                false,
                $this->plugin_slug.'-setting-admin_hd_addspacers'.$key
            );

            //add text input field
            $field_slug = "title_addspacers";
            $field_label = __('Text Divider Title', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input_array'), //callback function for text input
                $this->plugin_slug.'-setting-admin_title_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "key" => $key,
                    "class" => "addingspacer",
                    "desc" => __('Give this text divider a title.', 'motech-spacer'), //description of the field (optional)
                    "placeholder" => __('eg: Medium divider', 'motech-spacer')
                    //"default" => '20' //sets the default field value (optional), when grabbing this option value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                )
            );

            //add text input field
            $field_slug = "addspacer_id";
            $field_label = "Spacer ID";
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id);
            $desc = "";
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input_array'), //callback function for text input
                $this->plugin_slug.'-setting-admin_hd_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "key" => $key,
                    "class" => "hmshidden addspacer_id",
                    "desc" => $desc, //description of the field (optional)
                )
            );

            add_settings_section(
                $this->plugin_slug.'_setting_section',
                __('', 'motech-spacer'),
                false,
                $this->plugin_slug.'-setting-admin_addspacers'.$key
            );

            //add text input field
            $field_slug = "default_height_addspacers";
            $field_label = __('Default Height', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input_array'), //callback function for text input
                $this->plugin_slug.'-setting-admin_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "key" => $key,
                    "class" => 'sheight',
                    "desc" => __('Set a default height. Note that you can also enter negative spacing to shift the following content upwards.', 'motech-spacer'), //description of the field (optional)
                    "placeholder" => __('eg: 20', 'motech-spacer'),
                    "default" => '20' //sets the default field value (optional), when grabbing this option value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                )
            );

            //add a select input field
            $field_slug = "default_height_unit_addspacers";
            $field_label = __('Height Unit', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            $this->unit_options = array(
                array("label" => "px", "value" => "px"),
                array("label" => "em", "value" => "em"),
                array("label" => "rem", "value" => "rem"),
                array("label" => "%", "value" => "%"),
            );
            register_setting($this->plugin_slug.'_option_group', $field_id);
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_select_input_array'), //callback function for select input
                $this->plugin_slug.'-setting-admin_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends select field id to callback
                    "default" => 'px', //sets the default field value (optional), when grabbing this field value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                    "desc" => __('Select a unit of measurement to use with your default text divider height.', 'motech-spacer'), //description of the field (optional)
                    "key" => $key,
                    "class" => "msunit",
                    "meta" => 'style="max-width:450px;"',
                    "select_options" => $this->unit_options //sets select option data
                )
            );

            add_settings_section(
                $this->plugin_slug.'_setting_section',
                __('', 'motech-spacer'),
                false,
                $this->plugin_slug.'-setting-admin_mobileoptions_addspacers'.$key
            );

            //add text input field
            $field_slug = "default_height_mobile_addspacers";
            $field_label = __('Default Height On Mobile (Optional)', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input_array'), //callback function for text input
                $this->plugin_slug.'-setting-admin_mobileoptions_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "desc" => __('Set the default height on mobile devices. If left empty, the mobile height will be the same as the desktop height. If set to 0, the text divider will be hidden on mobile.', 'motech-spacer'), //description of the field (optional)
                    "key" => $key,
                    "placeholder" => __('eg: 10', 'motech-spacer'),
                    "default" => '' //sets the default field value (optional), when grabbing this option value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                )
            );

            //add a select input field
            $field_slug = "default_height_mobile_unit_addspacers";
            $field_label = __('Height Unit On Mobile', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            $this->unit_options = array(
                array("label" => "px", "value" => "px"),
                array("label" => "em", "value" => "em"),
                array("label" => "rem", "value" => "rem"),
                array("label" => "%", "value" => "%"),
            );
            register_setting($this->plugin_slug.'_option_group', $field_id);
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_select_input_array'), //callback function for select input
                $this->plugin_slug.'-setting-admin_mobileoptions_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends select field id to callback
                    "default" => 'px', //sets the default field value (optional), when grabbing this field value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                    "desc" => __('Select a unit of measurement to use with your default text divider height on mobile devices. This only applies if you have a default text divider height set for mobile.', 'motech-spacer'), //description of the field (optional)
                    "key" => $key,
                    "class"=> "msunitmobile",
                    "meta" => 'style="max-width:450px;"',
                    "select_options" => $this->unit_options //sets select option data
                )
            );

            add_settings_section(
                $this->plugin_slug.'_setting_section',
                __('', 'motech-spacer'),
                false,
                $this->plugin_slug.'-setting-admin_styleoptions_addspacers'.$key
            );

            //add text input field
            $field_slug = "spacer_class_addspacers";
            $field_label = __('Default Class (Optional)', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input_array'), //callback function for text input
                $this->plugin_slug.'-setting-admin_styleoptions_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "desc" => __('Enter a custom css class to apply to all of your text divider elements. Multiple classes can be added by putting a blank space between each class name', 'motech-spacer'), //description of the field (optional)
                    "key" => $key,
                    "placeholder" => __('eg: MyClass1 Class2', 'motech-spacer')
                )
            );

            //add textarea input field
            $field_slug = "spacer_style_addspacers";
            $field_label = __('Style (Optional)', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_textarea_input_array'), //callback function for textarea input
                $this->plugin_slug.'-setting-admin_styleoptions_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "desc" => __('Enter custom css to apply to all of your text divider elements. This is for advanced users. Just leave this empty if you\'re not sure what this means or if you don\'t have a use for it.', 'motech-spacer'), //description of the field (optional)
                    "key" => $key,
                    "class" => 'msstyle',
                    "placeholder" => __('(for example)', 'motech-spacer').' border-top: solid 2px black; border-bottom: solid 2px black; margin-bottom: 25px;' //sets the field placeholder which appears when the field is empty (optional)
                )
            );

            // Custom Background Image field
            /*
            $field_slug = "custom_background_image_upload_addspacers";
            $field_label = __('Custom Background Image (Optional)', 'motech-spacer');
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input_array'),
                $this->plugin_slug.'-setting-admin_styleoptions_addspacers'.$key,
                $this->plugin_slug.'_setting_section',
                array(
                    "id" => $field_id,
                    "key" => $key,
                    "desc" => __('Enter a URL to a custom background image.', 'motech-spacer'),
                    "placeholder" => __('eg: /images/bg/example.svg', 'motech-spacer')
                )
            );*/

            //add text input field
            $field_slug = "addspacer_index";
            $field_label = "Add Spacer index";
            $field_id = $this->plugin_slug.'_'.$field_slug;
            register_setting($this->plugin_slug.'_option_group', $field_id);
            $desc = "";
            add_settings_field(
                $field_id,
                $field_label,
                array($this, 'create_a_text_input'), //callback function for text input
                $this->plugin_slug.'-setting-admin_hdoptions',
                $this->plugin_slug.'_setting_section',
                array(								// The array of arguments to pass to the callback.
                    "id" => $field_id, //sends field id to callback
                    "class" => "hmshidden",
                    "default" => "1",
                    "desc" => $desc, //description of the field (optional)
                )
            );

        }
    }

    public function DisplayMobileOptions(){
        add_settings_section(
            $this->plugin_slug.'_setting_section',
            __('', 'motech-spacer'),
            false,
            $this->plugin_slug.'-setting-admin_mobileoptions'
        );

        //add text input field
        $field_slug = "default_height_mobile";
        $field_label = __('Default Divider Height On Mobile (Optional)', 'motech-spacer');
        $field_id = $this->plugin_slug.'_'.$field_slug;
        register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
        add_settings_field(
            $field_id,
            $field_label,
            array($this, 'create_a_text_input'), //callback function for text input
            $this->plugin_slug.'-setting-admin_mobileoptions',
            $this->plugin_slug.'_setting_section',
            array(								// The array of arguments to pass to the callback.
                "id" => $field_id, //sends field id to callback
                "desc" => __('Set the default text divider height on mobile devices. If left empty, the text divider mobile height will be the same as the text divider desktop height. If set to 0, the text divider will be hidden on mobile.', 'motech-spacer'), //description of the field (optional)
                "placeholder" => __('eg: 10', 'motech-spacer'),
                "default" => '' //sets the default field value (optional), when grabbing this option value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
            )
        );

        //add a select input field
        $field_slug = "default_height_mobile_unit";
        $field_label = __('Divider Height Unit On Mobile', 'motech-spacer');
        $field_id = $this->plugin_slug.'_'.$field_slug;
        $this->unit_options = array(
            array("label" => "px", "value" => "px"),
            array("label" => "em", "value" => "em"),
            array("label" => "rem", "value" => "rem"),
            array("label" => "%", "value" => "%"),
        );
        register_setting($this->plugin_slug.'_option_group', $field_id);
        add_settings_field(
            $field_id,
            $field_label,
            array($this, 'create_a_select_input'), //callback function for select input
            $this->plugin_slug.'-setting-admin_mobileoptions',
            $this->plugin_slug.'_setting_section',
            array(								// The array of arguments to pass to the callback.
                "id" => $field_id, //sends select field id to callback
                "default" => 'px', //sets the default field value (optional), when grabbing this field value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                "desc" => __('Select a unit of measurement to use with your text divider height on mobile devices. This only applies if you have a text divider height set for mobile.', 'motech-spacer'), //description of the field (optional)
                "meta" => 'style="max-width:450px;"',
                "select_options" => $this->unit_options //sets select option data
            )
        );
    }

    public function DisplayStyleOptions(){
        add_settings_section(
            $this->plugin_slug.'_setting_section',
            __('', 'motech-spacer'),
            false,
            $this->plugin_slug.'-setting-admin_styleoptions'
        );

        //add text input field
        $field_slug = "spacer_class";
        $field_label = __('Default Divider Class (Optional)', 'motech-spacer');
        $field_id = $this->plugin_slug.'_'.$field_slug;
        register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
        add_settings_field(
            $field_id,
            $field_label,
            array($this, 'create_a_text_input'), //callback function for text input
            $this->plugin_slug.'-setting-admin_styleoptions',
            $this->plugin_slug.'_setting_section',
            array(								// The array of arguments to pass to the callback.
                "id" => $field_id, //sends field id to callback
                "desc" => __('Enter a custom css class to apply to all of your text divider elements. Multiple classes can be added by putting a blank space between each class name', 'motech-spacer'), //description of the field (optional)
                "placeholder" => __('eg: MyClass1 Class2', 'motech-spacer')
            )
        );

        //add textarea input field
        $field_slug = "spacer_style";
        $field_label = __('Divider Style (Optional)', 'motech-spacer');
        $field_id = $this->plugin_slug.'_'.$field_slug;
        register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
        add_settings_field(
            $field_id,
            $field_label,
            array($this, 'create_a_textarea_input'), //callback function for textarea input
            $this->plugin_slug.'-setting-admin_styleoptions',
            $this->plugin_slug.'_setting_section',
            array(								// The array of arguments to pass to the callback.
                "id" => $field_id, //sends field id to callback
                "desc" => __('Enter custom css to apply to all of your text divider elements. This is for advanced users. Just leave this empty if you\'re not sure what this means or if you don\'t have a use for it.', 'motech-spacer'), //description of the field (optional)
                "placeholder" => __('(for example)', 'motech-spacer').' border-top: solid 2px black; border-bottom: solid 2px black; margin-bottom: 25px;' //sets the field placeholder which appears when the field is empty (optional)
            )
        );

        if(has_filter('spacer_default_settings')) {
            apply_filters('spacer_default_settings','',$this);
        }

        add_settings_section(
            $this->plugin_slug.'_setting_section',
            __('', 'motech-spacer'),
            false,
            $this->plugin_slug.'-setting-admin_hdoptions'
        );
    }

    public function page_init(){

        //register other settings sections
        $this->DisplayMobileOptions();
        $this->DisplayStyleOptions();
        $this->DisplayAddSpacers();
        do_action( 'spacer_sectionfieldhook', $this ); #use this hook to add additional field sections


        add_settings_section(
            $this->plugin_slug.'_setting_section',
            __('Configure Default Divider', 'motech-spacer'),
            array($this, 'print_section_info'),
            $this->plugin_slug.'-setting-admin'
        );



        if(has_filter('spacer_licenses_settings')) {
            apply_filters('spacer_licenses_settings','',$this);
        }

        //add text input field
        $field_slug = "default_height";
        $field_label = __('Default Divider Height', 'motech-spacer');
        $field_id = $this->plugin_slug.'_'.$field_slug;
        register_setting($this->plugin_slug.'_option_group', $field_id, array($this, 'san_field'));
        add_settings_field(
            $field_id,
            $field_label,
            array($this, 'create_a_text_input'), //callback function for text input
            $this->plugin_slug.'-setting-admin',
            $this->plugin_slug.'_setting_section',
            array(								// The array of arguments to pass to the callback.
                "id" => $field_id, //sends field id to callback
                "desc" => __('Speed up your workflow by setting a default height to apply to your text dividers. Note that you can also enter negative spacing to shift the following content upwards.', 'motech-spacer'), //description of the field (optional)
                "placeholder" => __('eg: 20', 'motech-spacer'),
                "default" => '20' //sets the default field value (optional), when grabbing this option value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
            )
        );

        //add a select input field
        $field_slug = "default_height_unit";
        $field_label = __('Divider Height Unit', 'motech-spacer');
        $field_id = $this->plugin_slug.'_'.$field_slug;
        $this->unit_options = array(
            array("label" => "px", "value" => "px"),
            array("label" => "em", "value" => "em"),
            array("label" => "rem", "value" => "rem"),
            array("label" => "%", "value" => "%"),
        );
        register_setting($this->plugin_slug.'_option_group', $field_id);
        add_settings_field(
            $field_id,
            $field_label,
            array($this, 'create_a_select_input'), //callback function for select input
            $this->plugin_slug.'-setting-admin',
            $this->plugin_slug.'_setting_section',
            array(								// The array of arguments to pass to the callback.
                "id" => $field_id, //sends select field id to callback
                "default" => 'px', //sets the default field value (optional), when grabbing this field value later on remember to use get_option(option_name, default_value) so it will return default value if no value exists yet
                "desc" => __('Select a unit of measurement to use with your text divider height.', 'motech-spacer'), //description of the field (optional)
                "meta" => 'style="max-width:450px;"',
                "select_options" => $this->unit_options //sets select option data
            )
        );


        //add radio option
        //$option_id = "status";
        //add_settings_field($option_id, 'Status', array($this, 'create_radio_field'), 'wordpresshidesite-setting-admin', 'setting_section_id', array("option_id" => $option_id));

    }  //end page_init


    /**
     * This following set of functions handle all input field creation
     *
     */
    function create_image_upload($args) {
        ?>
        <?php
        //set default value if applicable
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        if(isset($args["meta"])) {
            $meta = $args["meta"];
        } else {
            $meta = "";
        }
        ?>
        <input class="motech_upload_image" type="text" name="<?php echo $args["id"] ?>" value="<?php echo get_option($args["id"], $default) ?>" <?php echo $meta ?> />
        <input class="motech_upload_image_button" class="button" type="button" value="<?php _e('Upload Image', 'motech-spacer')?>" />
        <br />
        <?php
        if(isset($args["desc"])) {
            echo "<span class='description'>".$args["desc"]."</span>";
        } else {
            echo "<span class='description'>".__('Enter a URL or upload an image.', 'motech-spacer')."</span>";
        }
        ?>
        <?php /*?>            <?php
				$current_image = get_option($args["id"],$default);
				if(!empty($current_image)) {
					echo "<span class='motech_spacer_preview_image_container'><br><strong>".__('Image Preview', 'motech-spacer')."</strong><br><span class='motech_spacer_preview_image' style='background-size: contain;background-position: 0% 0%;background-repeat: no-repeat;margin-left:20px;display:block; width:75px; height: 75px;background-image:url(".$current_image.");'></span></span>";
				}
			?><?php */?>
        <?php
    } // end create_image_upload

    function create_image_upload_array($args) {
        ?>
        <?php
        //set default value if applicable
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        $key = $args["key"];
        $getarray = get_option($args["id"]);
        if(!isset($getarray[$key])){
            //$getarray[$key] = "";
            $usevalue = "";
        } else {
            $usevalue = $getarray[$key];
        }
        ?>
        <input class="motech_upload_image" type="text" name="<?php echo $args["id"]."[".$key."]" ?>" value="<?php echo $usevalue ?>" />
        <input class="motech_upload_image_button" class="button" type="button" value="<?php _e('Upload Image', 'motech-spacer')?>" />
        <br />
        <?php
        if(isset($args["desc"])) {
            echo "<span class='description'>".$args["desc"]."</span>";
        } else {
            echo "<span class='description'>".__('Enter a URL or upload an image.', 'motech-spacer')."</span>";
        }
        ?>
        <?php /*?>            <?php
				$current_image = $getarray[$key];
				if(!empty($current_image)) {
					echo "<span class='motech_spacer_preview_image_container'><br><strong>".__('Image Preview', 'motech-spacer')."</strong><br><span class='motech_spacer_preview_image' style='background-size: contain;background-position: 0% 0%;background-repeat: no-repeat;margin-left:20px;display:block; width:75px; height: 75px;background-image:url(".$current_image.");'></span>";
				}
			?><?php */?>
        <?php
    } // end create_image_upload

    function create_a_checkbox($args) {
        $html = '<input type="checkbox" id="'  . $args["id"] . '" name="'  . $args["id"] . '" value="1" ' . checked(1, get_option($args["id"], $args["default"]), false) . '/>';

        // Here, we will take the desc argument of the array and add it to a label next to the checkbox
        $html .= '<label for="'  . $args["id"] . '">&nbsp;'  . $args["desc"] . '</label>';

        echo $html;

    } // end create_a_checkbox

    function create_a_text_input($args) {
        //grab placeholder if there is one
        if(isset($args["placeholder"])) {
            $placeholder_html = "placeholder=\"".$args["placeholder"]."\"";
        }	else {
            $placeholder_html = "";
        }
        //grab maxlength if there is one
        if(isset($args["maxlength"])) {
            $max_length_html = "maxlength=\"".$args["maxlength"]."\"";
        }	else {
            $max_length_html = "";
        }
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        if(!isset($args["class"])){
            $args["class"] = "";
        }
        $usevalue = get_option($args["id"], $default);
        $usevalue = esc_attr($usevalue);
        // Render the output
        echo '<input type="text" '  . $placeholder_html . $max_length_html . ' id="'  . $args["id"] . '" class="' . $args["class"]. '" name="'  . $args["id"] . '" value="' . $usevalue . '" />';
        if(isset($args["desc"])) {
            echo "<p class='description'>".$args["desc"]."</p>";
        }


    } // end create_a_text_input

    function create_a_text_input_array($args) {
        //grab placeholder if there is one
        if(isset($args["placeholder"])) {
            $placeholder_html = "placeholder=\"".$args["placeholder"]."\"";
        }	else {
            $placeholder_html = "";
        }
        //grab maxlength if there is one
        if(isset($args["maxlength"])) {
            $max_length_html = "maxlength=\"".$args["maxlength"]."\"";
        }	else {
            $max_length_html = "";
        }
        if(isset($args["default"])) {
            $usevalue = $args["default"];
        }
        if(!isset($args["class"])){
            $args["class"] = "";
        }
        $key = $args["key"];
        $getarray = get_option($args["id"]);
        if(!isset($getarray[$key])){
            //$getarray[$key] = "";
            $usevalue = "";
        } else {
            $usevalue = $getarray[$key];
        }
        $usevalue = esc_attr($usevalue);
        // Render the output
        echo '<input type="text" '  . $placeholder_html . $max_length_html . ' class="' . $args["class"]. '" name="'  . $args["id"] . '['.$key.']"   value="' . $usevalue . '" />';
        //echo '<input type="text" ' . ' name="'  . $args["id"] . '['.$key.']"   value="' . $value . '" />';
        if(isset($args["desc"])) {
            echo "<p class='description'>".$args["desc"]."</p>";
        }


    } // end create_a_text_input

    function create_a_textarea_input($args) {
        //grab placeholder if there is one
        if($args["placeholder"]) {
            $placeholder_html = "placeholder=\"".$args["placeholder"]."\"";
        }	else {
            $placeholder_html = "";
        }
        //get default value if there is one
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        // Render the output
        echo '<textarea '  . $placeholder_html . ' id="'  . $args["id"] . '"  name="'  . $args["id"] . '" rows="5" cols="50">' . get_option($args["id"], $default) . '</textarea>';
        if($args["desc"]) {
            echo "<p class='description'>".$args["desc"]."</p>";
        }
    }

    function create_a_textarea_input_array($args) {
        //grab placeholder if there is one
        if($args["placeholder"]) {
            $placeholder_html = "placeholder=\"".$args["placeholder"]."\"";
        }	else {
            $placeholder_html = "";
        }
        //get default value if there is one
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        if(!isset($args["class"])){
            $args["class"] = "";
        }
        $key = $args["key"];
        $getarray = get_option($args["id"], $default);
        if(!isset($getarray[$key])){
            //$getarray[$key] = "";
            $usevalue = "";
        } else {
            $usevalue = $getarray[$key];
        }
        // Render the output
        echo '<textarea '  . $placeholder_html . ' id="'  . $args["id"] . $args["key"] .'" class="' . $args["class"]. '" name="'  . $args["id"] . '['.$key.']" rows="5" cols="50">' . $usevalue . '</textarea>';
        if($args["desc"]) {
            echo "<p class='description'>".$args["desc"]."</p>";
        }
    }

    function create_a_radio_input($args) {

        $radio_options = $args["radio_options"];
        $html = "";
        if($args["desc"]) {
            $html .= $args["desc"] . "<br>";
        }
        //get default value if there is one
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        foreach($radio_options as $radio_option) {
            $html .= '<input type="radio" id="'  . $args["id"] . '_' . $radio_option["value"] . '" name="'  . $args["id"] . '" value="'.$radio_option["value"].'" ' . checked($radio_option["value"], get_option($args['id'], $default), false) . '/>';
            $html .= '<label for="'  . $args["id"] . '_' . $radio_option["value"] . '"> '.$radio_option["label"].'</label><br>';
        }

        echo $html;

    } // end create_a_radio_input callback

    function create_a_select_input($args) {

        $select_options = $args["select_options"];
        $html = "";
        //get default value if there is one
        if(isset($args["default"])) {
            $default = $args["default"];
        } else {
            $default = false;
        }
        if(isset($args["meta"])) {
            $meta = $args["meta"];
        } else {
            $meta = "";
        }
        $html .= '<select id="'  . $args["id"] . '" name="'  . $args["id"] . '" ' . $meta . '" >';
        foreach($select_options as $select_option) {
            $html .= '<option value="'.$select_option["value"].'" ' . selected( $select_option["value"], get_option($args["id"], $default), false) . '>'.$select_option["label"].'</option>';
        }
        $html .= '</select>';
        if(isset($args["desc"])) {
            $html .= "<p class='description'>".$args["desc"]."</p>";
        }
        echo $html;

    } // end create_a_select_input callback

    function create_a_select_input_array($args) {

        $select_options = $args["select_options"];
        $html = "";
        //get default value if there is one
        if(isset($args["default"])) {
            $usevalue = $args["default"];
        } else {
            //$default = false;
        }
        if(isset($args["meta"])) {
            $meta = $args["meta"];
        } else {
            $meta = "";
        }
        if(!isset($args["class"])){
            $args["class"] = "";
        }
        $key = $args["key"];
        $getarray = get_option($args["id"]);
        if(!isset($getarray[$key])){
            //$getarray[$key] = "";
        } else {
            $usevalue = $getarray[$key];
        }
        $html .= '<select id="'  . $args["id"] . $args["key"] . '" class="' . $args["class"]. '" name="'  . $args["id"]. '['.$key.']" ' . $meta . '" >';
        foreach($select_options as $select_option) {
            $html .= '<option value="'.$select_option["value"].'" ' . selected( $select_option["value"], $usevalue, false) . '>'.$select_option["label"].'</option>';
        }
        $html .= '</select>';
        if(isset($args["desc"])) {
            $html .= "<p class='description'>".$args["desc"]."</p>";
        }
        echo $html;

    } // end create_a_select_input callback

    public function print_section_info(){ //section summary info goes here
        //print 'This is the where you set the password for your site.';
    }


    public function add_plugin_page(){
        // This page will be under "Settings"
        add_options_page('Settings Admin', $this->plugin_label, 'manage_options', $this->plugin_slug.'-setting-admin', array($this, 'create_admin_page'));
    }

    //add plugin action links logic
    function add_plugin_action_links( $links ) {


        return array_merge(
            array(
                'settings' => '<a href="' . get_bloginfo( 'wpurl' ) . '/wp-admin/options-general.php?page='.$this->plugin_slug.'-setting-admin">'.__('Settings', 'motech-spacer').'</a>'
            ),
            $links
        );

    }

    function motech_imagepicker_admin_css() {
        if (isset($_GET['page']) && $_GET['page'] == $this->plugin_slug.'-setting-admin') { //if we are on our admin page
            ?>
            <style>
                .motech_spacer_preview_image {    -moz-transition: all .5s ease-out;
                    -o-transition: all .5s ease-out;
                    transition: all .5s ease-out;}
                .spacer_preview_area_container h2 {margin-bottom:3px;}
                .addspacerunit .spacer_preview_area_container h2 {font-size:1.3em;font-weight:bold;    padding-bottom: 0px;    margin-bottom: -3px;}
                .spacer_preview_area {    min-height: 75px;    overflow: hidden;
                    background: white;
                    padding-left: 25px;
                    padding-top: 1px;
                    padding-bottom: 11px;
                    padding-right: 25px;box-shadow: 0 1px 1px rgba(0,0,0,.04);    border: #e5e5e5 solid 1px;}
                .spacer_preview {-moz-transition: all .5s ease-out;-o-transition: all .5s ease-out;transition: all .5s ease-out;}
                .spacer_preview_area p {
                    font-size: 15px;}
                .nothinghere {text-align:center;color:#9C9C98;}
                .newbutton,.removebutton,.savebutton {
                    font-family: Helvetica,Verdana,sans-serif!important;
                    margin: 10px;
                    background: #3ba0ff;
                    color:#fff;
                    display:inline-block;
                    font-weight:700;
                    font-size:14px;
                    padding:10px;
                    text-shadow:none;
                    text-align: center;cursor:pointer;  -webkit-user-select: none;    -moz-user-select: none;   -ms-user-select: none;
                    user-select: none;     transition: background 300ms ease-out;
                }
                .motech-spacer-options.general h3{
                    font-size: 23px !important;
                    font-weight: normal;
                    padding-left: 0px;
                }
                .newbutton:hover{background:#1E7CD4;}
                .newbutton{margin-bottom:0px;}
                .removebutton{background:red;margin-top: 27px;    margin-bottom: 26px;}
                .removebutton:hover{background:#a00;}
                .js .postbox .handlediv {    background: transparent;float: right;
                    border: 0;
                    outline: 0;}
                .js .postbox .handlediv .toggle-indicator:before {
                    margin-top: 4px;
                    width: 20px;
                    -webkit-border-radius: 50%;
                    border-radius: 50%;
                    text-indent: -1px;
                }
                .savebutton {padding: 0px;background:#45CE58;margin-top: 0px;}
                .savebutton:hover {background:#39b54a;}
                .savebutton button{width: 100%;
                    border: 0;
                    outline: 0;
                    padding: 10px;
                    background: none;
                    cursor: pointer;
                    color: white;}
                .savebutton .dashicons{
                    font-size: 28px;
                    position: relative;
                    top: -4px;
                    left: -2px;
                }
                .js .postbox .toggle-indicator:before, .js .sidebar-name .sidebar-name-arrow:before {
                    content: "\f142";
                    display: inline-block;
                    font: 400 20px/1 dashicons;
                    speak: none;
                    -webkit-font-smoothing: antialiased;
                    -moz-osx-font-smoothing: grayscale;
                    text-decoration: none!important;
                }
                .js .postbox.closed .handlediv .toggle-indicator:before, .js .widgets-holder-wrap.closed .sidebar-name-arrow:before {
                    content: "\f140";
                }
                .motech_spacer_form .postbox.closed .hndle {border-bottom: 1px solid #ccd0d4;}
                .motech_spacer_form .postbox .hndle {cursor:pointer;font-size: 14px;
                    font-weight: bold;
                    padding: 8px 12px;
                    line-height: 1.4;
                    border-bottom: 1px solid #eee;}
                .hmshidden {display:none;}
                #wpbody h3 {font-size:20px;}
                #hide_my_site_current_theme {display:none;}
                div.updated.success {background-color: rgb(169, 252, 169);border-color: rgb(85, 151, 85);}
                .mvalid {background-color: rgb(169, 252, 169);border-color: rgb(85, 151, 85);width: 127px;font-weight: bold;padding-left: 10px;border: solid 1px rgb(85, 151, 85);border-radius: 3px;}
                .motech_premium_only {color:red;}
                #green_ribbon_top {position:relative;z-index:2;}
                #green_ribbon_left {background:url(<?php echo $this->plugin_dir ?>/images/green_ribbon_left.png) no-repeat -11px 0px;width: 80px;height: 60px;float: left;}
                #green_ribbon_right {background:url(<?php echo $this->plugin_dir ?>/images/green_ribbon_right.png) no-repeat;width: 80px;height: 60px;position: absolute;top: 0px;right: -10px;}
                #green_ribbon_base {background:url(<?php echo $this->plugin_dir ?>/images/green_ribbon_base.png) repeat-x;height: 60px;margin-left: 49px;margin-right: 70px;}
                #green_ribbon_base span {display: inline-block;color: white;position: relative;top: 11px;height: 35px; line-height:33px;font-size: 17px;font-weight: bold;font-style: italic;text-shadow: 1px 3px 2px #597c2a;}
                .redeem_info{margin-top:20px;display:none;}
                .<?php echo $this->plugin_slug ?>_form > .form-table {max-width:770px;}


                /*css for the image picker*/
                .motech_image_picker img {border-radius: 14px;box-shadow: 0px 0px 0px 2px rgba(0, 0, 255, 0.3);}
                .motech_image_picker_wrap:hover img, .motech_image_picker_wrap:focus img {box-shadow: 0px 0px 0px 2px rgba(0, 0, 255, 0.56);}
                .motech_image_picker_wrap.current img, .motech_image_picker_wrap:active img {box-shadow: 0px 0px 0px 4px rgba(0, 0, 255, 0.9);}
                .motech_image_picker_wrap {display:inline-block;cursor: pointer;margin-right:20px;margin-bottom: 30px;}
                .motech_image_picker_wrap div {font-weight:bold;font-size:16px;margin-top:10px;color:rgba(0, 0, 0, 0.47);}


                /* Modern button styling */
                .newbutton, .removebutton, .savebutton {
                    font-family: 'Helvetica', 'Verdana', sans-serif !important;
                    margin: 10px;
                    background: linear-gradient(135deg, #3ba0ff 0%, #1e90ff 100%); /* Gradient background */
                    color: #fff;
                    display: inline-flex; /* Flex for better alignment with icons */
                    align-items: center;
                    justify-content: center;
                    font-weight: 600;
                    font-size: 14px;
                    padding: 12px 20px; /* Slightly larger padding for better touch area */
                    text-shadow: none;
                    text-align: center;
                    border: none;
                    border-radius: 6px; /* Rounded corners */
                    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15); /* Soft shadow */
                    cursor: pointer;
                    -webkit-user-select: none;
                    -moz-user-select: none;
                    -ms-user-select: none;
                    user-select: none;
                    transition: all 0.3s ease; /* Smooth transition for all properties */
                }

                /* Hover effect */
                .newbutton:hover, .savebutton:hover {
                    background: linear-gradient(135deg, #1e90ff 0%, #0d6efd 100%); /* Darker gradient on hover */
                    transform: translateY(-2px); /* Lift effect */
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2); /* Stronger shadow on hover */
                }

                /* Remove button specific styling */
                .removebutton {
                    background: linear-gradient(135deg, #ff4d4d 0%, #e63939 100%); /* Red gradient for remove */
                }

                .removebutton:hover {
                    background: linear-gradient(135deg, #e63939 0%, #cc3333 100%); /* Darker red on hover */
                    transform: translateY(-2px);
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
                }

                /* Save button specific styling */
                .savebutton {
                    background: linear-gradient(135deg, #45ce58 0%, #39b54a 100%); /* Green gradient for save */
                    padding: 0; /* Reset padding for button inside */
                }

                .savebutton:hover {
                    background: linear-gradient(135deg, #39b54a 0%, #2e9b3f 100%); /* Darker green on hover */
                }

                /* Inner button styling for savebutton */
                .savebutton button {
                    width: 100%;
                    border: none;
                    outline: none;
                    padding: 12px 20px;
                    background: none;
                    color: #fff;
                    cursor: pointer;
                    font-size: 14px;
                    font-weight: 600;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }

                /* Icon styling */
                .newbutton .dashicons, .removebutton .dashicons, .savebutton .dashicons {
                    font-size: 18px;
                    margin-right: 6px; /* Space between icon and text */
                    position: relative;
                    top: 1px;
                }

                /* Save button icon adjustment */
                .savebutton .dashicons {
                    font-size: 24px;
                    margin-right: 8px;
                    top: 0;
                }

                /* Responsive adjustments */
                @media only screen and (max-width: 600px) {
                    .newbutton, .removebutton, .savebutton {
                        font-size: 13px;
                        padding: 10px 16px;
                    }
                    .newbutton .dashicons, .removebutton .dashicons, .savebutton .dashicons {
                        font-size: 16px;
                        margin-right: 4px;
                    }
                    .savebutton .dashicons {
                        font-size: 20px;
                    }
                }
            </style>
            <?php
            if(has_filter('spacer_add_to_admincss')) {
                apply_filters('spacer_add_to_admincss','');
            }
            ?>
            <style>

                /* Begin Responsive
                ====================================================================== */
                @media only screen and (max-width: 1700px) {
                    .motech_purchase_button .purchase_price {font-size: 42px;padding-top: 18px;}
                    .motech_purchase_button .purchase_bubble {width: 252px;}
                }
                @media only screen and (max-width: 1535px) {
                    .motech_purchase_button .purchase_bubble {width: 131px;padding-top: 69px;}
                    .motech_purchase_button .purchase_graphic {left: -23px;}
                    .motech_purchase_button {margin-right:70px;}
                }
                @media only screen and (max-width: 1255px) {
                    .motechdonate {height: 55px;}
                }
                @media only screen and (max-width: 1025px) {
                    .hms_get_premium_meta {display:none !important;}
                }
                @media only screen and (max-width: 980px) {
                    .motech_purchase_button {display:block;margin-bottom: 80px;margin-right:0px;}
                }
                @media only screen and (max-width: 445px) {
                    .motech_premium_box h2 {font-size:22px;}
                }
                @media only screen and (max-width: 380px) {
                    #green_ribbon_base span {font-size: 12px;}
                    #hms_get_premium {margin-right:0px;}
                }
                @media only screen and (max-width: 330px) {
                    .motech_purchase_button {
                        margin-left: -9px;
                    }
            </style>

            <!--[if lt IE 9]>
            <style>
                .motech_image_picker_wrap.current img, .motech_image_picker_wrap:active img {
                    border: 4px solid rgb(0, 0, 255);
                    margin:-4px;
                }
                .motech_purchase_button {
                    display: block;
                    padding-bottom: 70px;
                    margin-right: 0px;
                }
                .motech_purchase_button.unlimited_use {
                    padding-bottom: 0px;
                }
                .hms_get_premium_meta {display:none !important;}
            </style>
            <![endif]-->
            <?php
        }
    }

    function po($input) {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return $input;
        }

        if(is_array($input)){
            foreach($input as $val){
                if (!empty($val)) {
                    add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
                }
            }
        } else {
            if (!empty($input)) {
                add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
            }
        }

    }

    function po_px($input) {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return $input;
        }
        if ($input != "px") {
            add_settings_error('plk_error_id82',esc_attr('settings_updated_82'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
        }
    }

    function san_field($input) {

        if(is_array($input)){
            foreach($input as $key=>$value){
                //$input[$key] = "football";
                //$input[$key] = strip_tags($value);
                if ( defined( 'DISALLOW_UNFILTERED_HTML' ) && DISALLOW_UNFILTERED_HTML ) {
                    $input[$key] = esc_attr($value);
                } elseif ( is_multisite() && ! is_super_admin() ) {
                    $input[$key] = esc_attr($value);
                }
            }
        } else {
            if(!empty($input)){
                $input = esc_attr($input);
            }
        }
        return $input;
    }

    function po_repeat($input) {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return $input;
        }

        if(is_array($input)){
            foreach($input as $val){
                if ($val != "repeat") {
                    add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
                }
            }
        } else {
            if ((!empty($input))&&($input != "repeat")) {
                add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
            }
        }

    }

    function po_solid($input) {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return $input;
        }

        if(is_array($input)){
            foreach($input as $val){
                if ($val != "solid") {
                    add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
                }
            }
        } else {
            if ((!empty($input))&&($input != "solid")) {
                add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
            }
        }

    }

    function po_none($input) {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return $input;
        }

        if(is_array($input)){
            foreach($input as $val){
                if ($val != "none") {
                    add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
                }
            }
        } else {
            if ((!empty($input))&&($input != "none")) {
                add_settings_error('plk_error_id81',esc_attr('settings_updated_81'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
            }
        }

    }

    function po_20($input) {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return $input;
        }
        if ($input != "20") {
            add_settings_error('plk_error_id83',esc_attr('settings_updated_83'),__('A premium option was not saved. You must first enter your license key to unlock this premium feature.', 'motech-spacer'),'error');
        }
        return "20";
    }

    function get_premium_warning() {
        if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') {
            return '';
        } else {
            return '<span class="motech_premium_only"> ('.__('Premium Only', 'motech-spacer').')</span>';
        }
    }

    function motech_spacer_prepjsbuttons(){
        ?>
        <script type="text/javascript">
            <?php
            $checkheight = get_option($this->plugin_slug . '_default_height','20');
            $checkunit = get_option($this->plugin_slug . '_default_height_unit','px');
            $return["useheight"] = $checkheight.$checkunit;
            if($this->has_addspacers){
                $ids = $this->key_array;
                $checkaddheights = get_option($this->plugin_slug . '_default_height_addspacers');
                $checkaddheightunits = get_option($this->plugin_slug . '_default_height_unit_addspacers');
                $checktitles = get_option($this->plugin_slug . '_title_addspacers');
                foreach($ids as $key=>$value){
                    $useheight = $checkaddheights[$key];
                    $useunit = $checkaddheightunits[$key];
                    $usetitle = $checktitles[$key];
                    if(empty($usetitle)){
                        $usetitle = "Untitled";
                    }
                    $return["addspacers"][] = array("id"=>$value,"height"=>$useheight.$useunit,"title"=>$usetitle);
                }
            }
            ?>

            var motech_spacer_prepjsbuttons = <?php echo json_encode($return); ?>;
        </script>
        <?php
    }

    function motech_imagepicker_admin_jquery() {
        if (isset($_GET['page']) && $_GET['page'] == $this->plugin_slug.'-setting-admin') { //if we are on our admin page
            ?>
            <script>
                jQuery(function() {

                    jQuery("body").on("click",".sendhook .newbutton.readysend", function() {
                        buttonelement = jQuery(this);
                        jQuery(this).find(".readysendlabel").html("SENDING...");
                        jQuery(this).removeClass("readysend").addClass("notreadysend").css("cursor","not-allowed");
                        suggestion = jQuery("textarea[name=mysuggestion]").val();
                        signmeup = jQuery("input[name=signmeup]:checked").val();
                        myemail = jQuery("input[name=myemail]").val();

                        //user doesn't want to sign up for mailing list, email not sent
                        if(typeof signmeup == 'undefined'){
                            myemail = "";
                        }

                        jQuery.ajax({
                            type: "POST",
                            dataType: "json",
                            url: "http://www.justinsaad.com/suggestions/response.php",
                            data: { suggestion : suggestion, signmeup : signmeup, myemail : myemail },
                            success: function(data) { //data is the response from the php page
                                jQuery(".responsehook").text(data['response']).fadeIn('slow');
                                buttonelement.find(".readysendlabel").html("SENT!");
                            }
                        });

                    });

                    //jquery for color picker
                    jQuery('tr.motech-color-field').removeClass('motech-color-field');

                    //jquery for image picker
                    jQuery(".motech_image_picker_wrap").click(function(){
                        jQuery(this).closest(".motech_image_picker").find(".motech_image_picker_wrap").removeClass("current");
                        jQuery(this).addClass("current");
                        selectedvalue = jQuery(this).find("img").attr("alt");
                        jQuery("#<?php echo $this->plugin_slug ?>_current_theme").val(selectedvalue);
                    });
                    jQuery("#<?php echo $this->plugin_slug ?>_current_theme").parent().parent().hide();
                    <?php if (get_option($this->plugin_slug . '_ihmsa','') == 'hmsia') : ?>
                    <?php
                    if(get_option('hide_my_site_premium_expansion_plk','') != '') {
                        $useval = get_option('hide_my_site_premium_expansion_plk','');
                    } elseif(get_option($this->plugin_slug . '_plk','') != '') {
                        $useval = get_option('hide_my_site_premium_expansion_plk','');
                    }
                    ?>
                    useval = '<?php echo $useval ?>';
                    jQuery("#hide_my_site_plk").replaceWith("<div>"+useval+"</div>");
                    <?php else : ?>
                    jQuery("#hide_my_site_plk").replaceWith("<div></div>");
                    <?php endif ?>

                    jQuery("#hms_get_premium").click(function(){
                        //jQuery(".motech_premium_box").slideToggle(200);
                    });

                    jQuery(".motech_premium_cancel span").click(function(){
                        jQuery(".motech_premium_box").slideUp(200, function() {
                            // Animation complete.
                            //jQuery("#green_ribbon").hide();
                        });

                    });
                    jQuery(".how_to_redeem").click(function(){
                        jQuery(".redeem_info").slideToggle(200);
                    });

                    jQuery("body").on('click', '#hms_get_premium, .hms_get_premium, .buynowbutton', function(e) {
                        e.preventDefault();
                        jQuery("html, body").animate({ scrollTop: 0 }, 300, function() {
                            // Animation complete.
                            jQuery("#green_ribbon").show();
                            jQuery(".motech_premium_box").slideDown(200);

                        });

                        //switch to different add on if set
                        var addonname = jQuery(this).attr('addonname');
                        console.log(addonname);
                        // For some browsers, `attr` is undefined; for others, `attr` is false. Check for both.
                        if (typeof addonname !== typeof undefined && addonname !== false) {
                            // Element has this attribute
                            if(addonname=="gotourl"){
                                var useurl = jQuery(this).attr('useurl');
                                window.open(useurl);
                            }else{
                                jQuery(".grwrap").hide();
                                jQuery(".grwrap."+addonname).show();
                            }
                        }

                    });


                });
            </script>
            <?php
        }
    }


} //end class

function load_sva() {
    if( !class_exists( 'spacer_layout_aid' ) ) {

        include 'sva/sva.php';

    }
}
add_action( 'plugins_loaded', 'load_sva' );

$class = new motech_spacer();

add_action('init', array($class, 'add_custom_button'));