<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed 
/**
 * Plugin Name:       Customized Admin Bar
 * Plugin URI:        http://coresol.pk
 * Description:       Customized Admin Bar While you are logged in to WordPress site, this plugin will allow you to design admin bar that is displayed on the web site
 * Version:           1.0.0
 * Author:            Hassan Ali
 * Author URI:        https://profiles.wordpress.org/creativehassan
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

class custom_admin_bar {
	var $plugin_name;
	var $plugin_folder;
	var $plugin_url;
	/**
     * custom_admin_bar constructor.
     */
    public function __construct() {
		$this->plugin_name 		= "cab_customadminbar";
		$this->plugin_folder    = plugin_dir_path( __FILE__ );
        $this->plugin_url       = plugin_dir_url( __FILE__ );

        add_action( 'admin_menu', array( $this, 'custom_admin_bar_menu' ) );
		add_action( 'after_setup_theme', array( $this, 'custom_toolbar_check' ) );
		add_action( 'plugins_loaded', array( $this, 'custom_admin_bar_init' ) );
		add_action( 'get_header', array( $this, 'old_admin_remove_css_bar' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'custom_admin_bar_script' ), 10 );
		add_action( 'wp_head', array( $this, 'custom_admin_bar_head_style' ) );
		add_action( 'wp_footer', array( $this, 'custom_admin_bar_footer_style' ), 22 );
		add_action( 'admin_enqueue_scripts', array( $this, 'wp_custom_admin_bar_add_color_picker') );

	}
	
	public function wp_custom_admin_bar_add_color_picker() {
 
		if( is_admin() ) { 
		 
			// Add the color picker css file       
			wp_enqueue_style( 'wp-color-picker' ); 
			 
			// Include our custom jQuery file with WordPress Color Picker dependency
			wp_enqueue_script( 'admin-bar-color', plugins_url( 'js/admin-bar-color.js', __FILE__ ), array( 'wp-color-picker' ), false, true );
		}
	}
	/**
	* admin bar menu
	*/
	public function custom_admin_bar_menu(){
		add_menu_page( __( 'Custom Admin Bar', $this->plugin_name ), __( 'Custom Admin Bar', $this->plugin_name ), 'manage_options', 'cab_customadminbar', array( $this, 'cab_main_admin_panel' ), 'dashicons-welcome-widgets-menus', 90 );
	}
	/**
	* admin menu display
	*/
	public function cab_main_admin_panel(){
		if(isset($_POST['wp_custom_admin_bar'])){
			$wp_custom_admin_bar = $_POST['wp_custom_admin_bar'];
			update_option('wp_custom_admin_bar', $wp_custom_admin_bar);
		}
		include_once("include/admin_menu.php"); //display menu design option page
	}
	/**
	* Remove old admin bar CSS
	*/
	public function old_admin_remove_css_bar(){
		remove_action( 'wp_head', '_admin_bar_bump_cb' ); //removed
	}
	/**
	 * 'Show Toolbar when viewing site' check box is enabled for this user.
	 */
	public function custom_toolbar_check(){
		get_currentuserinfo();
		$show_admin_bar_front = get_user_meta( get_current_user_id(), 'show_admin_bar_front', true );
		if( $show_admin_bar_front  !==  'true' ) return;
	}
	/**
	 * textdomain for this plugin.
	 */
	public function custom_admin_bar_init(){
		load_plugin_textdomain( 'bottom-admin-bar', false, dirname( plugin_basename( __FILE__ ) ) ); 
	}
	public function custom_admin_bar_script(){
		if ( is_user_logged_in() ) {
			wp_register_style( 'custom_admin_bar', plugins_url( 'css/custom_admin_bar.css', __FILE__ ) );
			wp_enqueue_style( 'custom_admin_bar' );
		}
	}
	public function custom_admin_bar_head_style(){		
		ob_start();
			include_once("css/custom-css.php");
		$output = ob_get_clean();
		if ( is_user_logged_in() ) echo $output;	
	}
	public function custom_admin_bar_footer_style(){
		$output_footer = '<script type="text/javascript">
					jQuery( document ).ready( function( $ ){
						$( "body" ).keydown(function( event ){
							if( event.shiftKey === true && event.which === 65 ){
								$( "#wpadminbar" ).slideToggle( "fast" );
								$( "html" ).toggleClass( "spaceClear" );
							}
						});
					});
					</script>';
		if ( is_user_logged_in() ) echo $output_footer;
	}
}
$custom_admin_bar = new custom_admin_bar();

?>