<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @package    WTCW_Customization_For_Woocommerce
 * @subpackage WTCW_Customization_For_Woocommerce/public
 * @author     Customization For Woocommerce <support@webbytemplate.com>
 */
class WTCW_Customization_For_Woocommerce_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0 
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    		The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

		add_action( 'after_setup_theme', array( $this, 'public_resource' ) );
		add_action( 'wp', array( $this, 'generate_hooks' ) );
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/public.js', array( 'jquery' ), $this->version, false );

	}

	/**
	 * Register the public resource.
	 *
	 * @since    1.0.0
	 */
	public function public_resource() {

		// Field value function
		function customization_get_field_value( $name, $tab ){

			$option_name = str_replace( '-', '_', CUSTOMIZATION_FOR_WOOCOMMERCE ) .'_'.$tab;
			$option = get_option( $option_name );

			if( $option ){
				if( isset( $option[$name] ) && !empty( $option[$name] ) ){
					return str_replace("\'", "'", $option[$name]);
				}
			}

			return '';  
		}

	}

	/**
	* Generate hooks in frontend
	*
	* @since 1.0.0
	*
	* @return void
	*/
	public function generate_hooks() {

		global $post;
		$hook_info =  array();
		$customization_fields = new WTCW_Customization_For_Woocommerce_Fields( $this->plugin_name, $this->version );
		$enable_disable_plugin = $customization_fields->get_value( 'enable_disable_plugin','' );

		if( $enable_disable_plugin && $enable_disable_plugin == 'yes' ){
			$global_hook_arr = $customization_fields->get_value( 'woo_action_repeater','' );

			if( $global_hook_arr && is_array( $global_hook_arr ) ){
				foreach( $global_hook_arr as $global_ho_key => $global_hook ) { 
					if( isset( $global_hook['woo_action'] ) && !empty( $global_hook['woo_action'] ) ){
						$hook_info[$global_hook['woo_action']] = $global_hook;
					}
				}
			}

			if( $post && isset( $post->ID ) && !empty( $post->ID ) ){
				$woo_action_repeater =	get_post_meta( $post->ID, 'woo_action_repeater', true );
				if( $woo_action_repeater && !empty( $woo_action_repeater ) && is_array( $woo_action_repeater )){
					foreach( $woo_action_repeater as $pro_ho_key => $pro_hook ) { 
						if( isset( $pro_hook['woo_action'] ) && !empty( $pro_hook['woo_action'] ) ){
							$hook_info[$pro_hook['woo_action']] = $pro_hook;
						}
					}
				}
			}

			if( $hook_info && is_array( $hook_info ) ){

				foreach( $hook_info as $ho_key => $hook ) {

					if( !isset($ho_key) && !isset( $hook['woo_group']) && !isset( $hook['woo_condition_action']) && !isset( $hook['woo_condition_type']) && !isset($hook['woo_editor'])) {
						continue;
					}

					if(  $hook['woo_group'] == 'single_product' && is_single() ){

						global $post;

						if( isset( $hook['woo_condition_type'] ) && $hook['woo_condition_type'][0] == 'all' ){
							$this->wt_add_action_by_hook( $hook );
						}else{

							if( $hook['woo_condition_action'] == 'product' ){ 

								if( empty( $hook['woo_condition_action'] ) || empty( $hook['woo_condition'] ) || empty( $hook['woo_condition_type'] ) ){
									$this->wt_add_action_by_hook( $hook );
								}else{
									if( $hook['woo_condition'] == '==' && is_array($hook['woo_condition_type']) && in_array( $post->ID, $hook['woo_condition_type'] ) ){
										$this->wt_add_action_by_hook( $hook );
									}elseif( $hook['woo_condition'] == '!=' && is_array($hook['woo_condition_type']) && !in_array( $post->ID, $hook['woo_condition_type'] ) ){
										$this->wt_add_action_by_hook( $hook );
									}
								}

							}elseif ( $hook['woo_condition_action'] == 'product_cat' ) {

								if( empty( $hook['woo_condition_action'] ) || empty( $hook['woo_condition'] ) || empty( $hook['woo_condition_type'] ) ){
									$this->wt_add_action_by_hook( $hook );
								}else{
									$cat_list = get_the_terms( $post->ID, 'product_cat' );									
									$cat_list =  wp_list_pluck($cat_list, 'term_id');
									$unique_arr = array();
									if( $cat_list ){
										$unique_arr = array_intersect( $cat_list, $hook['woo_condition_type'] );									
									}

									if( !empty( $hook['woo_condition'] ) && $hook['woo_condition'] == '==' && count($unique_arr) > 0 ){
										$this->wt_add_action_by_hook( $hook );
									}elseif( !empty( $hook['woo_condition'] ) && $hook['woo_condition'] == '!=' && count($unique_arr) == 0 ){
										$this->wt_add_action_by_hook( $hook );
									}
								}								

							}elseif ( $hook['woo_condition_action'] == 'product_tag'  ) {

								if( empty( $hook['woo_condition_action'] ) || empty( $hook['woo_condition'] ) || empty( $hook['woo_condition_type'] ) ){
									$this->wt_add_action_by_hook( $hook );
								}else{

									$cat_list = get_the_terms( $post->ID, 'product_tag' );									
									$cat_list =  wp_list_pluck($cat_list, 'term_id');
									$unique_arr = array();
									if( $cat_list ){
										$unique_arr = array_intersect( $cat_list, $hook['woo_condition_type'] );									
									}

									if( $hook['woo_condition'] == '==' && count($unique_arr) > 0 ){
										$this->wt_add_action_by_hook( $hook );
									}elseif( $hook['woo_condition'] == '!=' && count($unique_arr) == 0 ){
										$this->wt_add_action_by_hook( $hook );
									}
								}
							}
						}						

					}elseif (  $hook['woo_group'] == 'shop_page' && is_shop() || is_archive() ) {
						$this->wt_add_action_by_hook( $hook );
					}elseif ( $hook['woo_group'] == 'cart_page' && is_page( 'cart' ) || is_cart() ) {
						$this->wt_add_action_by_hook( $hook );
					}elseif ( $hook['woo_group'] == 'checkout_page' && is_checkout() || is_page('checkout') ) {
						$this->wt_add_action_by_hook( $hook );
					}elseif ( $hook['woo_group'] == 'category_page' && is_product_category() ) {
						$this->wt_add_action_by_hook( $hook );
					}
				}
			}
		}
	}

	public function wt_add_action_by_hook( $hook ){

		$woo_priority = isset( $hook['woo_priority'] ) ? $hook['woo_priority'] : 10;

		add_action( $hook['woo_action'], function() use ($hook) {
			
			$option_content = isset( $hook['woo_editor'] ) ? $hook['woo_editor'] : '';
			
			if( isset($option_content) && !empty($option_content) ) {

				 //$option_content = strip_tags($option_content);
				$option_content = htmlspecialchars_decode($option_content);
				$option_content = do_shortcode($option_content);

				echo '<div id="' . esc_attr( $hook['woo_action'] ) . '" class="woo-product-hook">' .  wp_kses_post( $option_content ) . '</div>';
			}

		}, $woo_priority );
	}
}