<?php
/**
 * Plugin Name:       Customization For WooCommerce
 * Plugin URI:        https://woo-customization.webbytemplate.com/
 * Description:       Customization For WooCommerce plugin offers powerful tools for editing product pages, creating custom shop layouts, and optimizing individual product displays with ease.
 * Version:           1.0.1
 * Author:            webbytemplate
 * Author URI:        https://webbytemplate.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       customization-for-woocommerce
 * Requires Plugins: woocommerce
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin name ,version, .
 */
define( 'WTCW_CUSTOMIZATION_FOR_WOOCOMMERCE_VERSION', '1.0.1' );
define( 'WTCW_CUSTOMIZATION_FOR_WOOCOMMERCE_NAME', 'customization-for-woocommerce' );
define( 'WTCW_CUSTOMIZATION_FOR_WOOCOMMERCE_PLUGIN_FILE', __FILE__ );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-activator.php
 */
function wtcw_activate_customization_for_woocommerce() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-activator.php';
	WTCW_Customization_For_Woocommerce_Activator::activate();
}

register_activation_hook( __FILE__, 'wtcw_activate_customization_for_woocommerce' );

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-deactivator.php
 */
function wtcw_deactivate_customization_for_woocommerce() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-deactivator.php';
	WTCW_Customization_For_Woocommerce_Deactivator::deactivate();
}

register_deactivation_hook( __FILE__, 'wtcw_deactivate_customization_for_woocommerce' );

/**
 * The code load core packages, admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/packages.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */

$plugin = new WTCW_Customization_For_Woocommerce(); 
