<?php
/**
 * The navs & panels array for setting page.
 *
 * @package    WTCW_Customization_For_Woocommerce
 * @subpackage WTCW_Customization_For_Woocommerce/admin
 * @author     Customization For WooCommerce <support@webbytemplate.com>
 */
class  WTCW_Customization_For_Woocommerce_Custom_Settings {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version           The version of this plugin.
     */
    public function __construct( $plugin_name, $version ) {

     $this->plugin_name = $plugin_name;
     $this->version = $version;

     add_filter( "wtcw_customization_settings_nav", array( $this, "wt_add_customization_settings_nav" ), 10, 1 );
     add_filter( "wtcw_customization_settings_panel", array( $this, "wt_add_customization_settings_panel" ), 10, 1 );
     add_filter( "wtcw_enqueue_admin_styles", array( $this, "wt_enqueue_admin_style_panel" ));
     add_filter( "wtcw_enqueue_admin_scripts", array( $this, "wtcw_enqueue_admin_scripts_panel" ));

     add_action( 'wp_ajax_get_customization_repeater_html', array( $this, 'get_customization_repeater_html' ) );
     add_action( 'wp_ajax_nopriv_get_customization_repeater_html', array( $this, 'get_customization_repeater_html' ) );

     add_action( 'wp_ajax_get_customization_product_data', array( $this, 'get_customization_product_data' ) );
     add_action( 'wp_ajax_nopriv_get_customization_product_data', array( $this, 'get_customization_product_data' ) );

   }

    /**
    * This function is return navs array.
    *
    * @since    1.0.0
    * @access   public
    */
    public function wt_add_customization_settings_nav( $navs ) {

      $navs = array(
        'general' => array(
          'title' => __( 'Main Settings', 'customization-for-woocommerce' ),
          'icon' => 'fa-cogs',
          'action' => true
        ),
        'help' => array(
          'title' => __('Preview', 'customization-for-woocommerce'),
          'icon' => 'fa-cogs',
          'action' => true
        ),
      );

      return $navs;
    }

    /**
     * This function is return panels array.
     *
     * @since    1.0.0
     * @access   public
     */
    public function wt_add_customization_settings_panel( $panels ) { 

      $woo_action = $this->wt_add_customization_action_settings();
      $woo_condition_action = $this->wt_add_customization_condition_action_settings();
      $woo_condition = $this->wt_add_customization_condition_settings();
      $woo_condition_type = $this->wt_add_customization_condition_type_settings();
      $woo_preview_data = $this->wt_add_preview_settings();

      $panels['general'] = array(
        'title' => __( 'General', 'customization-for-woocommerce' ),
        'section' => array(
          array(
            'title' => __( 'General', 'customization-for-woocommerce' ),
            'icon' => 'fa-solid fa-braille',
            'desc' => '',
            'fields' => array(
              array(
                'type' => 'switch',
                'name' => 'enable_disable_plugin',
                'title' => __( 'Enable/Disable Plugin', 'customization-for-woocommerce' ),
                'field_desc' => __( 'Enable/Disable Plugin selection.', 'customization-for-woocommerce' ),
                'default' => 'yes'
              ),
              array(
                'name' => 'woo_action_repeater',
                'type' => 'repeater',
                'title' => __('WooCommerce Action', 'customization-for-woocommerce' ),
                'disabled' => false,
                'readonly' => false,
                'required' => false,
                'value' => 'select',
                'options' => $woo_action,
                'condition_action' => $woo_condition_action,
                'condition' => $woo_condition,
                'condition_type' => $woo_condition_type,
              ),
            ),
          ),
        )
      );

      $panels['help'] = array(
        'title' => __( 'Preview', 'customization-for-woocommerce' ),
        'section' => array(
          array(
            'title' => __( 'Preview', 'customization-for-woocommerce' ),
            'icon' => 'fa-solid fa-braille',
            'desc' => '',
            'fields' => array(
              array(
                'name' => 'woo_action_help',
                'type' => 'preview',
                'title' => __('Select Group Preview', 'customization-for-woocommerce' ),
                'disabled' => false,
                'readonly' => false,
                'required' => false,
                'value' => 'select',
                'options' => $woo_action,
                'preview_data' => $woo_preview_data,
              ),
            ),
          ),
        )
      );
      return $panels;
    }

    /**
    * This function is return condition action array.
    *
    * @since    1.0.0
    * @access   public
    */

    public function wt_add_customization_condition_action_settings() { 

      $woo_condition = array(
        '' => __( 'Select type', 'customization-for-woocommerce' ),
        'product' => __( 'Product', 'customization-for-woocommerce' ),
        'product_cat' => __( 'Category', 'customization-for-woocommerce' ),
        'product_tag' => __( 'Tags', 'customization-for-woocommerce' ),
      );

      return $woo_condition;
    }

    /**
    * This function is return condition array.
    *
    * @since    1.0.0
    * @access   public
    */

    public function wt_add_customization_condition_settings() { 

      $woo_condition = array(
        '' => __( 'Select Condition', 'customization-for-woocommerce' ),
        '==' => __( 'is equal to', 'customization-for-woocommerce' ),
        '!=' => __( 'is not equal to', 'customization-for-woocommerce' ),
      );

      return $woo_condition;
    }

    /**
    * This function is return condition Type array.
    *
    * @since    1.0.0
    * @access   public
    */

    public function wt_add_customization_condition_type_settings() { 

      $woo_condition['custom'] = array(
        'all' => __( 'All', 'customization-for-woocommerce' ),
      );

      $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1
      );
      $loop = new WP_Query( $args );
      if ( $loop->have_posts() ) {
        while ( $loop->have_posts() ) : $loop->the_post();
          $woo_condition['product'][get_the_ID()] = get_the_title();
        endwhile;
      } 
      wp_reset_postdata();

      $terms_product_cat = get_terms( array(
        'taxonomy'   => 'product_cat',
        'hide_empty' => false,
      ) );

      if(  $terms_product_cat  ){
        foreach( $terms_product_cat as $terms_cat ) {
          $woo_condition['product_cat'][$terms_cat->term_id] = $terms_cat->name;
        }
      }

      $terms_post_tag = get_terms( array(
        'taxonomy'   => 'product_tag',
        'hide_empty' => false,
      ) );

      if(  $terms_post_tag  ){
        foreach( $terms_post_tag as $terms_tag ) {
          $woo_condition['product_tag'][$terms_tag->term_id] = $terms_tag->name;
        }
      }

      return $woo_condition;
    }


    /**
    * This function is return condition Type array.
    *
    * @since    1.0.0
    * @access   public
    */

    public function wt_add_preview_settings() { 

      $woo_preview_action = array(
        'single_product' => esc_url( plugins_url('/images/SingleProduct.jpg', __FILE__ ), 'customization-for-woocommerce' ),
        'shop_page' => esc_url( plugins_url('/images/Shop.jpg', __FILE__ ), 'customization-for-woocommerce' ),
        'cart_page' => esc_url( plugins_url('/images/Cart.jpg', __FILE__ ), 'customization-for-woocommerce' ),
        'checkout_page' => esc_url( plugins_url('/images/Checkout.jpg', __FILE__ ), 'customization-for-woocommerce' ),
        'category_page' => esc_url( plugins_url('/images/Category.jpg', __FILE__ ), 'customization-for-woocommerce' ),
      );

      return $woo_preview_action;
    }

    /**
    * This function is return Hook array.
    *
    * @since    1.0.0
    * @access   public
    */

    public function wt_add_customization_action_settings() { 

      $woo_action['Select_Action'] =  array(
        '' => __( 'Select Action', 'customization-for-woocommerce' ),
      );

      $woo_action['single_product'] =  array(
        'woocommerce_before_single_product' => __( 'Woocommerce Before Single Product', 'customization-for-woocommerce' ),
        'woocommerce_product_thumbnails' => __( 'Woocommerce Product Thumbnails', 'customization-for-woocommerce' ),
        'woocommerce_before_single_product_summary' => __( 'Woocommerce Before Single Product Summary', 'customization-for-woocommerce' ),
        'woocommerce_single_product_summary' => __( 'Woocommerce Single Product Summary', 'customization-for-woocommerce' ),
        'woocommerce_before_add_to_cart_form' => __( 'Woocommerce Before Add To Cart Form', 'customization-for-woocommerce' ),
        'woocommerce_before_variations_form' => __( 'Woocommerce Before Variations Form', 'customization-for-woocommerce' ),
        'woocommerce_before_add_to_cart_button' => __( 'Woocommerce Before Add To Cart Button', 'customization-for-woocommerce' ),
        'woocommerce_before_single_variation' => __( 'Woocommerce Before Single Variation', 'customization-for-woocommerce' ),
        'woocommerce_single_variation' => __( 'Woocommerce Single Variation', 'customization-for-woocommerce' ),
        'woocommerce_after_single_variation' => __( 'Woocommerce After Single Variation', 'customization-for-woocommerce' ),
        'woocommerce_after_add_to_cart_button' => __( 'Woocommerce After Add To Cart Button', 'customization-for-woocommerce' ),
        'woocommerce_after_variations_form' => __( 'Woocommerce After VariationS Form', 'customization-for-woocommerce' ),
        'woocommerce_after_add_to_cart_form' => __( 'Woocommerce After Add To Cart Form', 'customization-for-woocommerce' ),
        'woocommerce_product_meta_start' => __( 'Woocommerce Product Meta Start', 'customization-for-woocommerce' ),
        'woocommerce_product_meta_end' => __( 'Woocommerce Product Meta End', 'customization-for-woocommerce' ),
        'woocommerce_share' => __( 'Woocommerce Share', 'customization-for-woocommerce' ),
        'woocommerce_after_single_product_summary' => __( 'Woocommerce After Single Product Summary', 'customization-for-woocommerce' ),
        'woocommerce_after_single_product' => __( 'Woocommerce After Single Product', 'customization-for-woocommerce' ),
      );

      $woo_action['shop_page'] =  array(
        'woocommerce_before_main_content' => __( 'Woocommerce Before Main Content', 'customization-for-woocommerce' ),
        'woocommerce_archive_description' => __( 'Woocommerce Archive Description', 'customization-for-woocommerce' ),
        'woocommerce_before_shop_loop' => __( 'Woocommerce Before Shop Loop', 'customization-for-woocommerce' ),
        'woocommerce_before_shop_loop_item' => __( 'Woocommerce Before Shop Loop Item', 'customization-for-woocommerce' ),
        'woocommerce_before_shop_loop_item_title' => __( 'Woocommerce Before Shop Loop Item Title', 'customization-for-woocommerce' ),
        'woocommerce_shop_loop_item_title' => __( 'Woocommerce Shop Loop Item Title', 'customization-for-woocommerce' ),
        'woocommerce_after_shop_loop_item_title' => __( 'Woocommerce After Shop Loop Item Title', 'customization-for-woocommerce' ),
        'woocommerce_after_shop_loop_item' => __( 'Woocommerce After Shop Loop Item', 'customization-for-woocommerce' ),
        'woocommerce_after_shop_loop' => __( 'Woocommerce After Shop Loop', 'customization-for-woocommerce' ),
        'woocommerce_after_main_content' => __( 'Woocommerce After Main Content', 'customization-for-woocommerce' ),
      );

      $woo_action['cart_page'] =  array(
        'woocommerce_before_cart' => __( 'Woocommerce Before Cart', 'customization-for-woocommerce' ),
        'woocommerce_before_cart_table' => __( 'Woocommerce Before Cart Table', 'customization-for-woocommerce' ),
        'woocommerce_before_cart_contents' => __( 'Woocommerce Before Cart Contents', 'customization-for-woocommerce' ),
        'woocommerce_cart_contents' => __( 'Woocommerce Cart Contents', 'customization-for-woocommerce' ),
        'woocommerce_cart_coupon' => __( 'Woocommerce Cart Coupon', 'customization-for-woocommerce' ),
        'woocommerce_after_cart_contents' => __( 'Woocommerce After Cart Contents', 'customization-for-woocommerce' ),
        'woocommerce_after_cart_table' => __( 'Woocommerce After Cart Table', 'customization-for-woocommerce' ),
        'woocommerce_cart_collaterals' => __( 'Woocommerce Cart Collaterals', 'customization-for-woocommerce' ),
        'woocommerce_before_cart_totals' => __( 'Woocommerce Before Cart Totals', 'customization-for-woocommerce' ),
        'woocommerce_cart_totals_before_shipping' => __( 'Woocommerce Before Cart Before Shipping', 'customization-for-woocommerce' ),
        'woocommerce_before_shipping_calculator' => __( 'Woocommerce Before Shipping Calculator', 'customization-for-woocommerce' ),
        'woocommerce_after_shipping_calculator' => __( 'Woocommerce After Shipping Calculator', 'customization-for-woocommerce' ),
        'woocommerce_cart_totals_after_shipping' => __( 'Woocommerce Cart Totals After Shipping', 'customization-for-woocommerce' ),
        'woocommerce_cart_totals_before_order_total' => __( 'Woocommerce Cart Totals before_order_total', 'customization-for-woocommerce' ),
        'woocommerce_cart_totals_after_order_total' => __( 'Woocommerce Cart Totals after_order_total', 'customization-for-woocommerce' ),
        'woocommerce_proceed_to_checkout' => __( 'Woocommerce Proceed To Checkout', 'customization-for-woocommerce' ),
        'woocommerce_after_cart_totals' => __( 'Woocommerce After Cart Totals', 'customization-for-woocommerce' ),
        'woocommerce_after_cart' => __( 'Woocommerce After cart', 'customization-for-woocommerce' ),
      );

      $woo_action['checkout_page'] =  array(
        'woocommerce_before_checkout_form' => __( 'Woocommerce Before Checkout Form', 'customization-for-woocommerce' ),
        'woocommerce_checkout_before_customer_details' => __( 'Woocommerce Checkout Before Customer Details', 'customization-for-woocommerce' ),
        'woocommerce_before_checkout_billing_form' => __( 'Woocommerce Before Checkout Billing form', 'customization-for-woocommerce' ),
        'woocommerce_after_checkout_billing_form' => __( 'Woocommerce After Checkout Billing form', 'customization-for-woocommerce' ),
        'woocommerce_before_checkout_shipping_form' => __( 'Woocommerce Before Checkout Shipping Form', 'customization-for-woocommerce' ),
        'woocommerce_after_checkout_shipping_form' => __( 'Woocommerce After Checkout Shipping Form', 'customization-for-woocommerce' ),
        'woocommerce_before_order_notes' => __( 'Woocommerce Before Order Notes', 'customization-for-woocommerce' ),
        'woocommerce_after_order_notes' => __( 'Woocommerce After Order Notes', 'customization-for-woocommerce' ),
        'woocommerce_checkout_after_customer_details' => __( 'Woocommerce Checkout After Customer Details', 'customization-for-woocommerce' ),
        'woocommerce_checkout_before_order_review' => __( 'Woocommerce Checkout Before Order Review', 'customization-for-woocommerce' ),
        'woocommerce_review_order_before_cart_contents' => __( 'Woocommerce Review Order Before Cart Contents', 'customization-for-woocommerce' ),
        'woocommerce_review_order_after_cart_contents' => __( 'Woocommerce Review Order After Cart Contents', 'customization-for-woocommerce' ),
        'woocommerce_review_order_before_shipping' => __( 'Woocommerce Review Order Before Shipping', 'customization-for-woocommerce' ),
        'woocommerce_review_order_after_shipping' => __( 'Woocommerce Review Order After Shipping', 'customization-for-woocommerce' ),
        'woocommerce_review_order_before_order_total' => __( 'Woocommerce Review Order Before Order Total', 'customization-for-woocommerce' ),
        'woocommerce_review_order_after_order_total' => __( 'Woocommerce Review Order After Order Total', 'customization-for-woocommerce' ),
        'woocommerce_review_order_before_payment' => __( 'Woocommerce Review Order Before Payment', 'customization-for-woocommerce' ),
        'woocommerce_review_order_before_submit' => __( 'Woocommerce Review Order Before Submit', 'customization-for-woocommerce' ),
        'woocommerce_review_order_after_submit' => __( 'Woocommerce Review Order After Submit', 'customization-for-woocommerce' ),
        'woocommerce_review_order_after_payment' => __( 'Woocommerce Review Order After Payment', 'customization-for-woocommerce' ),
        'woocommerce_checkout_after_order_review' => __( 'Woocommerce Checkout After Order Review', 'customization-for-woocommerce' ),
        'woocommerce_after_checkout_form' => __( 'Woocommerce After Checkout Form', 'customization-for-woocommerce' ),
      );

      $woo_action['category_page'] =  array(
        'woocommerce_before_main_content' => __( 'Woocommerce Before Main Content', 'customization-for-woocommerce' ),
        'woocommerce_archive_description' => __( 'Woocommerce Archive Description', 'customization-for-woocommerce' ),
        'woocommerce_before_shop_loop' => __( 'Woocommerce Before Shop Loop', 'customization-for-woocommerce' ),
        'woocommerce_before_shop_loop_item' => __( 'Woocommerce Before Shop Loop Item', 'customization-for-woocommerce' ),
        'woocommerce_before_shop_loop_item_title' => __( 'Woocommerce Before Shop Loop Item Title', 'customization-for-woocommerce' ),
        'woocommerce_shop_loop_item_title' => __( 'Woocommerce Shop Loop Item Title', 'customization-for-woocommerce' ),
        'woocommerce_after_shop_loop_item_title' => __( 'Woocommerce After Shop Loop Item Title', 'customization-for-woocommerce' ),
        'woocommerce_after_shop_loop_item' => __( 'Woocommerce After Shop Loop Item', 'customization-for-woocommerce' ),
        'woocommerce_after_shop_loop' => __( 'Woocommerce After Shop Loop', 'customization-for-woocommerce' ),
        'woocommerce_after_main_content' => __( 'Woocommerce After Main Content', 'customization-for-woocommerce' ),
      );

      return $woo_action;
    }

  /**
  * Add Custom Script 
  *
  * @since      1.0.0
  * @param      string    $plugin_name       The name of this plugin.
  * @param      string    $version        The version of this plugin.
  */

  public function wtcw_enqueue_admin_scripts_panel( $enqueue_scripts ){
    $current_screen = get_current_screen();
    if ( isset( $current_screen->base ) && isset( $current_screen->post_type ) && $current_screen->base == 'post' && $current_screen->post_type == 'product'  ) {
      $enqueue_scripts[$this->plugin_name] = array(
        'localize_script' => 'wt_ajax',
        'direct' => false,
        'path' => plugin_dir_url( __FILE__ ) . 'js/admin.js'
      );
    }
    return  $enqueue_scripts;
  } 

  /**
  * Add Custom Style 
  *
  * @since      1.0.0
  * @param      string    $plugin_name       The name of this plugin.
  * @param      string    $version        The version of this plugin.
  */

  public function wt_enqueue_admin_style_panel( $enqueue_styles){
    $current_screen = get_current_screen();
    if ( isset( $current_screen->base ) && isset( $current_screen->post_type ) && $current_screen->base == 'post' && $current_screen->post_type == 'product'  ) {
      $enqueue_styles[$this->plugin_name] = array(
        'direct' => false,
        'path' => plugin_dir_url( __FILE__ ) . 'css/admin.css'
      );
    }
    return   $enqueue_styles;
  }

  /**
  * Retun Repeater Html Ajax
  *
  * @since      1.0.0
  * @param      string    $plugin_name       The name of this plugin.
  * @param      string    $version        The version of this plugin.
  */

  public function get_customization_repeater_html(){

    check_ajax_referer( 'wt_form_save', 'ajax_nonce' );
    $customization_count = isset( $_POST['customization_count'] ) ? sanitize_text_field( $_POST['customization_count'] ) : 1;
    $customization_single = isset( $_POST['customization_single'] ) ? sanitize_text_field( $_POST['customization_single'] ) : false;
    $customization_fields = new WTCW_Customization_For_Woocommerce_Fields( $this->plugin_name, $this->version );
    $woo_action = $this->wt_add_customization_action_settings();
    $woo_condition_action = $this->wt_add_customization_condition_action_settings();
    $woo_condition = $this->wt_add_customization_condition_settings();
    $woo_condition_type = $this->wt_add_customization_condition_type_settings();
    $custom_editor_id = 0;
    $html = $value = '';

    ob_start();
    if( $customization_count && $customization_count > 0 ){
      $custom_editor_id = "woo_action_repeater_".$customization_count;
      require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/includes/class-extra-repeater-field.php';   
    }

    $html .= ob_get_clean();

    wp_send_json( array( 'html' => $html, 'custom_editor_id' => $custom_editor_id ) );
  }

  /**
  * Retun Repeater Html Ajax
  *
  * @since      1.0.0
  * @param      string    $plugin_name       The name of this plugin.
  * @param      string    $version        The version of this plugin.
  */

  public function get_customization_product_data(){ 
    check_ajax_referer( 'wt_form_save', 'ajax_nonce' );

    $html = '';
    ob_start();
    $customization_fields = new WTCW_Customization_For_Woocommerce_Fields( $this->plugin_name, $this->version );
    $condition_val = isset( $_POST['condition_val'] ) ? sanitize_text_field( $_POST['condition_val'] ) : '';
    $woo_condition_type = $this->wt_add_customization_condition_type_settings();
    $condition_data = array();

    if(  $woo_condition_type ){
      foreach(  $woo_condition_type as $key => $condition_type_arr ){ 
        if(  $key &&  $key == $condition_val || $key == 'custom' ){
          if(  $condition_type_arr ){
            foreach ( $condition_type_arr as $option_key => $condition_type ) {
              echo sprintf(
                '<option class="%4$s" value="%1$s" %3$s >%2$s</option>',
                esc_attr( $option_key ),
                esc_html( $condition_type ),
                selected( trim($value), esc_attr( $option_key ), false ),
                esc_attr( 'woo_call_condition '.$key )
              );
            }
          } 
        }
      }
    }

    $html .= ob_get_clean();

    wp_send_json( array( 'html' => $html, 'success' => 'success' ) );
  }

}