(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	setTimeout(function(){		
		jQuery('.woo_select_repeater').select2();
	},200);	

	jQuery(document).on( 'click','.panel-wrapper .wt-section .form-table tbody .customization_main .customization_content .select_field',function(){
		jQuery(this).find('option').removeClass('active');
		jQuery(this).find('option[value="'+jQuery(this).val()+'"]').addClass('active');
	});

	jQuery(document).on( 'click','.customization_btn_main .customization_btn',function(){

		var editor_count = 1;
		var customization_btn = jQuery(this);
		var customization_count = jQuery('.customization_main .customization_editor_main').length;

		if( customization_count && customization_count > 0 && customization_count != undefined && customization_count != null && customization_count != ''){
			editor_count = customization_count;
		}

		jQuery.ajax({
			type : "POST",
			url : wt_ajax.ajaxurl,
			data : {action: "get_customization_repeater_html", ajax_nonce: wt_ajax.nonce, customization_count:customization_count},
			success: function(response) {

				if( response && response.html != '' ){

					if( customization_btn.parents('.customization_product_main').length > 0 ){
						jQuery('.customization_product_main').find('.customization_main .customization_editor_main:last-child').after(response.html);
					}else{
						jQuery('.customization_main.all .customization_editor_main:last-child').after(response.html);
					}
					tinyMCE.execCommand('mceRemoveEditor', false, response.custom_editor_id); 
					tinyMCE.execCommand('mceAddEditor', false, response.custom_editor_id); 
					quicktags({id : response.custom_editor_id});

					setTimeout(function(){
						if( jQuery('.customization_main.single_product').length > 0 ){
							jQuery('.customization_main.single_product .customization_selection.condition_selection .woo_call_condition_main option.woo_call_condition.product').remove();
							jQuery('.customization_main.single_product .woo_call_group_select  .woo_call_group_main .woo_call_group.Select_Action').addClass('single_product');
							jQuery('.customization_main.single_product .woo_call_group_select  .woo_call_group_main .woo_call_group:not(.single_product)').remove();
						}
						jQuery('.woo_select_repeater').select2();
					},200);
				}
			}
		});
	});

	jQuery(document).on( 'change','.customization_selection .customization_condition .woo_call_condition_main.condition_action',function(){

		var call_condition = jQuery(this);
		var condition_val = call_condition.val();

		jQuery.ajax({
			type : "POST",
			url : wt_ajax.ajaxurl,
			data : { action: "get_customization_product_data", ajax_nonce: wt_ajax.nonce, condition_val:condition_val },
			success: function(response) {
				if( response && response.html != '' ){
					call_condition.parents('.customization_selection').find('.customization_condition .woo_call_condition_main.condition_type').html(response.html);
					setTimeout(function(){
						call_condition.parents('.customization_selection').find('.customization_condition .woo_call_condition_main.condition_type').select2();
					},200);
				}
			}
		});
	});

	jQuery(document).on( 'change','.customization_selection  .customization_select .woo_call_group_main',function(){

		var call_group = jQuery(this);
		var action_json = call_group.parents('.customization_main').attr('action_json');
		var group_val = call_group.val();
		var action_arr = [];
		var option_html = '';

		if ( action_json ) {
			action_arr = JSON.parse(action_json);
		}

		if( action_arr && action_arr != '' ){
			if( action_arr[group_val] && action_arr[group_val] != '' ){
				jQuery.each( action_arr[group_val], function( option_key, option_val ) { option_html += '<option class="woo_call_group '+option_key+'" value="'+option_key+'" %3$s >'+option_val+'</option>';});
			}
		}

		if( group_val && group_val == 'single_product' || group_val == 'single_category' ){
			call_group.parents('.customization_editor_main').find('.customization_content .condition_selection').removeClass('hide');
		}else{
			call_group.parents('.customization_editor_main').find('.customization_content .condition_selection').addClass('hide');	
		}

		call_group.parents('.customization_selection').find('.woo_select_action.woo_select_repeater').html(option_html);
		setTimeout(function(){
			call_group.parents('.customization_selection').find('.woo_select_action.woo_select_repeater').select2();
		},200);

	});

	jQuery(document).on( 'change','.custom_preview_main  .custom_preview_selection .woo_preview_main',function(){

		var preview_group = jQuery(this);
		var preview_val = preview_group.val();

		jQuery('.custom_preview_selection .custom_view_main .custom_preview_view').addClass('hide');
		if( preview_val && preview_val != undefined && preview_val != '' && preview_val != null  ){
			jQuery('.custom_preview_main .custom_preview_selection .custom_view_main .custom_preview_view.'+preview_val).removeClass('hide');
		}
	});

	jQuery(document).on('click', '.customization_content .remove_row .remove', function() {
		jQuery(this).parents('.customization_editor_main').remove();
	}); 

	$('.add-prod').on('click', function () {

		var prod_id = $('.prod-id').val();
		var data = {
			action: 'add_prod',
			pid: prod_id
		};
		$('#update-msg').show();

		$.post(ajaxurl, data, function (result) {
			$('#the-list').append(result);
			$('#update-msg').hide();
		});

		return false;
	});

})( jQuery );
