<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<div class="customization_editor_main">
  <div class="customization_content">

   <!-- /*===========================================|| Start Action ||===========================================*/ -->
   <div class="customization_selection">
    <div class="customization_select woo_call_group_select">
      <select class="select_field  woo_call_group_main woo_select_repeater" name="<?php echo esc_attr('woo_action_repeater['.$customization_count.'][woo_group]'); ?>">
        <?php
        if(  $woo_action ){
          foreach(  $woo_action as $key => $options_arr ){ 

            $options_val = str_replace("_"," ",$key);
            if( $options_val ){
              echo sprintf(
                '<option class="%4$s" value="%1$s" %3$s >%2$s</option>',
                esc_attr( $key ),
                esc_html( ucwords( $options_val ) ),
                selected( trim($value), esc_attr( $key ), false ),
                esc_attr( 'woo_call_group '.$key )
              ); 
            }

          }
        }
        ?>
      </select>
    </div>
    <div class="customization_select woo_action_select">
      <select class="select_field woo_select_action woo_select_repeater" name="<?php echo esc_attr('woo_action_repeater['.$customization_count.'][woo_action]'); ?>">
      </select>
    </div>
    <div class="customization_select woo_priority_add">
      <input type="number" name="woo_action_repeater[0][woo_priority]" value="10">
    </div>
    <div class="remove_row"><button type="remove" class="remove" name="remove">
      <span><i class="fa fa-trash" aria-hidden="true"></i></span><?php esc_html_e( 'Remove', 'customization-for-woocommerce' ); ?></button></div>
    </div>

    <!-- /*===========================================|| End Action ||===========================================*/ -->

    <!-- /*===========================================|| Start Editor ||===========================================*/ -->
    <div class="customization_editor">
      <?php 
      $content = '';
      $custom_editor_name = "woo_action_repeater[".$customization_count."][woo_editor]";
      $args = array(
        'media_buttons' => true, 
        'textarea_name' => $custom_editor_name, 
        'textarea_rows' => get_option( 'default_post_edit_rows', 5 ),           
        'wpautop' => false, 
        'quicktags'=>true,
      );
      wp_editor( $content, $custom_editor_id,$args );       
      ?>
    </div>
    <!-- /*===========================================|| End Editor ||===========================================*/ -->

    <!-- /*===========================================|| Start Condition ||===========================================*/ -->
    <div class="customization_selection condition_selection hide" <?php echo esc_attr($customization_single); ?>>
      <div class="customization_condition woo_call_group_select">
        <select class="select_field  woo_call_condition_main condition_action woo_select_repeater" name="<?php echo esc_attr('woo_action_repeater['.$customization_count.'][woo_condition_action]'); ?>">
          <?php
          if(  $woo_condition_action ){
            foreach(  $woo_condition_action as $key => $woo_action ){ 
             echo sprintf(
              '<option class="%4$s" value="%1$s" %3$s >%2$s</option>',
              esc_attr( $key ),
              esc_html( $woo_action ),
              selected( trim($value), esc_attr( $key ), false ),
              esc_attr( 'woo_call_condition '.$key )
            );     
           }
         }
         ?>
       </select>
     </div>
     <div class="customization_condition woo_call_condition_main  condition woo_action_select">
      <select class="select_field woo_select_repeater" name="<?php echo esc_attr('woo_action_repeater['.$customization_count.'][woo_condition]'); ?>">
        <?php
        if(  $woo_condition ){
          foreach(  $woo_condition as $key => $_condition ){ 
            echo sprintf(
              '<option class="%4$s" value="%1$s" %3$s >%2$s</option>',
              esc_attr( $key ),
              esc_html( $_condition ),
              selected( trim($value), esc_attr( $key ), false ),
              esc_attr( 'woo_call_condition '.$key )
            );          
          }
        }
        ?>
      </select>
    </div>
    <div class="customization_condition woo_action_select">
      <select class="select_field woo_call_condition_main condition_type woo_select_repeater" name="<?php echo esc_attr('woo_action_repeater['.$customization_count.'][woo_condition_type]'); ?>" multiple="multiple">
      </select>
    </div>
  </div>
  <!-- /*===========================================|| End Condition ||===========================================*/ -->
</div>
</div>