<?php

  /**
  * The field functions for setting page.
  *
  * @package    WTCW_Customization_For_Woocommerce
  * @subpackage WTCW_Customization_For_Woocommerce/admin
  * @author     CustOmizAtion for woocommerce <support@webbytemplate.com>
  */

  class WTCW_Customization_For_Woocommerce_Extra_Fields {

      /**
      * The ID of this plugin.
      *
      * @since    1.0.0
      * @access   private
      * @var      string    $plugin_name    The ID of this plugin.
      */
      private $plugin_name;

      /**
      * The version of this plugin.
      *
      * @since    1.0.0
      * @access   private
      * @var      string    $version    The current version of this plugin.
      */
      private $version;

      /**
      * Initialize the class and set its properties.
      *
      * @since    1.0.0
      * @param      string    $plugin_name       The name of this plugin.
      * @param      string    $version       The version of this plugin.
      */
      public function __construct( $plugin_name, $version ) {

        $this->plugin_name = $plugin_name;
        $this->version = $version;

      }

      /**
      * That function return repeater field.
      *
      * @since    1.0.0
      * @access   public
      */
      
      public function repeater_field( $field, $plugin_name, $version ){ 

        $customization_fields = new WTCW_Customization_For_Woocommerce_Fields( $plugin_name, $version );
        $customization_Settings = new WTCW_Customization_For_Woocommerce_Custom_Settings( $plugin_name, $version );
        $woo_action = $customization_Settings->wt_add_customization_action_settings();
        $name = ( isset( $field['name'] ) && ( !empty( $field['name'] ) ) ? $field['name'] : '' );
        $default = ( isset( $field['default'] ) && ( !empty( $field['default'] ) ) ? $field['default'] : '' );
        $class = ( isset( $field['class'] ) && ( !empty( $field['class'] ) ) ? $field['class'] : '' );
        $hook_arr = $customization_fields->get_value( 'woo_action_repeater', $default );

        $value = $editor_html = '';
        $woo_action_json = wp_json_encode($woo_action);

        ob_start();
        $args = array(
          'media_buttons' => true, 
          'textarea_name' => $field['name'].time(), 
          'textarea_rows' => get_option( 'default_post_edit_rows', 5 ),           
          'wpautop' => false, 
          'quicktags'=>true,
        );
        wp_editor( "", "woo_action_repeater_0",$args );  
        $editor_html = ob_get_clean();

        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-general-repeater-field.php';   
      }

      /**
      * That function return repeater field.
      *
      * @since    1.0.0
      * @access   public
      */
      public function custom_preview_field( $field, $plugin_name, $version ){  

        /*===========================================|| Start Select action ||===========================================*/

        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-preview-fields.php';   

        /*===========================================|| End Select action ||===========================================*/
      }
    }
