<?php
/*
Plugin Name: Customizable GDPR Cookie Consent Banner
Description: Attractive &  Customisable cookie consent banner!
Version: 1.0.0
Author: AppifyCommerce
Author URI: https://www.appifycommerce.com/
 */

// Include mfp-functions.php, use require_once to stop the script if mfp-functions.php is not found
require_once plugin_dir_path(__FILE__) . 'includes/rcc-functions.php';
require_once plugin_dir_path(__FILE__) . 'includes/rcc-controller.php';

register_activation_hook(__FILE__, 'acwp_rcc_activation');
register_uninstall_hook(__FILE__, 'acwp_rcc_uninstall');

$plugin = plugin_basename(__FILE__);
add_filter("plugin_action_links_$plugin", 'acwp_rcc_plugin_settings_link');

function acwp_rcc_plugin_settings_link($links) {
    $settings_link = '<a href="admin.php?page=rcc">Settings</a>';
    array_unshift($links, $settings_link);
    return $links;
}

function acwp_rcc_activation() {
    acwp_rcc_initRccTable();
    acwp_rcc_insertRccData();
    acwp_rcc_installMail();
}

function acwp_rcc_uninstall() {
    acwp_rcc_uninstallMail();
    acwp_rcc_removeRccTable();
}

function acwp_rcc_removeRccTable() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ac_rcc';

    $sql = "DROP TABLE IF EXISTS `$table_name`";

    $wpdb->get_results($sql);
}

function acwp_rcc_uninstallMail() {
    $adminemail = get_bloginfo('admin_email');
    $siteurl = get_site_url();
    $apiUrl = 'https://rccwp.appifycommerce.com/uninstall';

    $account = acwp_rcc_getRccAccount();
    $body = [
        'account_id' => (int) $account["account_id"],
        'site_url' => $siteurl,
        'admin_email' => $adminemail,
        'user_name' => get_bloginfo('name'),
    ];

    $body = wp_json_encode($body);

    $options = [
        'body' => $body,
        'headers' => [
            'Content-Type' => 'application/json',
        ],
        'timeout' => 60,
        'redirection' => 5,
        'blocking' => true,
        'httpversion' => '1.0',
        'sslverify' => false,
        'data_format' => 'body',
    ];

    $response = wp_remote_post($apiUrl, $options);
    $response_code = wp_remote_retrieve_response_message($response);

    if ($response_code === 'OK') {
        $response_body = json_decode(wp_remote_retrieve_body($response), true);
        if (isset($response_body['account'])) {
            $account_id = $response_body['account'];
        }
    }
}

function acwp_rcc_installMail() {
    $adminemail = get_bloginfo('admin_email');
    $siteurl = get_site_url();

    $account = acwp_rcc_getRccAccount();
    $apiUrl = 'https://rccwp.appifycommerce.com/install/';

    $body = [
        'account_id' => (int) $account["account_id"],
        'site_url' => $siteurl,
        'admin_email' => $adminemail,
        'user_name' => get_bloginfo('name'),
        'state' => filter_var($account["state"], FILTER_VALIDATE_BOOLEAN),
        'app_version' => 1,
        'plan_id' => "",
        'subscription_id' => "",
        'payment_date' => "",
        "next_billing_date" => "",
    ];

    $body = wp_json_encode($body);

    $options = [
        'body' => $body,
        'headers' => [
            'Content-Type' => 'application/json',
        ],
        'timeout' => 60,
        'redirection' => 5,
        'blocking' => true,
        'httpversion' => '1.0',
        'sslverify' => false,
        'data_format' => 'body',
    ];

    $response = wp_remote_post($apiUrl, $options);
    $response_code = wp_remote_retrieve_response_message($response);

    if ($response_code === 'OK') {
        $response_body = json_decode(wp_remote_retrieve_body($response), true);
        if (isset($response_body['account'])) {
            $account_id = $response_body['account'];
        }
    }
}

function acwp_rcc_initRccTable() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ac_rcc';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "
    CREATE TABLE IF NOT EXISTS `$table_name` (
        `preference_id` INT(10) NOT NULL AUTO_INCREMENT,
        `account_id`    VARCHAR(255) NOT NULL,
        `state`         smallint(5) NOT NULL,
		`created_time`  TIMESTAMP NOT NULL,
        `updated_time`  TIMESTAMP NOT NULL,
        PRIMARY KEY (`preference_id`)
    ) $charset_collate
    ";

    if (!function_exists('dbDelta')) {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    }

    dbDelta($sql);
}

function acwp_rcc_isRccTableExist() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ac_rcc';
    $table_exist = false;
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name) {
        $table_exist = true;
    }

    return $table_exist;
}

function acwp_rcc_getRccAccount() {
    global $wpdb;

    $table_name = $wpdb->prefix . 'ac_rcc';
    $account = null;
    $dbData = $wpdb->get_results("SELECT * FROM $table_name LIMIT 0, 1");

    if (isset($dbData[0])) {
        $account = [
            'account_id' => $dbData[0]->account_id,
            'state' => $dbData[0]->state,
            'options' => $dbData[0]->options,
        ];
    }

    return $account;
}

function acwp_rcc_insertRccData() {
    global $wpdb;

    $table_exist = acwp_rcc_isRccTableExist();
    $table_name = $wpdb->prefix . 'ac_rcc';
    $date = date("Y-m-d H:i:s");

    if (!$table_exist) {
        acwp_rcc_initRccTable();
    }

    $account = acwp_rcc_getRccAccount();

    if (!isset($account)) {
        $account = rand(1000000000, 9999999999);
        if ($account) {
            $wpdb->insert($table_name, [
                'account_id' => $account,
                'state' => true,
                'created_time' => $date,
                'updated_time' => $date,
            ]);
        }
    }
}

function acwp_rcc_addplugin_footer_notice() {
    acwp_rcc_insertRccData();

    $account = acwp_rcc_getRccAccount();

    if (isset($account['account_id']) && mb_strlen($account['account_id']) > 0 && isset($account['state']) && (boolean) $account['state'] === true) {
        echo "<script>
              (function(e){
                  var el = document.createElement('script');
				  el.setAttribute('class', 'appify_rcc_js');
				  el.setAttribute('src', 'https://rccwp.appifycommerce.com/assets/" . $account['account_id'] . ".js?v=" . rand() . "');
                  document.body.appendChild(el);
                })();
              </script>";
    }
}

add_action('wp_footer', 'acwp_rcc_addplugin_footer_notice');
