<?php

// Hook the 'admin_menu' action hook, run the function named 'acwp_rcc_Add_My_Admin_Link()'
add_action('admin_menu', 'acwp_rcc_Add_My_Admin_Link');
// Add a new top level menu link to the ACP
function acwp_rcc_Add_My_Admin_Link() {
    add_menu_page(
        'Cookie Consent', // Title of the page
        'Cookie Consent', // Text to show on the menu link
        'manage_options', // Capability requirement to see the link
        'rcc', // The 'slug' - file to display when clicking the link
        'acwp_rcc_admin', // function to call when the link is clicked
        'dashicons-privacy' // Icon of admin link
    );
}

function acwp_rcc_admin() {
    $account = acwp_rcc_getRccAccount();
    $widgetUrl = "https://rccwp.appifycommerce.com/?account_id=" . $account['account_id'] . "&v=" . rand();
    $nonceCode = wp_create_nonce('wp_rest');
    acwp_rcc_insertRccData();
    ?>
     <div>
        <iframe
                id="rcc-frame"
                src="<?php esc_html_e($widgetUrl, 'text-domain');?>"
                title="Cookie Consent - By AppifyCommerce"
                width="100%"
                style="border: none; min-height:95vh"
        >
        </iframe>
        <script type="text/javascript">
            const MESSAGE_ACTION_TOGGLE = 'WIDGET_TOGGLE';
            const MESSAGE_ACTION_SIGNUP = "WIDGET_SIGNUP";
            const MESSAGE_ACTION_SIGNIN = "WIDGET_SIGNIN";
            const MESSAGE_ACTION_OPTIONS = "WIDGET_OPTIONS";
            const siteUrl = '<?php get_site_url();?>';

            const request = (data) => {
                return jQuery.when(
                    jQuery.ajax({
                        url: `${siteUrl}/index.php?rest_route=/rcc/v1/save`,
                        type: 'POST',
                        contentType: 'application/json',
                        dataType: 'json',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('X-WP-Nonce', '<?php echo $nonceCode; ?>');
                        },
                        data: JSON.stringify(data),
                    })
                )
            };

            const isPostMessageValid = (postMessage) => {
                return postMessage.data !== undefined
                    && postMessage.data.action
                    && postMessage.data.account !== undefined
                    && postMessage.data.state !== undefined
                    && [MESSAGE_ACTION_TOGGLE, MESSAGE_ACTION_SIGNUP, MESSAGE_ACTION_SIGNIN,MESSAGE_ACTION_OPTIONS].includes(postMessage.data.action)
            }

            jQuery(document).ready(function () {
                const selector = document.getElementById('rcc-frame');
                const frameContentWindow = selector.contentWindow;
                const {url} = selector.dataset;
                window.addEventListener('message', postMessage => {
                    if (postMessage.source !== frameContentWindow || !isPostMessageValid(postMessage)) {
                        return;
                    }
                    request({
                        account:postMessage.data.account,
                        state: postMessage.data.state,
                    }).then(res => {});

                });
            });
        </script>
    </div>
    <?php
}
