<?php
if (!defined('ABSPATH')) {
    exit;
}

function dmtf_enqueue_scripts() {
    // Get plugin version from main plugin file
    $plugin_data = get_file_data(plugin_dir_path(__FILE__) . '../customizable-dark-mode-toggle.php', array('Version' => 'Version'));
    $version = $plugin_data['Version'] ? $plugin_data['Version'] : '1.0.0';
    
    wp_enqueue_style('dmtf-style', plugin_dir_url(__FILE__) . '../assets/dmtf-style.css', array(), $version);
    wp_enqueue_script('dmtf-script', plugin_dir_url(__FILE__) . '../assets/dmtf-script.js', array('jquery'), $version, true);
    $settings = array(
        'dark_bg_color' => get_option('dmtf_dark_bg_color', '#222222'),
        'dark_text_color' => get_option('dmtf_dark_text_color', '#ffffff'),
        'toggle_button_bg' => get_option('dmtf_toggle_button_bg', '#444444'),
        'toggle_button_text' => get_option('dmtf_toggle_button_text', '#ffffff'),
        'custom_css' => get_option('dmtf_custom_css', ''),
    );
    wp_localize_script('dmtf-script', 'dmtfSettings', $settings);
}
add_action('wp_enqueue_scripts', 'dmtf_enqueue_scripts');

function dmtf_toggle_button() {
    $toggle_label = __('Toggle dark mode', 'customizable-dark-mode-toggle');
    
    echo '<div id="dmtf-toggle-wrapper" style="position: fixed; bottom: 30px; right: 30px; z-index: 9999;">
        <div id="dmtf-toggle" class="dmtf-dark-mode-switch" tabindex="0" aria-label="' . esc_attr($toggle_label) . '" style="cursor: pointer; user-select: none;">
            <div class="dmtf-switch-styled" style="position: relative; width: 48px; height: 24px; background: #000000; border-radius: 12px; transition: all 0.3s ease; box-shadow: 0 2px 8px rgba(0,0,0,0.2);">
                <div class="dmtf-switch-thumb" style="position: absolute; left: 2px; top: 2px; width: 20px; height: 20px; background: #ffffff; border-radius: 50%; transition: transform 0.3s ease; transform: translateX(0); box-shadow: 0 2px 4px rgba(0,0,0,0.2); display: flex; align-items: center; justify-content: center;">
                    <div class="dmtf-icon dmtf-sun-icon" style="color: #ff8c00; transition: all 0.3s ease; display: flex; align-items: center; justify-content: center; width: 12px; height: 12px;">
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="width: 12px; height: 12px;">
                            <circle cx="12" cy="12" r="5" fill="currentColor"/>
                            <path d="M12 1v2M12 21v2M4.22 4.22l1.42 1.42M18.36 18.36l1.42 1.42M1 12h2M21 12h2M4.22 19.78l1.42-1.42M18.36 5.64l1.42-1.42" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>';
}
add_action('wp_footer', 'dmtf_toggle_button'); 