import { __ } from '@wordpress/i18n';
import { registerBlockType } from '@wordpress/blocks';

/**
 * Internal dependencies
 */
import json from './block.json';
import Editor from './edit';
import save from './save';

// Destructure the json file to get the name of the block
// For more information on how this works, see: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment
const { name, description } = json;

// Register the block
registerBlockType(
	name, {
		description: __( description, 'customer-reviews-woocommerce' ),
		edit ( props ) {
			return <Editor { ...props } />;
		},
		save, // Object shorthand property - same as writing: save: save,
	}
);
