<div class="wrap">
	<div style="display: flex; justify-content: space-between; align-items: center;">
		<h3>Customer List Export for Woocommerce</h3>
		<a href="<?php echo e(admin_url()); ?>admin.php?page=customer-list-export&source=<?php echo e($source); ?>&a=export" class="button button-primary button-large">Export to CSV</a>
	</div>
	<p>This plugin pulls all orders from WooCommerce and then builds out the meta data to create the customer list. The filter works by either creating a hash of the billing or shipping last name and address (address_1 and city) and then removing any duplicates.</p>
	<p>Created by <a href="https://nickstewart.me/" target="_blank">Nick Stewart</a></p>
	<hr />
	<ul class="subsubsub">
		<li>Filter By:</li>
		<li><a href="<?php echo e(admin_url()); ?>admin.php?page=customer-list-export&source=billing">Billing</a></li>
		<li><a href="<?php echo e(admin_url()); ?>admin.php?page=customer-list-export&source=shipping">Shipping</a></li>
	</ul>
	<p style="clear: both;"><strong><?php echo e(count($customers)); ?></strong> results, using <?php echo e($source); ?> information.</p>
	<table class="wp-list-table widefat fixed striped table-view-list customer-list-export-table">
		<thead>
			<tr>
				<th scope="col" id="first_name" class="manage-column column-type" data-sortas="case-insensitive">First Name</th>
				<th scope="col" id="last_name" class="manage-column column-type" data-sortas="case-insensitive">Last Name</th>
				<th scope="col" id="email" class="manage-column column-type" data-sortas="case-insensitive">Email</th>
				<th scope="col" id="address_1" class="manage-column column-type" data-sortas="case-insensitive">Address 1</th>
				<th scope="col" id="address_2" class="manage-column column-type" data-sortas="case-insensitive">Address 2</th>
				<th scope="col" id="city" class="manage-column column-type" data-sortas="case-insensitive">City</th>
				<th scope="col" id="state" class="manage-column column-type" data-sortas="case-insensitive">State</th>
				<th scope="col" id="zip" class="manage-column column-type" data-sortas="numeric">ZIP</th>
				<th scope="col" id="subscription" class="manage-column column-type" data-sortas="case-insensitive">Subscription?</th>
			</tr>
		</thead>
		<tbody>
			<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
					<td><?php echo e($customer['first_name']); ?></td>
					<td><?php echo e($customer['last_name']); ?></td>
					<td><?php echo e($customer['email']); ?></td>
					<td><?php echo e($customer['address_1']); ?></td>
					<td><?php echo e($customer['address_2']); ?></td>
					<td><?php echo e($customer['city']); ?></td>
					<td><?php echo e($customer['state']); ?></td>
					<td><?php echo e($customer['zip']); ?></td>
					<td><?php echo e($customer['has_subscription']); ?></td>
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
</div><?php /**PATH /Users/nickstewart/projects/foxhollow.com/wp-content/plugins/customer-list-export-for-woocommerce/src/resources/pages/admin/main.blade.php ENDPATH**/ ?>