<?php

namespace CustomPriceDisplay;

use InvalidArgumentException;
class PriceConfig {
    protected $data = array(
        'price_display_format'                          => 'lowest',
        'price_suffix_prefix'                           => array(
            'prefix' => '',
            'suffix' => '',
        ),
        'custom_price_template'                         => '',
        'enable_for'                                    => 'all',
        'selected_products_categories'                  => array(
            'included_products'   => array(),
            'excluded_products'   => array(),
            'included_categories' => array(),
            'excluded_categories' => array(),
        ),
        'update_variable_price_when_variation_selected' => false,
        'hide_variation_price'                          => false,
    );

    /**
     * @var int
     */
    protected $productId;

    public function __construct( int $productId ) {
        $this->productId = $productId;
    }

    public function setProperty( $name, $value ) {
        if ( array_key_exists( $name, $this->data ) ) {
            $this->data[$name] = $value;
        } else {
            throw new InvalidArgumentException(esc_html__( 'Property $name does not exist in PriceConfig.', 'custom-price-display-for-woocommerce' ));
        }
    }

    public function getProperty( $name ) {
        if ( array_key_exists( $name, $this->data ) ) {
            return $this->data[$name];
        } else {
            throw new InvalidArgumentException(esc_html__( 'Property $name does not exist in PriceConfig.', 'custom-price-display-for-woocommerce' ));
        }
    }

    public function isActiveForProduct() : bool {
        return true;
    }

    public function getProductId() : int {
        return $this->productId;
    }

}
