const ITERATIONS=window.cryptxConfig?.iterations||1e5,KEY_LENGTH=window.cryptxConfig?.keyLength||32,IV_LENGTH=window.cryptxConfig?.ivLength||16,SALT_LENGTH=window.cryptxConfig?.saltLength||16,CONFIG={ALLOWED_PROTOCOLS:["http:","https:","mailto:"],MAX_URL_LENGTH:2048,ENCRYPTION_KEY_SIZE:32,IV_SIZE:16};class SecureUtils{static getSecureRandomBytes(e){if("undefined"==typeof crypto||!crypto.getRandomValues)throw new Error("Secure random number generation not available");return crypto.getRandomValues(new Uint8Array(e))}static arrayBufferToBase64(e){const r=new Uint8Array(e);let t="";for(let e=0;e<r.byteLength;e++)t+=String.fromCharCode(r[e]);return btoa(t)}static base64ToArrayBuffer(e){const r=atob(e),t=new ArrayBuffer(r.length),n=new Uint8Array(t);for(let e=0;e<r.length;e++)n[e]=r.charCodeAt(e);return t}static validateUrl(e){if("string"!=typeof e||0===e.length)return null;if(e.length>CONFIG.MAX_URL_LENGTH)return console.error("URL exceeds maximum length"),null;try{const r=new URL(e);if(!CONFIG.ALLOWED_PROTOCOLS.includes(r.protocol))return console.error("Protocol not allowed:",r.protocol),null;if("mailto:"===r.protocol){if(!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(r.pathname))return console.error("Invalid email format in mailto URL"),null}return e}catch(e){return console.error("Invalid URL format:",e.message),null}}static escapeJavaScript(e){return"string"!=typeof e?"":e.replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/"/g,'\\"').replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\t/g,"\\t")}}class LegacyEncryption{static originalDecrypt(e){if("string"!=typeof e||0===e.length)throw new Error("Invalid encrypted string");let r=0,t="mailto:",n=0;try{for(let a=0;a<e.length&&!(a+1>=e.length);a+=2){n=parseInt(e.charAt(a),10),isNaN(n)&&(n=0),r=e.charCodeAt(a+1),r>=8364&&(r=128);const o=r-n;if(o<0||o>1114111)throw new Error("Invalid character code during decryption");t+=String.fromCharCode(o)}return t}catch(e){throw new Error("Original decryption failed: "+e.message)}}static originalEncrypt(e){if("string"!=typeof e||0===e.length)throw new Error("Invalid input string");const r=e.replace(/^mailto:/,"");let t="";const n=["32","34","39","60","62","63","92","94","96","127"];try{for(let e=0;e<r.length;e++){let a,o,i=0;const c=20;do{if(i>=c){a=1,o=r.charCodeAt(e)+a;break}a=SecureUtils.getSecureRandomBytes(1)[0]%4,o=r.charCodeAt(e)+a,o>=8364&&(o=128),i++}while(n.includes(o.toString())&&i<c);t+=a.toString()+String.fromCharCode(o)}return t}catch(e){throw new Error("Original encryption failed: "+e.message)}}}class SecureEncryption{static async deriveKey(e,r){const t=new TextEncoder,n=await crypto.subtle.importKey("raw",t.encode(e),{name:"PBKDF2"},!1,["deriveKey"]);return crypto.subtle.deriveKey({name:"PBKDF2",salt:r,iterations:ITERATIONS,hash:"SHA-256"},n,{name:"AES-GCM",length:8*KEY_LENGTH},!1,["encrypt","decrypt"])}static async encrypt(e,r){if("string"!=typeof e||"string"!=typeof r)throw new Error("Both plaintext and password must be strings");const t=new TextEncoder,n=SecureUtils.getSecureRandomBytes(16),a=SecureUtils.getSecureRandomBytes(CONFIG.IV_SIZE),o=await this.deriveKey(r,n),i=await crypto.subtle.encrypt({name:"AES-GCM",iv:a},o,t.encode(e)),c=new Uint8Array(i),s=c.slice(0,-16),l=c.slice(-16),y=new Uint8Array(n.length+a.length+s.length+l.length);return y.set(n,0),y.set(a,n.length),y.set(s,n.length+a.length),y.set(l,n.length+a.length+s.length),SecureUtils.arrayBufferToBase64(y.buffer)}static async decrypt(e,r){if("string"!=typeof e||"string"!=typeof r)throw new Error("Both encryptedData and password must be strings");try{const t=SecureUtils.base64ToArrayBuffer(e),n=t.byteLength,a=16,o=16,i=16,c=n-a-o-i;if(n<a+o+i)throw new Error("Encrypted data too short");const s=t.slice(0,a),l=t.slice(a,a+o),y=t.slice(a+o,a+o+c),g=t.slice(-i),d=await this.deriveKey(r,new Uint8Array(s)),p=new Uint8Array(y.byteLength+g.byteLength);p.set(new Uint8Array(y),0),p.set(new Uint8Array(g),y.byteLength);const u=await crypto.subtle.decrypt({name:"AES-GCM",iv:new Uint8Array(l)},d,p);return(new TextDecoder).decode(u)}catch(e){throw new Error("Decryption failed: "+e.message)}}}async function secureDecryptAndNavigate(e,r="default_key"){if("string"==typeof e&&0!==e.length)try{let t;try{t=await SecureEncryption.decrypt(e,r)}catch(r){console.warn("Modern decryption failed, trying original algorithm"),t=LegacyEncryption.originalDecrypt(e)}const n=SecureUtils.validateUrl(t);if(!n)return void console.error("Invalid or unsafe URL detected");window.location.href=n}catch(e){console.error("Error during URL decryption and navigation:",e.message)}else console.error("Invalid encrypted URL provided")}function DeCryptString(e){try{return LegacyEncryption.originalDecrypt(e)}catch(e){return console.error("Legacy decryption failed:",e.message),null}}function DeCryptX(e){const r=DeCryptString(e);if(!r)return void console.error("Failed to decrypt URL");const t=SecureUtils.validateUrl(r);t?window.location.href=t:console.error("Invalid or unsafe URL detected")}async function generateSecureEmailLink(e,r="default_key"){if("string"!=typeof e||0===e.length)throw new Error("Valid email address required");if(!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(e))throw new Error("Invalid email format");const t=`mailto:${e}`,n=await SecureEncryption.encrypt(t,r);return`javascript:secureDecryptAndNavigate('${SecureUtils.escapeJavaScript(n)}', '${SecureUtils.escapeJavaScript(r)}')`}function generateDeCryptXHandler(e){if("string"!=typeof e||0===e.length)return console.error("Valid email address required"),"javascript:void(0)";try{const r=LegacyEncryption.originalEncrypt(e);return`javascript:DeCryptX('${SecureUtils.escapeJavaScript(r)}')`}catch(e){return console.error("Error generating handler:",e.message),"javascript:void(0)"}}function generateHashFromString(e){try{return LegacyEncryption.originalEncrypt(e)}catch(e){return console.error("Error generating hash:",e.message),""}}"undefined"!=typeof module&&module.exports&&(module.exports={secureDecryptAndNavigate:secureDecryptAndNavigate,generateSecureEmailLink:generateSecureEmailLink,DeCryptX:DeCryptX,DeCryptString:DeCryptString,generateDeCryptXHandler:generateDeCryptXHandler,generateHashFromString:generateHashFromString,SecureEncryption:SecureEncryption,LegacyEncryption:LegacyEncryption,SecureUtils:SecureUtils});