<?php
namespace PPCR;
if ( ! defined('ABSPATH') ) { exit; }

class Mailer {

    private static function coupon_card_html( $coupon_code ){
    // Logo del sitio (custom_logo → src), con fallback al site icon
    $logo_html = function_exists('get_custom_logo') ? get_custom_logo() : '';
    $logo_url  = '';
    if ( $logo_html && preg_match('/src\s*=\s*"([^"]+)"/i', $logo_html, $m) ) {
        $logo_url = $m[1];
    }
    if ( ! $logo_url && function_exists('get_site_icon_url') ) {
        $icon = get_site_icon_url(128);
        if ( $icon ) { $logo_url = $icon; }
    }
    $site_name = get_bloginfo('name');

    // Textos
    $title_text = __('Cupón de descuento', 'crosssell-mailer-post-purchase-coupon-rules-lite');
    $note_text  = __('Usa este código en el checkout', 'crosssell-mailer-post-purchase-coupon-rules-lite');

    // Normalización visual del código (solo presentación)
    $code_display = strtoupper( (string) $coupon_code );

    ob_start(); ?>
<!-- WRAPPER -->
<table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
  <tr>
    <td align="center" style="padding:12px;">
      <!-- TARJETA / TICKET -->
      <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0"
             style="max-width:640px;background:#ffffff;border:1px solid #e5e7eb;border-radius:14px;box-shadow:0 2px 6px rgba(15,23,42,.06);">
        <!-- BANDA SUPERIOR -->
        <tr>
          <td style="background:#0ea5e9;border-radius:14px 14px 0 0;padding:12px 20px;">
            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
              <tr>
                <td align="left" style="font:700 14px/1 -apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;color:#e0f2fe;text-transform:uppercase;letter-spacing:.8px;">
                  <?php echo esc_html($title_text); ?>
                </td>
                <td align="right">
                  <?php if ( $logo_url ) : ?>
                    <img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($site_name); ?>" width="28" height="28"
                         style="display:block;border:0;outline:none;text-decoration:none;border-radius:6px;max-width:28px;height:auto;" />
                  <?php endif; ?>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <!-- CUERPO -->
        <tr>
          <td align="center" style="padding:20px 24px 0 24px;">
            <?php if ( $logo_url ) : ?>
              <img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($site_name); ?>"
                   width="96" height="96"
                   style="display:block;border:0;outline:none;text-decoration:none;border-radius:10px;max-width:96px;height:auto;margin:0 auto 10px;" />
            <?php else : ?>
              <div style="font:600 15px/1.2 -apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;color:#334155;margin:0 0 10px;">
                <?php echo esc_html($site_name); ?>
              </div>
            <?php endif; ?>

            <div style="font:400 14px/1.5 -apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;color:#475569;margin:0 0 14px;">
              <?php echo esc_html($note_text); ?>
            </div>

            <!-- BADGE DEL CÓDIGO -->
            <div style="display:inline-block;padding:14px 18px;border:2px dashed #94a3b8;border-radius:12px;background:#f8fafc;">
              <code style="font:800 22px/1 ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,'Liberation Mono','Courier New',monospace;color:#0f2942;letter-spacing:2.5px;">
                <?php echo esc_html($code_display); ?>
              </code>
            </div>

            <div style="height:14px;line-height:14px;">&nbsp;</div>
          </td>
        </tr>

        <!-- SEPARADOR PERFORADO (simulado) -->
        <tr>
          <td style="padding:0 24px 0 24px;">
            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" border="0">
              <tr>
                <!-- “Mordiscos” laterales con círculos blancos -->
                <td width="14" align="left">
                  <div style="width:14px;height:14px;background:#ffffff;border:1px solid #e2e8f0;border-radius:50%;margin-left:-7px;"></div>
                </td>
                <td style="border-bottom:1px dashed #cbd5e1;height:1px;font-size:0;line-height:0;">&nbsp;</td>
                <td width="14" align="right">
                  <div style="width:14px;height:14px;background:#ffffff;border:1px solid #e2e8f0;border-radius:50%;margin-right:-7px;"></div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        
      </table>
    </td>
  </tr>
</table>
<?php
    return trim( ob_get_clean() );
}

private static function build_target_tokens( $product_ids ) : array {
    $ids   = array_map('absint', (array) $product_ids);
    $names = [];
    $links = [];

    foreach ( $ids as $pid ) {
        if ( ! $pid ) continue;
        $title = get_the_title( $pid );
        $url   = get_permalink( $pid );
        if ( $title && $url ) {
            $names[] = $title;
            $links[] = sprintf('<a href="%s" target="_blank">%s</a>', esc_url($url), esc_html($title));
        }
    }

    // Base (múltiples → separados por coma)
    $tokens_body = [
        '{{target_product_name}}' => esc_html( implode(', ', $names) ),
        '{{target_link}}'         => implode(', ', $links), // HTML permitido en body
        '{{target_list}}'         => $links ? '<ul><li>'.implode('</li><li>', $links).'</li></ul>' : '',
    ];

    // Variantes indexadas: {{target_product_name_1}}, {{target_link_1}}, etc.
    foreach ( $names as $i => $t ) {
        $n = (string) ($i + 1);
        $tokens_body[ '{{target_product_name_' . $n . '}}' ] = esc_html( $t );
        $tokens_body[ '{{target_link_' . $n . '}}' ]         = $links[$i]; // ya escapa URL y texto
    }

    // Para el asunto es mejor no meter HTML → solo nombres
    $tokens_subject = [
        '{{target_product_name}}' => esc_html( implode(', ', $names) ),
        '{{target_link}}'         => esc_html( implode(', ', $names) ), // fallback: nombres sin HTML
        '{{target_list}}'         => esc_html( implode(', ', $names) ),
    ];
    foreach ( $names as $i => $t ) {
        $n = (string) ($i + 1);
        $tokens_subject[ '{{target_product_name_' . $n . '}}' ] = esc_html( $t );
        $tokens_subject[ '{{target_link_' . $n . '}}' ]         = esc_html( $t );
    }

    return [ 'body' => $tokens_body, 'subject' => $tokens_subject ];
}


    public static function send_coupon_email( \WC_Order $order, array $r, string $coupon_code ){
        $settings = get_option( defined('PPCR_OPT_SETTINGS') ? PPCR_OPT_SETTINGS : 'ppcr_settings', [] );

        add_filter('wp_mail_from_name', function() use ( $settings ){
            return !empty($settings['from_name']) ? $settings['from_name'] : get_bloginfo('name');
        });
        add_filter('wp_mail_from', function() use ( $settings ){
            return !empty($settings['from_email']) ? $settings['from_email'] : get_bloginfo('admin_email');
        });

        $to = ( !empty($settings['test_mode']) && !empty($settings['test_recipient']) )
            ? $settings['test_recipient']
            : $order->get_billing_email();

        $countries = class_exists('\WC_Countries') ? new \WC_Countries() : null;
        $billing_country_code  = $order->get_billing_country();
        $shipping_country_code = $order->get_shipping_country();
        $billing_country_name  = ($countries && isset($countries->countries[$billing_country_code]))  ? $countries->countries[$billing_country_code]  : $billing_country_code;
        $shipping_country_name = ($countries && isset($countries->countries[$shipping_country_code])) ? $countries->countries[$shipping_country_code] : $shipping_country_code;

        $first = trim($order->get_billing_first_name());
        $last  = trim($order->get_billing_last_name());
        $full  = trim($first . ' ' . $last);

        // --- Tokens base ---
        $map = [
            '{{first_name}}'       => $first,
            '{{last_name}}'        => $last,
            '{{full_name}}'        => $full,
            '{{email}}'            => $order->get_billing_email(),
            '{{billing_phone}}'    => $order->get_billing_phone(),
            '{{billing_city}}'     => $order->get_billing_city(),
            '{{billing_country}}'  => $billing_country_name,
            '{{shipping_city}}'    => $order->get_shipping_city(),
            '{{shipping_country}}' => $shipping_country_name,
            '{{order_id}}'         => $order->get_id(),
            '{{coupon_code}}'      => $coupon_code,
            '{{discount_amount}}'  => isset($r['discount_amount']) ? $r['discount_amount'] : '',
            '{{discount_type}}'    => isset($r['discount_type']) ? $r['discount_type'] : '',
        ];

        // --- Añadir productos destino como enlaces (nombre + URL) ---
        $target_links = [];

        if ( ! empty( $r['target_products'] ) && is_array( $r['target_products'] ) ) {
            foreach ( $r['target_products'] as $pid ) {
                $title = get_the_title( $pid );
                $url   = get_permalink( $pid );
                if ( $title && $url ) {
                    // Cada producto → <a href="url">nombre</a>
                    $target_links[] = sprintf(
                        '<a href="%s" target="_blank">%s</a>',
                        esc_url( $url ),
                        esc_html( $title )
                    );
                }
            }
        }

        // Si hay productos destino, añade los tokens
        if ( ! empty( $target_links ) ) {
            // Todos los productos enlazados en línea (separados por coma)
            $map['{{target_link}}'] = implode( ', ', $target_links );

            // También por índice individual, por si quieres el primero, segundo, etc.
            foreach ( $target_links as $i => $html ) {
                $n = $i + 1;
                $map['{{target_link_' . $n . '}}'] = $html;
            }

            // Lista HTML opcional (ul/li)
            $map['{{target_list}}'] = '<ul><li>' . implode( '</li><li>', $target_links ) . '</li></ul>';
        }


        $subject   = strtr( isset($r['email_subject']) ? $r['email_subject'] : 'Your discount', $map );
        $body_html = nl2br( strtr( isset($r['email_body']) ? $r['email_body'] : 'Hi {{first_name}}, your code is {{coupon_code}}', $map ) );

        if ( ! empty($r['coupon_card']) ) {
            $body_html = $body_html . self::coupon_card_html( $coupon_code );
        }

        $headers = [ 'Content-Type: text/html; charset=UTF-8' ];

        $use_wc_tpl = ! empty($settings['use_wc_template']);
        if ( function_exists('WC') && WC() && $use_wc_tpl ) {
            $mailer = WC()->mailer();
            if ( method_exists($mailer, 'wrap_message') ) {
                $message = $mailer->wrap_message( wp_strip_all_tags($subject), $body_html );
                $mailer->send( $to, $subject, $message, $headers );
                return;
            }
        }

        wp_mail( $to, $subject, $body_html, $headers );
    }
}
