<?php
/**
 * Plugin Name: CrossSell Mailer - Post-Purchase Coupon Rules (Lite)
 * Plugin URI: https://sellmailer.com
* Description: Automate post-purchase coupon emails in WooCommerce and boost cross-selling. Lite version limited to 1 rule, 1 trigger product and 1 target product.
 * Version: 1.0.9
 * Author: Alvaro Alonso
 * Requires at least: 5.8
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * Text Domain: crosssell-mailer-post-purchase-coupon-rules-lite
 * Domain Path: /languages
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined('ABSPATH') ) { exit; }

/** Básicos */
define('PPCR_VER',  '1.0.8');
define('PPCR_SLUG', 'crosssell-mailer-post-purchase-coupon-rules-lite'); // slug propio del plugin

define('PPCR_OPT_RULES',    'ppcr_rules');
define('PPCR_OPT_SETTINGS', 'ppcr_settings');

add_action( 'init', function() {
    load_plugin_textdomain(
        'crosssell-mailer-post-purchase-coupon-rules-lite',
        false,
        dirname( plugin_basename( __FILE__ ) ) . '/languages'
    );
} );

/** Carga módulos cuando WooCommerce esté listo */
add_action('plugins_loaded', function() {
    if ( ! class_exists('WooCommerce') ) { return; }
    require_once __DIR__ . '/includes/options-page.php';
    require_once __DIR__ . '/includes/mailer.php';
    require_once __DIR__ . '/includes/engine.php';
}, 0);


/** Boot de hooks del motor */
add_action('plugins_loaded', function () {
    if ( class_exists('WooCommerce') && class_exists('\\PPCR\\Engine') ) {
        \PPCR\Engine::boot_hooks();
    }
}, 20);

/** Disparo tras “completed” (el motor gestiona el resto) */
add_action('woocommerce_order_status_completed', function($order_id){
    if ( class_exists('\\PPCR\\Rules_Engine') ) {
        \PPCR\Rules_Engine::maybe_apply_rules($order_id);
    }
}, 10, 1);

/** Cron limpieza */
register_activation_hook(__FILE__, function(){
    if ( ! wp_next_scheduled('ppcr_daily_cleanup') ) {
        wp_schedule_event(time() + HOUR_IN_SECONDS, 'daily', 'ppcr_daily_cleanup');
    }
});
register_deactivation_hook( __FILE__, function() {
    wp_clear_scheduled_hook( 'ppcr_daily_cleanup' );
} );

add_action('ppcr_daily_cleanup', function(){
    if ( class_exists('\\PPCR\\Rules_Engine') ) {
        \PPCR\Rules_Engine::cleanup_expired_coupons();
    }
});

/** Aviso Lite/upsell  */
add_action('admin_notices', function(){
    if ( ! function_exists('get_current_screen') ) return;
    $screen = get_current_screen();
    if ( ! $screen || strpos($screen->id, 'ppcr-options') === false ) return;

    echo '<div class="notice notice-warning" style="border-left-color:#0ea5e9">'
       . '<p style="display:flex;align-items:center;gap:10px;margin:0;">'
       . '<span style="display:inline-block;padding:2px 6px;background:#e0f2fe;color:#0369a1;border-radius:6px;font-weight:600;">Lite</span>'
       . '<strong>'.esc_html__('This is the Lite version: 1 rule, 1 trigger product and 1 target product.','crosssell-mailer-post-purchase-coupon-rules-lite').'</strong> '
       . esc_html__('Unlock unlimited rules and multiple products in the Pro version.','crosssell-mailer-post-purchase-coupon-rules-lite')
       . ' <a href="https://sellmailer.com" target="_blank" class="button button-primary" style="margin-left:8px;background:#0ea5e9;border-color:#0ea5e9;">'
       . esc_html__('Get Pro','crosssell-mailer-post-purchase-coupon-rules-lite')
       . '</a></p></div>';
});


/** Enlace “Get Pro” en lista de plugins */
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function($links){
    $links[] = '<a href="https://sellmailer.com" target="_blank" style="font-weight:600;color:#0ea5e9;">' . esc_html__('Get Pro','crosssell-mailer-post-purchase-coupon-rules-lite') . '</a>';
    return $links;
});
