jQuery(function($){
  'use strict';

  const ROOT = '#ppcr-rules';
  const LS_KEY = 'ppcr_collapsed';

  // --- Lite badge en el título ---
  function addLiteBadge(){
    var h1 = document.querySelector('.wrap h1');
    if (!h1) return;
    if (h1.querySelector('.ppcr-lite-badge')) return;

    var span = document.createElement('span');
    span.className = 'ppcr-lite-badge';
    span.textContent = 'Lite';
    h1.appendChild(span);
  }

  function ensureBulkToggles(){
    if (!$('#ppcr-collapse-all').length){
      $('<div class="ppcr-bulk-toggles"><a href="#" id="ppcr-collapse-all" class="button-link">Collapse all</a><a href="#" id="ppcr-expand-all" class="button-link">Expand all</a></div>').insertBefore(ROOT);
    }
  }

  function addToggle($rule){
    if ($rule.data('has-toggle')) return;
    var $btn = $('<button type="button" class="button-link ppcr-toggle-body" aria-expanded="true" title="Collapse/Expand"><span class="dashicons dashicons-arrow-up"></span></button>');
    $rule.find('.ppcr-rule__header').append($btn);
    $rule.data('has-toggle', true);
  }

  function ensureBodyWrapper($rule){
    if (!$rule.find('> .ppcr-body').length){
      var $grid  = $rule.find('> .ppcr-grid').first();
      var $email = $rule.find('> .ppcr-email').first();
      if ($grid.length){
        var $wrap = $('<div class="ppcr-body"></div>');
        $grid.before($wrap);
        $wrap.append($grid);
        if ($email.length){ $wrap.append($email); }
      }
    }
  }

  function addLiteNotesFor($scope, nameSuffix, noteHtml, dataKey){
    var sel = $scope.find('select[name$="' + nameSuffix + '"]');
    if (!sel.length) return;
    var container = sel.closest('p'); if (!container.length) return;
    var label = container.find('label').not('.ppcr-toggle').first(); if (!label.length) return;
    if (!label.data(dataKey)){
      label.append(noteHtml);
      label.data(dataKey, '1');
    }
  }

  function prepareRuleUI($rule){
    ensureBodyWrapper($rule);
    addToggle($rule);
    // Notas Lite con enlace a la versión Pro
    addLiteNotesFor(
      $rule,
      '[trigger_products][]',
      ' <small style="color:#64748b;">(Lite: 1 product. <a href="https://sellmailer.com" target="_blank">Pro</a> allows multiple)</small>',
      'ppcrNote'
    );
    addLiteNotesFor(
      $rule,
      '[target_products][]',
      ' <small style="color:#64748b;">(Lite: 1 target. <a href="https://sellmailer.com" target="_blank">Pro</a> allows multiple)</small>',
      'ppcrNote2'
    );
  }

  function prepareAll(){
    $(`${ROOT} .ppcr-rule`).each(function(){
      prepareRuleUI($(this));
    });
  }

  function saveState(){
    const s = [];
    $(`${ROOT} .ppcr-rule`).each(function(i){
      s[i] = $(this).hasClass('is-collapsed') ? 1 : 0;
    });
    try { localStorage.setItem(LS_KEY, JSON.stringify(s)); } catch(e){}
  }

  function restoreState(){
    try{
      var s = JSON.parse(localStorage.getItem(LS_KEY) || '[]');
      $(`${ROOT} .ppcr-rule`).each(function(i){
        var $r = $(this);
        if (s[i] === 1){
          $r.addClass('is-collapsed');
          $r.find('.ppcr-grid, .ppcr-email').hide();
          $r.find('.ppcr-toggle-body').attr('aria-expanded','false');
        }
      });
    }catch(e){}
  }

  function collapseAll(){
    $(`${ROOT} .ppcr-rule`).each(function(){
      var $r = $(this);
      if (!$r.hasClass('is-collapsed')){
        $r.addClass('is-collapsed');
        $r.find('.ppcr-grid, .ppcr-email').stop(true,true).slideUp(150);
        $r.find('.ppcr-toggle-body').attr('aria-expanded','false');
      }
    });
    saveState();
  }

  function expandAll(){
    $(`${ROOT} .ppcr-rule`).each(function(){
      var $r = $(this);
      if ($r.hasClass('is-collapsed')){
        $r.removeClass('is-collapsed');
        $r.find('.ppcr-grid, .ppcr-email').stop(true,true).slideDown(150);
        $r.find('.ppcr-toggle-body').attr('aria-expanded','true');
      }
    });
    saveState();
  }

  function reindexRules(){
    $(`${ROOT} .ppcr-rule`).each(function(i){
      $(this)
        .attr('data-index', i)
        .find('input, select, textarea').each(function(){
          const name = $(this).attr('name');
          if(!name) return;
          $(this).attr('name', name.replace(/\brules\[\d+\]/, `rules[${i}]`));
        });
    });
  }

  $(document).on('click', `${ROOT} .ppcr-remove, ${ROOT} .ppcr-delete, ${ROOT} .ppcr-delete-rule, ${ROOT} .button-delete, ${ROOT} [data-ppcr="delete"]`, function(e){
    e.preventDefault();
    e.stopPropagation();
    const $rule = $(this).closest('.ppcr-rule, tr, .ppcr-item');
    if(!$rule.length) return;
    $rule.slideUp(150, function(){
      $(this).remove();
      reindexRules();
      saveState();
      $(document).trigger('ppcr:rules-changed');
    });
  });

  $(document).on('click', `${ROOT} button[type="submit"].ppcr-delete-rule`, function(e){
    e.preventDefault();
  });

  $(document).on('click', '.ppcr-toggle-body', function(e){
    e.preventDefault();
    var $r = $(this).closest('.ppcr-rule');
    var expanded = $r.hasClass('is-collapsed');
    $r.toggleClass('is-collapsed');
    $(this).attr('aria-expanded', expanded ? 'true' : 'false');
    $r.find('.ppcr-grid, .ppcr-email').stop(true,true).slideToggle(150);
    saveState();
  });

  $(document).on('click', '#ppcr-collapse-all', function(e){
    e.preventDefault();
    collapseAll();
  });

  $(document).on('click', '#ppcr-expand-all', function(e){
    e.preventDefault();
    expandAll();
  });

  // ---- Lite “duro”: límite 1 selección por select de productos ----
  function enforceOne($sel){
    if (!$sel || !$sel.length) return;
    $sel.attr('data-maximum-selection-length','1');
    $sel.off('.ppcrOne').on('change.ppcrOne', function(){
      var v = $(this).val();
      if (Array.isArray(v) && v.length > 1) {
        var keep = v[v.length - 1];
        $(this).val([keep]).trigger('change.select2');
      }
    });
  }

  function applyLiteLimits($scope){
    $scope = $scope && $scope.length ? $scope : $(document);
    enforceOne($scope.find('select[name*="[trigger_products]"]'));
    enforceOne($scope.find('select[name*="[target_products]"]'));
  }

  // ---- Añadir regla desde template JSON ----
  function addRule(){
    const $wrap = $(ROOT);
    const idx   = $wrap.find('.ppcr-rule').length;

    if (idx >= 1) {
      return;
    }

    const tplEl = document.getElementById('ppcr-rule-template');
    if (!tplEl) { console.warn('PPCR: template not found'); return; }

    let html = tplEl.textContent || tplEl.innerHTML || '';
    try { html = JSON.parse(html); } catch(e) {}
    html = html.replace(/__INDEX__/g, String(idx));

    const $empty = $wrap.find('.ppcr-empty'); if ($empty.length) $empty.remove();
    $wrap.append(html);

    const $new = $wrap.find('.ppcr-rule').last();

    // SelectWoo para select de productos (AJAX)
    $(document.body).trigger('wc-enhanced-select-init');

    prepareRuleUI($new);
    applyLiteLimits($new);

    // Abrir nueva
    $new.removeClass('is-collapsed');
    $new.find('.ppcr-grid, .ppcr-email').show();
    $new.find('.ppcr-toggle-body').attr('aria-expanded','true');

    reindexRules();
    $(document).trigger('ppcr:rules-changed');

    // 👉 OCULTAR EL BOTÓN "Add rule" AL CREAR UNA
    $('#ppcr-add-rule').hide();
  }


  $(document).on('click', '#ppcr-add-rule', function(e){
    e.preventDefault();
    // botón se desactiva si ya hay 1, pero por seguridad comprobamos
    if ($('#ppcr-rules .ppcr-rule').length >= 1) return;
    addRule();
  });

  // ---- Marcas de filas anchas (opcional) ----
  function markWideRows(scope){
    const $scope = scope && scope.length ? scope : $(document);
    $scope.find('#ppcr-rules .ppcr-grid > p').each(function(){
      const $p = $(this);
      if ($p.find('.wc-product-search, [data-action="woocommerce_json_search_products_and_variations"]').length){
        $p.addClass('ppcr-wide');
      }
    });
    $scope.find('#ppcr-rules .ppcr-email-row').each(function(){
      $(this).closest('.ppcr-body, .ppcr-grid').find('> p').addClass('ppcr-wide');
    });
  }

  // ---- Insertar tokens en asunto/cuerpo ----
  (function(){
    function insertAtCursor($el, text){
      var el = $el[0]; if (!el) return;
      el.focus();
      if (typeof el.selectionStart === 'number' && typeof el.selectionEnd === 'number') {
        var start = el.selectionStart, end = el.selectionEnd;
        var value = el.value || '';
        el.value = value.substring(0,start) + text + value.substring(end);
        el.selectionStart = el.selectionEnd = start + text.length;
        if (el.tagName === 'TEXTAREA' && typeof el.scrollTop === 'number') el.scrollTop = el.scrollHeight;
      } else {
        el.value = (el.value || '') + text;
      }
      $el.trigger('input').trigger('change');
    }

    function findTargetField($btn){
      var $rule = $btn.closest('.ppcr-rule'); if (!$rule.length) return $();
      var $focus = $(document.activeElement);
      if ($focus.length && $rule.find($focus).length && /^(INPUT|TEXTAREA)$/i.test($focus[0].tagName)) return $focus;
      var $body = $rule.find('textarea[name$="[email_body]"]').first(); if ($body.length) return $body;
      var $subject = $rule.find('input[name$="[email_subject]"]').first(); if ($subject.length) return $subject;
      return $();
    }

    $(document).on('click', '.ppcr-tokenbar .ppcr-insert-token', function(e){
      e.preventDefault();
      var token = $(this).data('token') || '';
      if (!token) return;
      var $target = findTargetField($(this));
      if (!$target.length) return;
      insertAtCursor($target, token);
    });
  })();

  // ---- INIT ----
  addLiteBadge();
  ensureBulkToggles();
  prepareAll();
  $(document.body).trigger('wc-enhanced-select-init');
  applyLiteLimits($(document));
  markWideRows($(document));

  (function(){
    const saved = localStorage.getItem(LS_KEY);
    const hasRules = $('#ppcr-rules .ppcr-rule').length > 0;
    if (saved && hasRules) {
      collapseAll();
      restoreState();
    } else {
      restoreState();
    }
  })();

  $(document).on('ppcr:rules-changed', function(){
    markWideRows($('#ppcr-rules .ppcr-rule').last());
  });

  // Seguridad adicional
  (function(){
    var root = document.getElementById('ppcr-rules');
    if (!root) return;
    const obs = new MutationObserver(function(){
    });
    obs.observe(root, { childList: true, subtree: false });
  })();

});
