import { __, sprintf } from '@wordpress/i18n'
import {
	PanelBody,
	PanelRow,
	ProgressBar,
	BaseControl, Flex, FlexItem, __experimentalSpacer as Spacer, Spinner, Notice
} from '@wordpress/components'
import { useState } from '@wordpress/element'
import { useSelect } from '@wordpress/data'
import { STORE_NAME as store } from '../store/constants'
import {featureLabels} from './Subscription'

export default function Usage () {

	const [isOpen, setIsOpen] = useState(true);

	const { usage, status } = useSelect((select) => {
		const {getUsage, getStatus} = select(store);
		return {
			usage: getUsage(),
			status: getStatus(),
		};
	}, []);

	/**
	 * È giusto che il pannello non venga mostrato fino a quando non ho lo status perché non so ancora se
	 * deve essere mostrato.
	 */
	if (!status) {
		return null;
	}

	const { settings, allowSubscription } = status;
	const { usage_limits } = settings;
	const { enabled: usage_limits_enabled } = usage_limits;

	const increasedUsageLimitMessage =
		allowSubscription ?
			__('For a short time only, plans limits will be much higher... take advantage of it!', 'creator-assistant') :
			__('For a short time only, the Lite plan limits are much higher... hurry up and try all the features!', 'creator-assistant');

	return (
		<PanelBody title={__('Usage', 'creator-assistant')} opened={isOpen} onToggle={(bool) => setIsOpen(bool)}>
			{!usage && <PanelRow>
				<Flex align="center" justify="center">
					<FlexItem>
						<Spacer marginTop={8}>
							<Spinner/>
						</Spacer>
					</FlexItem>
				</Flex>
			</PanelRow>}
			{usage && <>
				{!usage_limits_enabled && (
					<PanelRow>
						<Spacer marginBottom={4}>
							<Notice status={'info'} isDismissible={false}>{increasedUsageLimitMessage}</Notice>
						</Spacer>
					</PanelRow>
				)}
				{Object.keys(usage).map((key) => {
					if (!featureLabels[key]) {
						return null;
					}

					const usageValue = parseInt(usage[key]);
					if (isNaN(usageValue)) {
						return null;
					}

					return (
						<PanelRow key={key}>
							<BaseControl label={sprintf(featureLabels[key], `${usageValue}%`)}>
								<ProgressBar value={usageValue} className="creator-assistant--progress-bar"/>
							</BaseControl>
						</PanelRow>
					);
				})}
			</>}
		</PanelBody>
	)
}
