import { __ } from '@wordpress/i18n'
import {
	__experimentalSpacer as Spacer,
	Guide
} from '@wordpress/components'
import { useDispatch, useSelect } from '@wordpress/data'
import { STORE_NAME as store } from '../store/constants'
import aiWriterImage from '../images/ai-writer.png';
import summarizeImage from '../images/summarize.png';
import analyzeImage from '../images/analyze.png';
import pinToToolbarImage from '../images/pin-to-toolbar.png';
import pluginByOptionsImage from '../images/plugin-by-options.png';
import promptImage from '../images/prompt.png';

export default function Tutorial () {
	const {setDisplayTutorialModal} = useDispatch(store);
	const display = useSelect((select) => {
		const {getDisplayTutorialModal} = select(store);
		return getDisplayTutorialModal();
	}, []);

	const close = () => setDisplayTutorialModal(false);

	if ( ! display ) {
		return null;
	}

	return (
		<Guide
			className={'creator-assistant--tutorial'}
			onFinish={ close }
			pages={ [
				{
					image: <img src={aiWriterImage} />,
					content: <p>{__('Generate content quickly with the AI Writer block.', 'creator-assistant')}</p>,
				},
				{
					image: <img src={summarizeImage} />,
					content: <p>{__('Let Creator Assistant summarize your pages and posts efficiently.', 'creator-assistant')}</p>,
				},
				{
					image: <img src={analyzeImage} />,
					content: <p>{__('Ask Creator Assistant for improvements and suggestions to enhance your text.', 'creator-assistant')}</p>,
				},
				{
					image: <img src={pluginByOptionsImage} />,
					content: <p>{__('Access the Creator Assistant sidebar to manage all plugin settings.', 'creator-assistant')}</p>,
				},
				{
					image: <img src={pinToToolbarImage} />,
					content: <p>{__('Click the star to add Creator Assistant to your WordPress toolbar.', 'creator-assistant')}</p>,
				},
				{
					image: <img src={promptImage} />,
					content: <p>{__('Use the buttons in the editor to translate and enhance the text with predefined options, or create your own customized instructions!', 'creator-assistant')}</p>,
				},
			].map(page => {
				return {
					image: page.image,
					content: (<Spacer paddingX={10} paddingY={4}>{page.content}</Spacer>)
				}
			}) }
		 contentLabel={'content label'}/>
	)
}
