import { __ } from '@wordpress/i18n';
import {
	Button,
	TextareaControl, __experimentalDivider as Divider,
	__experimentalGrid as Grid
} from '@wordpress/components'
import { useSelect, useDispatch } from '@wordpress/data'
import { useState } from '@wordpress/element'
import { sendData, getBlocksData } from '../utils'
import {store as noticesStore} from '@wordpress/notices';
import icon from './Icon';

export default function Summarize() {
	const { getBlocks } = useSelect((select) => {
		const { getBlocks } = select('core/block-editor')
		return { getBlocks }
	}, [])
	const { editPost } = useDispatch('core/editor')
	const {createInfoNotice, createWarningNotice} = useDispatch(noticesStore);

	const [summary, setSummary] = useState('');
	const [display, setDisplay] = useState(false);
	const [isBusy, setIsBusy] = useState(false);

	return (
		<Grid columns={1} gap={2}>
			<Divider />
			<p>{__('Ask Creator Assistant to summarize the text and decide whether to use it. The summary can serve as a preview of the article on the homepage, search results, or archive pages, depending on the theme.', 'creator-assistant')}</p>
			<Button
				icon={icon}
				isBusy={isBusy}
				disabled={isBusy}
				variant={'secondary'}
				text={__('Summarize the content', 'creator-assistant')}
				onClick={async () => {
					const texts = getBlocksData(getBlocks()).map(block => block.text);
					const text = texts.join("\n").trim();

					if (text === '') {
						const message = __('No text to summarize', 'creator-assistant')
						await createWarningNotice(message, {
							type: 'snackbar',
						});

						return;
					}

					setIsBusy(true);
					setDisplay(false);

					const data = await sendData(true, '/summarize-text', {text});
					if (data) {
						setSummary(data.text);
					}
					setDisplay(true);
					setIsBusy(false);
				}}
			/>
			{display && <>
				<Divider />
				<TextareaControl
					rows={10}
					label={__('Creator Assistant recommends you this summary', 'creator-assistant')}
					value={ summary }
					onChange={ ( summary ) => setSummary( summary ) }
				/>
				<Button variant={'secondary'}
						text={__('Set as summary', 'creator-assistant')}
						onClick={async () => {
							setDisplay(false);
							editPost({excerpt: summary});
							await createInfoNotice(__('Summary has been updated.', 'creator-assistant'), {
								type: 'snackbar',
							});
						}}
				/>
			</>}
		</Grid>
	)
}
