import { __, sprintf } from '@wordpress/i18n'
import {
	__experimentalSpacer as Spacer,
	Button, Flex, FlexItem,
	PanelBody,
	PanelRow, Spinner,
} from '@wordpress/components'
import { useState } from '@wordpress/element'
import { useDispatch, useSelect } from '@wordpress/data'
import { STORE_NAME as store } from '../store/constants'
import { dateI18n, getSettings } from '@wordpress/date';
import {cog} from '@wordpress/icons';

export default function Status () {
	const {setDisplaySubscriptionModal, setDisplayTosModal, setDisplayTutorialModal} = useDispatch(store);

	const dateFormat = getSettings().formats.date;
	const timezone = getSettings().timezone.string;

	const [isOpen, setIsOpen] = useState(true);

	const { apiData, status } = useSelect((select) => {
		const {getApiData, getStatus} = select(store);
		return {
			apiData: getApiData(),
			status: getStatus(),
		};
	}, []);

	const StatusPanel = (props) => {
		return <PanelBody title={__('Account Summary', 'creator-assistant')} opened={isOpen} onToggle={(bool) => setIsOpen(bool)}>{props.children}</PanelBody>;
	};

	if (!status) {
		return (<StatusPanel>
			<PanelRow>
				<Flex align="center" justify="center">
					<FlexItem>
						<Spacer marginTop={8}>
							<Spinner/>
						</Spacer>
					</FlexItem>
				</Flex>
			</PanelRow>
		</StatusPanel>);
	}

	const { is_active } = apiData;
	const statusLabel = is_active ? __('Active', 'creator-assistant') : __('Inactive', 'creator-assistant');

	const {subscription, is_premium} = status;
	let planName = is_premium ? __( 'Pro', 'creator-assistant' ) : __( 'Lite', 'creator-assistant' );
	let subscriptionDate = '';
	if (is_premium) {
		const {automatic_renewal, current_period_end} = subscription;
		const dateLabel   = automatic_renewal ? __( 'will be renewed on %s', 'creator-assistant' ) : __( 'expires on %s', 'creator-assistant' );
		subscriptionDate = '(' +
		sprintf(
			dateLabel,
			dateI18n(dateFormat, new Date(current_period_end * 1000), timezone)
		) + ')';
	}

	return (
		<StatusPanel>
			<PanelRow>
				<ul>
					<li>
						<strong>{__('Status', 'creator-assistant')}:</strong> {statusLabel}
					</li>
					<li>
						<strong>{__('Plan', 'creator-assistant')}:</strong> {planName} {subscriptionDate}
					</li>
				</ul>
			</PanelRow>
			<PanelRow>
				<Button variant="primary" onClick={() => setDisplaySubscriptionModal(true)} icon={cog}>
					{__('Manage Subscription', 'creator-assistant')}
				</Button>
			</PanelRow>
			<PanelRow>
				<Button variant="tertiary" onClick={() => setDisplayTutorialModal(true)}>
					{__('Tutorial', 'creator-assistant')}
				</Button>
				<Button variant="tertiary" onClick={() => setDisplayTosModal(true)}>
					{__('Terms of Service', 'creator-assistant')}
				</Button>
			</PanelRow>
		</StatusPanel>
	)
}
