import { __ } from '@wordpress/i18n'
import { PluginSidebar, PluginPostStatusInfo, PluginDocumentSettingPanel } from '@wordpress/edit-post'
import {
	Flex,
	FlexItem,
	Panel, Spinner,
	__experimentalSpacer as Spacer
} from '@wordpress/components'
import icon from './Icon'
import { registerPlugin } from '@wordpress/plugins'
import Summarize from './Summarize'
import Analyze from './Analyze'
import { useDispatch, useSelect } from '@wordpress/data'
import { STORE_NAME as store } from '../store/constants'
import Activation from './Activation'
import { useEffect } from '@wordpress/element'
import TosModal from './TosModal'
import Tutorial from './Tutorial'
import Status from './Status'
import Subscription from './Subscription'
import Usage from './Usage'

function CreatorAssistantPluginSidebar () {
	const apiData = useSelect((select) => {
		const {getApiData} = select(store);
		return getApiData();
	}, []);
	const { is_active } = apiData;

	const {fetchApiData, fetchStatus, setDisplayTosModal} = useDispatch(store);
	const ready = is_active !== undefined;
	useEffect(() => {
		if (is_active === undefined) {
			fetchApiData();
		} else if (is_active) {
			fetchStatus();
		}
		setDisplayTosModal(is_active === false);
	}, [is_active])

	return (
		<>
			<PluginSidebar
				name="creator-assistant-plugin-sidebar"
				className={'creator-assistant--plugin-sidebar'}
				title={__('Creator Assistant', 'creator-assistant')}
				icon={icon}
			>
				<Panel>
					{!ready && <>
						<Flex align="center" justify="center">
							<FlexItem>
								<Spacer marginTop={8}>
									<Spinner/>
								</Spacer>
							</FlexItem>
						</Flex>
					</>}
					{ready && <>
						{is_active && <>
							<Status/>
							<Usage/>
						</>}
						{!is_active && <>
							<Activation />
						</>}
					</>}
				</Panel>
			</PluginSidebar>
			{is_active && <>
				<PluginPostStatusInfo>
					<Summarize/>
				</PluginPostStatusInfo>
				<PluginDocumentSettingPanel
					name="creator-assistant-panel-analyze"
					className={'creator-assistant--plugin-document-setting-panel'}
					title={__('Analyze', 'creator-assistant')}
					icon={icon}
				>
					<Analyze/>
				</PluginDocumentSettingPanel>
			</>}
			<TosModal/>
			<Tutorial/>
			<Subscription/>
		</>

	)
}

export default () => {
	registerPlugin('creator-assistant', {
		render: () => {
			return (
				<CreatorAssistantPluginSidebar/>
			)
		},
	})
};


