import { useState, useEffect } from '@wordpress/element'
import { __ } from '@wordpress/i18n'

const phrases = [
	__('I\'m putting together words like a puzzle... almost there!', 'creator-assistant'),
	__('The letters are stretching, ready to start!', 'creator-assistant'),
	__('Attention: words are in training mode!', 'creator-assistant'),
	__('Mixing up a cocktail of phrases... almost served!', 'creator-assistant'),
	__('Preparing the secret sauce of content... adding the final touch!', 'creator-assistant'),
	__('Ideas are coming out of the oven... just a few more minutes!', 'creator-assistant'),
	__('Taming the wild words... almost under control!', 'creator-assistant'),
	__('Words are running a marathon, we\'re in the final sprint!', 'creator-assistant'),
	__('The phrases are racing... almost there!', 'creator-assistant'),
	__('Convincing the ideas to line up... almost ready!', 'creator-assistant'),
	__('Looking for the perfect words... just a moment!', 'creator-assistant'),
	__('The phrases are on a coffee break, but they’ll be back soon!', 'creator-assistant'),
	__('The ideas are brainstorming... not much longer!', 'creator-assistant'),
	__('I\'m crafting the text with artisan care... just a moment!', 'creator-assistant'),
	__('Thoughts are doing mental stretching... almost ready!', 'creator-assistant'),
	__('Pairing up phrases like a dance!', 'creator-assistant'),
	__('Ideas are dancing together... just a few more steps!', 'creator-assistant'),
	__('Playing word Tetris... almost done!', 'creator-assistant'),
	__('Phrases are coming out of the factory... ready for launch!', 'creator-assistant'),
	__('Ideas are in the spin cycle... ready to explode!', 'creator-assistant'),
	__('The words are going through customs... imminent arrival!', 'creator-assistant'),
	__('Polishing the phrases... they’re almost shining!', 'creator-assistant'),
	__('Letters are preparing a surprise... just a moment longer!', 'creator-assistant'),
	__('The ideas are about to cross the finish line!', 'creator-assistant'),
	__('Preparing a text surprise... almost finished!', 'creator-assistant'),
	__('Words are bouncing here and there... almost in order!', 'creator-assistant'),
	__('Phrases are getting dressed up... arrival imminent!', 'creator-assistant'),
	__('Herding ideas like a shepherd with sheep!', 'creator-assistant'),
	__('Words are warming up... almost ready for action!', 'creator-assistant'),
	__('Ideas are competing in a high jump... the finish line is near!', 'creator-assistant'),
	__('Putting order in the chaos of ideas... just a moment longer!', 'creator-assistant'),
	__('The letters are warming up the engines... get ready!', 'creator-assistant'),
	__('Cooking the phrases slowly... almost ready!', 'creator-assistant'),
	__('Ideas are doing yoga... relax, we’re almost there!', 'creator-assistant'),
	__('Composing a symphony of words... the final chords!', 'creator-assistant'),
	__('Phrases are lining up to come out... just a little more!', 'creator-assistant'),
	__('Trying to match the right phrases... almost there!', 'creator-assistant'),
	__('The words are dancing the tango... ready to surprise you!', 'creator-assistant'),
	__('Ideas are swimming to the shore... almost there!', 'creator-assistant'),
	__('Phrases are fixing their hair... just a few seconds left!', 'creator-assistant'),
	__('Searching for the final inspiration... just a moment and it’ll be ready!', 'creator-assistant'),
	__('Words are navigating a maze... almost at the finish line!', 'creator-assistant'),
	__('Ideas are doing artistic gymnastics... almost ready!', 'creator-assistant'),
	__('Assembling the final pieces... we\'re almost there!', 'creator-assistant'),
	__('The phrases are packing their bags... ready to come out!', 'creator-assistant'),
	__('The words are posing for the final photo... almost ready!', 'creator-assistant'),
	__('Adding the final touches to the content... just a little more patience!', 'creator-assistant'),
	__('Ideas are stretching... almost ready for action!', 'creator-assistant'),
	__('Phrases are checking their look... ready to shine!', 'creator-assistant'),
	__('Polishing the words... ready to be presented!', 'creator-assistant'),
	__('Letters are doing the final rehearsals... we’re almost there!', 'creator-assistant'),
	__('The phrases are debating among themselves... the final decision is close!', 'creator-assistant'),
	__('Tuning the ideas... just a little longer!', 'creator-assistant'),
	__('Words are adding the final touch of make-up... ready to go!', 'creator-assistant'),
	__('Ideas are finding their right place... we\'re in the final stretch!', 'creator-assistant'),
	__('The phrases are running towards the finish line... almost there!', 'creator-assistant'),
	__('Adjusting the last phrases... get ready to read!', 'creator-assistant'),
	__('Ideas are aligning... we\'re almost there!', 'creator-assistant'),
	__('Words are running a marathon... in the final sprint!', 'creator-assistant'),
	__('Trying to convince the phrases to cooperate... just a little longer!', 'creator-assistant'),
	__('Ideas are finding the best path... we’re almost there!', 'creator-assistant'),
	__('Words are solving a puzzle... arrival imminent!', 'creator-assistant'),
	__('Looking for the last piece of the puzzle... almost complete!', 'creator-assistant'),
	__('Phrases are collaborating for the final result... just a few seconds left!', 'creator-assistant'),
	__('Ideas are doing mental stretching... ready to explode!', 'creator-assistant'),
	__('Words are putting on their party dress... arrival imminent!', 'creator-assistant'),
	__('Arranging the last details... we’re almost there!', 'creator-assistant'),
	__('Ideas are doing gymnastics... almost in order!', 'creator-assistant'),
	__('Phrases are coming out of the factory... ready to amaze you!', 'creator-assistant'),
	__('Words are navigating the maze of ideas... almost there!', 'creator-assistant'),
	__('Trying to fit the phrases together like pieces of a mosaic... just a moment!', 'creator-assistant'),
	__('Ideas are gaining momentum... get ready for the final leap!', 'creator-assistant'),
	__('Phrases are passing the last checkpoint... imminent arrival!', 'creator-assistant'),
	__('Adding the final brushstrokes to the painting... almost finished!', 'creator-assistant'),
	__('Words are debating their order... we’re almost there!', 'creator-assistant'),
	__('Ideas are lining up to enter... ready for launch!', 'creator-assistant'),
	__('Phrases are going through customs... imminent arrival!', 'creator-assistant'),
	__('Trying to tame rebellious words... almost ready!', 'creator-assistant'),
	__('Ideas are doing a final rehearsal... imminent arrival!', 'creator-assistant'),
	__('Phrases are completing the last curve... arrival near!', 'creator-assistant'),
	__('Words are syncing up... imminent arrival!', 'creator-assistant'),
	__('Completing the final lap... almost there!', 'creator-assistant'),
	__('Ideas are getting their shoes ready... ready for takeoff!', 'creator-assistant'),
	__('Phrases are stretching... ready to shine!', 'creator-assistant'),
	__('Smoothing out the last edges... we’re there!', 'creator-assistant'),
	__('Words are racing... almost arrived!', 'creator-assistant'),
	__('Ideas are organizing their thoughts... almost there!', 'creator-assistant'),
	__('Phrases are solving the last puzzle... we\'re on the last step!', 'creator-assistant'),
	__('Words are bouncing around... almost in order!', 'creator-assistant'),
	__('Putting together the last piece of the puzzle... we’re there!', 'creator-assistant'),
	__('Ideas are taking flight... imminent arrival!', 'creator-assistant'),
	__('Phrases are racing... we\'re in the final stretch!', 'creator-assistant'),
	__('Words are rehearsing their entrance... just a little longer!', 'creator-assistant'),
	__('Trying to organize the ideas... just a bit more patience!', 'creator-assistant'),
	__('Phrases are warming up the engines... ready for launch!', 'creator-assistant'),
	__('Ideas are passing through the final phase... imminent arrival!', 'creator-assistant'),
	__('Finalizing the last details... just a few seconds left!', 'creator-assistant'),
	__('Phrases are stretching... ready for action!', 'creator-assistant')
];

const getRandomPhraseIndex = (max) => Math.floor(Math.random() * max);

const PhraseRotator = () => {
	const [currentPhraseIndex, setCurrentPhraseIndex] = useState(getRandomPhraseIndex(phrases.length));

	useEffect(() => {
		const intervalId = setInterval(() => {
			setCurrentPhraseIndex(getRandomPhraseIndex(phrases.length));
		}, 4000); // Cambia ogni 4 secondi

		return () => clearInterval(intervalId); // Pulisce l'intervallo quando il componente si smonta
	}, []);

	return (
		<div style={{fontSize: 'max(0.7em, 12px)'}}>{phrases[currentPhraseIndex]}</div>
	);
};

export default PhraseRotator;
