/**
 * Collection https://www.svgrepo.com/collection/denali-line-interface-icons/
 * Vectors and icons by <a href="https://github.com/denali-design/denali-icons?ref=svgrepo.com" target="_blank">Denali Design</a> in MIT License via <a href="https://www.svgrepo.com/" target="_blank">SVG Repo</a>
 * https://www.svgrepo.com/svg/445500/ai
 */
export default (
    <svg width="24" height="24" viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg">
        <g id="Layer_2" data-name="Layer 2">
            <g id="invisible_box" data-name="invisible box">
                <rect width="48" height="48" fill="none"/>
            </g>
            <g id="Q3_icons" data-name="Q3 icons">
                <g>
                    <path d="M45.6,18.7,41,14.9V7.5a1,1,0,0,0-.6-.9L30.5,2.1h-.4l-.6.2L24,5.9,18.5,2.2,17.9,2h-.4L7.6,6.6a1,1,0,0,0-.6.9v7.4L2.4,18.7a.8.8,0,0,0-.4.8v9H2a.8.8,0,0,0,.4.8L7,33.1v7.4a1,1,0,0,0,.6.9l9.9,4.5h.4l.6-.2L24,42.1l5.5,3.7.6.2h.4l9.9-4.5a1,1,0,0,0,.6-.9V33.1l4.6-3.8a.8.8,0,0,0,.4-.7V19.4h0A.8.8,0,0,0,45.6,18.7Zm-5.1,6.8H42v1.6l-3.5,2.8-.4.3-.4-.2a1.4,1.4,0,0,0-2,.7,1.5,1.5,0,0,0,.6,2l.7.3h0v5.4l-6.6,3.1-4.2-2.8-.7-.5V25.5H27a1.5,1.5,0,0,0,0-3H25.5V9.7l.7-.5,4.2-2.8L37,9.5v5.4h0l-.7.3a1.5,1.5,0,0,0-.6,2,1.4,1.4,0,0,0,1.3.9l.7-.2.4-.2.4.3L42,20.9v1.6H40.5a1.5,1.5,0,0,0,0,3ZM21,25.5h1.5V38.3l-.7.5-4.2,2.8L11,38.5V33.1h0l.7-.3a1.5,1.5,0,0,0,.6-2,1.4,1.4,0,0,0-2-.7l-.4.2-.4-.3L6,27.1V25.5H7.5a1.5,1.5,0,0,0,0-3H6V20.9l3.5-2.8.4-.3.4.2.7.2a1.4,1.4,0,0,0,1.3-.9,1.5,1.5,0,0,0-.6-2L11,15h0V9.5l6.6-3.1,4.2,2.8.7.5V22.5H21a1.5,1.5,0,0,0,0,3Z"/>
                    <path d="M13.9,9.9a1.8,1.8,0,0,0,0,2.2l2.6,2.5v2.8l-4,4v5.2l4,4v2.8l-2.6,2.5a1.8,1.8,0,0,0,0,2.2,1.5,1.5,0,0,0,1.1.4,1.5,1.5,0,0,0,1.1-.4l3.4-3.5V29.4l-4-4V22.6l4-4V13.4L16.1,9.9A1.8,1.8,0,0,0,13.9,9.9Z"/>
                    <path d="M31.5,14.6l2.6-2.5a1.8,1.8,0,0,0,0-2.2,1.8,1.8,0,0,0-2.2,0l-3.4,3.5v5.2l4,4v2.8l-4,4v5.2l3.4,3.5a1.7,1.7,0,0,0,2.2,0,1.8,1.8,0,0,0,0-2.2l-2.6-2.5V30.6l4-4V21.4l-4-4Z"/>
                </g>
            </g>
        </g>
    </svg>
);

/**
 * Collection https://www.svgrepo.com/collection/denali-line-interface-icons/
 * Vectors and icons by <a href="https://github.com/denali-design/denali-icons?ref=svgrepo.com" target="_blank">Denali Design</a> in MIT License via <a href="https://www.svgrepo.com/" target="_blank">SVG Repo</a>
 * https://www.svgrepo.com/svg/445660/comment-text
 */
export const commentText = () => (
	<svg width="24" height="24" viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg">
		<g id="Layer_2" data-name="Layer 2">
			<g id="invisible_box" data-name="invisible box">
				<rect width="48" height="48" fill="none"/>
			</g>
			<g id="icons_Q2" data-name="icons Q2">
				<path
					d="M40,8V32H13.6l-1.2,1.1L8,37.3V8H40m2-4H6A2,2,0,0,0,4,6V42a2,2,0,0,0,2,2,2,2,0,0,0,1.4-.6L15.2,36H42a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2Z"/>
				<rect x="14" y="14" width="20" height="4" rx="2" ry="2"/>
				<rect x="14" y="22" width="12" height="4" rx="2" ry="2"/>
			</g>
		</g>
	</svg>
)

/**
 * Collection https://www.svgrepo.com/collection/denali-line-interface-icons/
 * Vectors and icons by <a href="https://github.com/denali-design/denali-icons?ref=svgrepo.com" target="_blank">Denali Design</a> in MIT License via <a href="https://www.svgrepo.com/" target="_blank">SVG Repo</a>
 * https://www.svgrepo.com/svg/445722/domain
 */
export const domain = () => (
	<svg width="24" height="24" viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg">
		<g id="Layer_2" data-name="Layer 2">
			<g id="invisible_box" data-name="invisible box">
				<rect width="48" height="48" fill="none"/>
			</g>
			<g id="icons_Q2" data-name="icons Q2">
				<path
					d="M24,2A22,22,0,1,0,46,24,21.9,21.9,0,0,0,24,2ZM40.1,16H35.2a27.8,27.8,0,0,0-3-8A18.5,18.5,0,0,1,40.1,16ZM42,24a17.5,17.5,0,0,1-.5,4H35.8c.1-1.3.2-2.6.2-4s-.1-2.7-.2-4h5.7A17.5,17.5,0,0,1,42,24ZM6,24a17.5,17.5,0,0,1,.5-4h5.7c-.1,1.3-.2,2.6-.2,4s.1,2.7.2,4H6.5A17.5,17.5,0,0,1,6,24Zm10,0c0-1.4.1-2.7.2-4H22v8H16.2C16.1,26.7,16,25.4,16,24ZM26,6.7a11.7,11.7,0,0,1,3,3.7A21.7,21.7,0,0,1,31.1,16H26Zm-4,0V16H16.9A21.7,21.7,0,0,1,19,10.4,11.7,11.7,0,0,1,22,6.7ZM22,32v9.3a11.7,11.7,0,0,1-3-3.7A21.7,21.7,0,0,1,16.9,32Zm4,9.3V32h5.1A21.7,21.7,0,0,1,29,37.6,11.7,11.7,0,0,1,26,41.3ZM26,28V20h5.8c.1,1.3.2,2.6.2,4s-.1,2.7-.2,4ZM15.8,8a27.8,27.8,0,0,0-3,8H7.9A18.5,18.5,0,0,1,15.8,8ZM7.9,32h4.9a27.8,27.8,0,0,0,3,8A18.5,18.5,0,0,1,7.9,32Zm24.3,8a27.8,27.8,0,0,0,3-8h4.9A18.5,18.5,0,0,1,32.2,40Z"/>
			</g>
		</g>
	</svg>
)

/**
 * <a href="https://www.svgbackgrounds.com/elements/animated-svg-preloaders/">Animated SVG Preloaders by SVGBackgrounds.com</a>
 */
export const loading = () => (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 200">
		<circle fill="#7D3C98" stroke="#7D3C98" stroke-width="15" r="15" cx="35" cy="100">
			<animate attributeName="cx" calcMode="spline" dur="2" values="35;165;165;35;35"
					 keySplines="0 .1 .5 1;0 .1 .5 1;0 .1 .5 1;0 .1 .5 1" repeatCount="indefinite" begin="0"></animate>
		</circle>
		<circle fill="#7D3C98" stroke="#7D3C98" stroke-width="15" opacity=".8" r="15" cx="35" cy="100">
			<animate attributeName="cx" calcMode="spline" dur="2" values="35;165;165;35;35"
					 keySplines="0 .1 .5 1;0 .1 .5 1;0 .1 .5 1;0 .1 .5 1" repeatCount="indefinite"
					 begin="0.05"></animate>
		</circle>
		<circle fill="#7D3C98" stroke="#7D3C98" stroke-width="15" opacity=".6" r="15" cx="35" cy="100">
			<animate attributeName="cx" calcMode="spline" dur="2" values="35;165;165;35;35"
					 keySplines="0 .1 .5 1;0 .1 .5 1;0 .1 .5 1;0 .1 .5 1" repeatCount="indefinite" begin=".1"></animate>
		</circle>
		<circle fill="#7D3C98" stroke="#7D3C98" stroke-width="15" opacity=".4" r="15" cx="35" cy="100">
			<animate attributeName="cx" calcMode='spline' dur='2' values='35;165;165;35;35'
					 keySplines='0 .1 .5 1;0 .1 .5 1;0 .1 .5 1;0 .1 .5 1' repeatCount='indefinite'
					 begin='.15'></animate>
		</circle>
		<circle fill='#7D3C98' stroke='#7D3C98' stroke-width='15' opacity='.2' r='15' cx='35' cy='100'>
			<animate attributeName='cx' calcMode='spline' dur='2' values='35;165;165;35;35'
					 keySplines='0 .1 .5 1;0 .1 .5 1;0 .1 .5 1;0 .1 .5 1' repeatCount='indefinite' begin='.2'></animate>
		</circle>
	</svg>
)
