import { __ } from '@wordpress/i18n';
import {
	Button,
	__experimentalDivider as Divider,
	__experimentalGrid as Grid
} from '@wordpress/components'
import { useDispatch, useSelect } from '@wordpress/data'
import { useState } from '@wordpress/element'
import { sendData, getBlocksData } from '../utils'
import { store as noticesStore } from '@wordpress/notices'

export default function Analyze() {
	const {createWarningNotice} = useDispatch(noticesStore);
	const { getBlocks } = useSelect((select) => {
		const { getBlocks } = select('core/block-editor')
		return { getBlocks }
	}, [])

	const [suggests, setSuggests] = useState([]);
	const [display, setDisplay] = useState(false);
	const [isBusy, setIsBusy] = useState(false);

	return (
		<Grid columns={1} gap={2}>
			<p>{__('By clicking the button below, Creator Assistant will analyze all the text and give you suggestions to improve it and make it more effective.', 'creator-assistant')}</p>
			<Button
				isBusy={isBusy}
				disabled={isBusy}
				variant={'secondary'}
				text={__('Analyze the content', 'creator-assistant')}
				onClick={async () => {
					const texts = getBlocksData(getBlocks()).map(block => block.text);
					const text = texts.join("\n").trim();

					if (text === '') {
						const message = __('No text to analyze', 'creator-assistant')
						await createWarningNotice(message, {
							type: 'snackbar',
						});

						return;
					}

					setIsBusy(true);
					setDisplay(false);

					const data = await sendData(true, '/suggest-improvements', { text });
					if (data) {
						setSuggests(data.items);
					}
					setDisplay(true);
					setIsBusy(false);
				}}
			/>
			{display && <>
				<Divider />
				<p style={{ marginBottom: 0 }}>
					<strong>{__('Here are some tips on how you can improve your content:', 'creator-assistant')}</strong>
				</p>
				<ul style={{ listStyle: 'disc', listStylePosition: 'inside' }}>
					{suggests.map(suggest => {
						return (<li>{suggest}</li>)
					})}
				</ul>
			</>}
		</Grid>
	)
}
