import { __ } from '@wordpress/i18n'
import { Button, PanelBody, PanelRow } from '@wordpress/components'
import { useDispatch } from '@wordpress/data'
import { STORE_NAME as store } from '../store/constants'

export default function Activation () {
	const {setDisplayTosModal} = useDispatch(store);

	return (
		<PanelBody title={__('Activation', 'creator-assistant')}>
			{paragraphs.map((paragraph) => (
				<PanelRow>
					<p>{paragraph}</p>
				</PanelRow>
			))}
			<PanelRow>
				<Button variant="secondary" onClick={() => setDisplayTosModal(true)}>
					{__('Terms of Service', 'creator-assistant')}
				</Button>
			</PanelRow>
		</PanelBody>
	)
}

export const paragraphs = [
	__('To access all the features of Creator Assistant, you need to have accepted the Terms of Service and Privacy Policy.', 'creator-assistant'),
]
