import {__} from "@wordpress/i18n";
import {sortByLabel} from '../../utils';

export const writingTones = sortByLabel([
    {label: __('Friendly', 'creator-assistant'), value: 'friendly'},
    {label: __('Formal', 'creator-assistant'), value: 'formal'},
    {label: __('Informal', 'creator-assistant'), value: 'informal'},
    {label: __('Professional', 'creator-assistant'), value: 'professional'},
    {label: __('Persuasive', 'creator-assistant'), value: 'persuasive'},
    {label: __('Urgent', 'creator-assistant'), value: 'urgent'},
    {label: __('Humorous', 'creator-assistant'), value: 'humorous'},
    {label: __('Serious', 'creator-assistant'), value: 'serious'},
    {label: __('Technical', 'creator-assistant'), value: 'technical'},
    {label: __('Emotional', 'creator-assistant'), value: 'emotional'},
    {label: __('Inspirational', 'creator-assistant'), value: 'inspirational'},
    {label: __('Creative', 'creator-assistant'), value: 'creative'},
    {label: __('Conversational', 'creator-assistant'), value: 'conversational'},
    {label: __('Narrative', 'creator-assistant'), value: 'narrative'},
    {label: __('Instructional', 'creator-assistant'), value: 'instructional'},
    {label: __('Academic', 'creator-assistant'), value: 'academic'},
    {label: __('Optimistic', 'creator-assistant'), value: 'optimistic'},
    {label: __('Pessimistic', 'creator-assistant'), value: 'pessimistic'},
    {label: __('Casual', 'creator-assistant'), value: 'casual'},
    {label: __('Witty', 'creator-assistant'), value: 'witty'},
    {label: __('Sophisticated', 'creator-assistant'), value: 'sophisticated'},
    {label: __('Empathetic', 'creator-assistant'), value: 'empathetic'},
    {label: __('Assertive', 'creator-assistant'), value: 'assertive'},
    {label: __('Cautious', 'creator-assistant'), value: 'cautious'},
    {label: __('Accusatory', 'creator-assistant'), value: 'accusatory'},
    {label: __('Joyful', 'creator-assistant'), value: 'joyful'},
    {label: __('Melancholic', 'creator-assistant'), value: 'melancholic'},
    {label: __('Playful', 'creator-assistant'), value: 'playful'},
    {label: __('Authoritative', 'creator-assistant'), value: 'authoritative'},
    {label: __('Accurate', 'creator-assistant'), value: 'accurate'},
    {label: __('Encouraging', 'creator-assistant'), value: 'encouraging'},
    {label: __('Thoughtful', 'creator-assistant'), value: 'thoughtful'},
    {label: __('Direct', 'creator-assistant'), value: 'direct'},
    {label: __('Inquisitive', 'creator-assistant'), value: 'inquisitive'},
    {label: __('Neutral', 'creator-assistant'), value: 'neutral'},
    {label: __('Sarcastic', 'creator-assistant'), value: 'sarcastic'},
    {label: __('Detached', 'creator-assistant'), value: 'detached'},
    {label: __('Respectful', 'creator-assistant'), value: 'respectful'}
]);

export const minTextLength = 300;
export const maxTextLength = 2000;
export const textLengthMarks = [
    { value: 300, label: __('Essential', 'creator-assistant') },
    { value: 800, label: __('General', 'creator-assistant') },
    { value: 1500, label: __('In-depth', 'creator-assistant') },
    { value: 3000, label: __('Comprehensive', 'creator-assistant') }
];

export const audienceAgeGroups = [
    {value: 'all', label: __('All Ages', 'creator-assistant')},
    {value: '3-12', label: __('Children (3-12 anni)', 'creator-assistant'),},
    {value: '13-17', label: __('Teenagers (13-17 anni)', 'creator-assistant'),},
    {value: '18-24', label: __('Young Adults (18-24 anni)', 'creator-assistant')},
    {value: '25-44', label: __('Adults (25-44 anni)', 'creator-assistant')},
    {value: '45-64', label: __('Middle-aged Adults (45-64 anni)', 'creator-assistant')},
    {value: '65+', label: __('Seniors (65+ anni)', 'creator-assistant')}
];

export const audienceGeographyGroups = [
	{value: 'custom', label: __('Custom', 'creator-assistant')},
    {value: 'global', label: __('Global', 'creator-assistant')},
    {value: 'north-america', label: __('North America', 'creator-assistant')},
    {value: 'latin-america', label: __('Latin America', 'creator-assistant')},
    {value: 'western-europe', label: __('Western Europe', 'creator-assistant')},
    {value: 'eastern-europe', label: __('Eastern Europe', 'creator-assistant')},
    {value: 'middle-east', label: __('Middle East', 'creator-assistant')},
    {value: 'north-africa', label: __('North Africa', 'creator-assistant')},
    {value: 'sub-saharan-africa', label: __('Sub-Saharan Africa', 'creator-assistant')},
    {value: 'south-asia', label: __('South Asia', 'creator-assistant')},
    {value: 'east-asia', label: __('East Asia', 'creator-assistant')},
    {value: 'southeast-asia', label: __('Southeast Asia', 'creator-assistant')},
    {value: 'oceania', label: __('Oceania', 'creator-assistant')},
];

export const contentTypes = [
    { value: 'informational-article', label: __('Informational Article', 'creator-assistant') },
    { value: 'guide-tutorial', label: __('Guide & Tutorial', 'creator-assistant') },
    { value: 'product-review', label: __('Product Review', 'creator-assistant') },
    { value: 'product-comparison', label: __('Product Comparison', 'creator-assistant') },
    { value: 'faq-responses', label: __('FAQ Responses', 'creator-assistant') }
];

export const satisfactionTones = [
    { value: 'very-high-enthusiasm', label: __('Very High Enthusiasm', 'creator-assistant') },
    { value: 'moderate-satisfaction', label: __('Moderate Satisfaction', 'creator-assistant') },
    { value: 'light-satisfaction', label: __('Light Satisfaction', 'creator-assistant') },
    { value: 'neutral', label: __('Neutral', 'creator-assistant') },
    { value: 'mild-disappointment', label: __('Mild Disappointment', 'creator-assistant') },
    { value: 'moderate-discontent', label: __('Moderate Discontent', 'creator-assistant') },
    { value: 'very-strong-dissatisfaction', label: __('Very Strong Dissatisfaction', 'creator-assistant') }
];

export const languageComplexityOptions = [
    {
        label: __('Accessible', 'creator-assistant'),
        value: 'accessible'
    },
    {
        label: __('Specialized', 'creator-assistant'),
        value: 'specialized'
    }
];

export const languageComplexityHelpOptions = {
    'accessible': __('Suitable for a broad audience, uses clear and straightforward language.', 'creator-assistant'),
    'specialized': __('Ideal for readers with industry knowledge, includes advanced terminology and concepts.', 'creator-assistant')
};
