<?php
/**
 * Creator Assistant
 *
 * @package           CreatorAssistant
 * @author            Alessandro Lioce
 * @copyright         2025 Alessandro Lioce
 * @license           GPL-2.0+
 *
 * @wordpress-plugin
 * Plugin Name:       Creator Assistant
 * Plugin URI:        https://www.creator-assistant.it
 * Description:       Find topics, create different types of content, summarize, improve and edit articles according to your needs.
 * Version:           1.0.1
 * Requires at least: 6.6
 * Requires PHP:      7.4
 * Author:            Alessandro Lioce
 * Author URI:        https://alessandrolioce.it/
 * License:           GPL-2.0+
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       creator-assistant
 * Domain Path:       /languages
 */

declare( strict_types=1 );

defined( 'ABSPATH' ) || die( 'Silence is Golden' );

define( 'CREATOR_ASSISTANT_IS_DEV', true === filter_var( getenv( 'CREATOR_ASSISTANT_IS_DEV' ), FILTER_VALIDATE_BOOLEAN ) );

require_once plugin_dir_path( __FILE__ ) . 'class-plugin.php';
require_once plugin_dir_path( __FILE__ ) . 'class-editor.php';
require_once plugin_dir_path( __FILE__ ) . 'class-api-handler.php';

CreatorAssistant\Plugin::init();
CreatorAssistant\Editor::init();
CreatorAssistant\Api_Handler::init();
