<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.creamailer.fi
 * @since      1.0.0
 *
 * @package    Creamailer
 * @subpackage Creamailer/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Creamailer
 * @subpackage Creamailer/public
 * @author     Creamailer <info@creamailer.fi>
 */
class Creamailer_For_NinjaForms_Public
{
    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    private $settings;

    /**
     * Initialize the class and set its properties.
     *
     * @param string $plugin_name The name of the plugin.
     * @param string $version The version of this plugin.
     * @since    1.0.0
     */
    public function __construct($plugin_name, $version)
    {
        $this->settings = get_option( 'creamailer-for-ninja-forms' );

        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public function register_creamailer_ninja_forms_fields($fields)
    {
        $fields['creamailer_for_ninja_forms_field'] = new CreamailerForNinjaFormsField();

        return $fields;
    }

    public function register_creamailer_ninja_forms_actions($actions)
    {
        $actions['creamailer_for_ninja_forms_action'] = new CreamailerForNinjaFormsAction();

        return $actions;
    }
}
